# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Personalize Events
#'
#' @description
#' Amazon Personalize can consume real-time user event data, such as
#' *stream* or *click* data, and use it for model training either alone or
#' combined with historical data. For more information see
#' recording-events.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- personalizeevents(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- personalizeevents()
#' svc$put_events(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=personalizeevents_put_events]{put_events} \tab Records user interaction event data\cr
#'  \link[=personalizeevents_put_items]{put_items} \tab Adds one or more items to an Items dataset\cr
#'  \link[=personalizeevents_put_users]{put_users} \tab Adds one or more users to a Users dataset
#' }
#'
#' @rdname personalizeevents
#' @export
personalizeevents <- function(config = list()) {
  svc <- .personalizeevents$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.personalizeevents <- list()

.personalizeevents$operations <- list()

.personalizeevents$metadata <- list(
  service_name = "personalizeevents",
  endpoints = list("*" = list(endpoint = "personalize-events.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "personalize-events.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "personalize-events.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "personalize-events.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Personalize Events",
  api_version = "2018-03-22",
  signing_name = "personalize",
  json_version = "1.1",
  target_prefix = ""
)

.personalizeevents$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.personalizeevents$metadata, handlers, config)
}
