% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_describe_events_detection_job}
\alias{comprehend_describe_events_detection_job}
\title{Gets the status and details of an events detection job}
\usage{
comprehend_describe_events_detection_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier of the events detection job.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventsDetectionJobProperties = list(
    JobId = "string",
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    Message = "string",
    SubmitTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    InputDataConfig = list(
      S3Uri = "string",
      InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
    ),
    OutputDataConfig = list(
      S3Uri = "string",
      KmsKeyId = "string"
    ),
    LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
    DataAccessRoleArn = "string",
    TargetEventTypes = list(
      "string"
    )
  )
)
}
}
\description{
Gets the status and details of an events detection job.
}
\section{Request syntax}{
\preformatted{svc$describe_events_detection_job(
  JobId = "string"
)
}
}

\keyword{internal}
