% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_campaigns}
\alias{personalize_list_campaigns}
\title{Returns a list of campaigns that use the given solution}
\usage{
personalize_list_campaigns(solutionArn, nextToken, maxResults)
}
\arguments{
\item{solutionArn}{The Amazon Resource Name (ARN) of the solution to list the campaigns
for. When a solution is not specified, all the campaigns associated with
the account are listed.}

\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_campaigns]{list_campaigns}} for getting the next set
of campaigns (if they exist).}

\item{maxResults}{The maximum number of campaigns to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  campaigns = list(
    list(
      name = "string",
      campaignArn = "string",
      status = "string",
      creationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      failureReason = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns a list of campaigns that use the given solution. When a solution
is not specified, all the campaigns associated with the account are
listed. The response provides the properties for each campaign,
including the Amazon Resource Name (ARN). For more information on
campaigns, see \code{\link[=personalize_create_campaign]{create_campaign}}.
}
\section{Request syntax}{
\preformatted{svc$list_campaigns(
  solutionArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
