% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_feature_group}
\alias{sagemaker_delete_feature_group}
\title{Delete the FeatureGroup and any data that was written to the OnlineStore
of the FeatureGroup}
\usage{
sagemaker_delete_feature_group(FeatureGroupName)
}
\arguments{
\item{FeatureGroupName}{[required] The name of the \code{FeatureGroup} you want to delete. The name must be
unique within an AWS Region in an AWS account.}
}
\value{
An empty list.
}
\description{
Delete the \code{FeatureGroup} and any data that was written to the
\code{OnlineStore} of the \code{FeatureGroup}. Data cannot be accessed from the
\code{OnlineStore} immediately after
\code{\link[=sagemaker_delete_feature_group]{delete_feature_group}} is called.

Data written into the \code{OfflineStore} will not be deleted. The AWS Glue
database and tables that are automatically created for your
\code{OfflineStore} are not deleted.
}
\section{Request syntax}{
\preformatted{svc$delete_feature_group(
  FeatureGroupName = "string"
)
}
}

\keyword{internal}
