% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_list_topics_detection_jobs}
\alias{comprehend_list_topics_detection_jobs}
\title{Gets a list of the topic detection jobs that you have submitted}
\usage{
comprehend_list_topics_detection_jobs(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{Filters the jobs that are returned. Jobs can be filtered on their name,
status, or the date and time that they were submitted. You can set only
one filter at a time.}

\item{NextToken}{Identifies the next page of results to return.}

\item{MaxResults}{The maximum number of results to return in each page. The default is
100.}
}
\value{
A list with the following syntax:\preformatted{list(
  TopicsDetectionJobPropertiesList = list(
    list(
      JobId = "string",
      JobName = "string",
      JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
      Message = "string",
      SubmitTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      InputDataConfig = list(
        S3Uri = "string",
        InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
      ),
      OutputDataConfig = list(
        S3Uri = "string",
        KmsKeyId = "string"
      ),
      NumberOfTopics = 123,
      DataAccessRoleArn = "string",
      VolumeKmsKeyId = "string",
      VpcConfig = list(
        SecurityGroupIds = list(
          "string"
        ),
        Subnets = list(
          "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the topic detection jobs that you have submitted.
}
\section{Request syntax}{
\preformatted{svc$list_topics_detection_jobs(
  Filter = list(
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    SubmitTimeBefore = as.POSIXct(
      "2015-01-01"
    ),
    SubmitTimeAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
