% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_transform_job}
\alias{sagemaker_create_transform_job}
\title{Starts a transform job}
\usage{
sagemaker_create_transform_job(TransformJobName, ModelName,
  MaxConcurrentTransforms, MaxPayloadInMB, BatchStrategy, Environment,
  TransformInput, TransformOutput, TransformResources, DataProcessing,
  Tags)
}
\arguments{
\item{TransformJobName}{[required] The name of the transform job. The name must be unique within an AWS
Region in an AWS account.}

\item{ModelName}{[required] The name of the model that you want to use for the transform job.
\code{ModelName} must be the name of an existing Amazon SageMaker model
within an AWS Region in an AWS account.}

\item{MaxConcurrentTransforms}{The maximum number of parallel requests that can be sent to each
instance in a transform job. If \code{MaxConcurrentTransforms} is set to \code{0}
or left unset, Amazon SageMaker checks the optional execution-parameters
to determine the optimal settings for your chosen algorithm. If the
execution-parameters endpoint is not enabled, the default value is \code{1}.
For more information on execution-parameters, see \href{http://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests}{How Containers Serve Requests}.
For built-in algorithms, you don't need to set a value for
\code{MaxConcurrentTransforms}.}

\item{MaxPayloadInMB}{The maximum allowed size of the payload, in MB. A \emph{payload} is the data
portion of a record (without metadata). The value in \code{MaxPayloadInMB}
must be greater than, or equal to, the size of a single record. To
estimate the size of a record in MB, divide the size of your dataset by
the number of records. To ensure that the records fit within the maximum
payload size, we recommend using a slightly larger value. The default
value is \code{6} MB.

For cases where the payload might be arbitrarily large and is
transmitted using HTTP chunked encoding, set the value to \code{0}. This
feature works only in supported algorithms. Currently, Amazon SageMaker
built-in algorithms do not support HTTP chunked encoding.}

\item{BatchStrategy}{Specifies the number of records to include in a mini-batch for an HTTP
inference request. A \emph{record} is a single unit of input data that
inference can be made on. For example, a single line in a CSV file is a
record.

To enable the batch strategy, you must set \code{SplitType} to \code{Line},
\code{RecordIO}, or \code{TFRecord}.

To use only one record when making an HTTP invocation request to a
container, set \code{BatchStrategy} to \code{SingleRecord} and \code{SplitType} to
\code{Line}.

To fit as many records in a mini-batch as can fit within the
\code{MaxPayloadInMB} limit, set \code{BatchStrategy} to \code{MultiRecord} and
\code{SplitType} to \code{Line}.}

\item{Environment}{The environment variables to set in the Docker container. We support up
to 16 key and values entries in the map.}

\item{TransformInput}{[required] Describes the input source and the way the transform job consumes it.}

\item{TransformOutput}{[required] Describes the results of the transform job.}

\item{TransformResources}{[required] Describes the resources, including ML instance types and ML instance
count, to use for the transform job.}

\item{DataProcessing}{The data structure used for combining the input data and inference in
the output file. For more information, see \href{http://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-io-join.html}{Batch Transform I/O Join}.}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.}
}
\description{
Starts a transform job. A transform job uses a trained model to get
inferences on a dataset and saves these results to an Amazon S3 location
that you specify.
}
\details{
To perform batch transformations, you create a transform job and use the
data that you have readily available.

In the request body, you provide the following:
\itemize{
\item \code{TransformJobName} - Identifies the transform job. The name must be
unique within an AWS Region in an AWS account.
\item \code{ModelName} - Identifies the model to use. \code{ModelName} must be the
name of an existing Amazon SageMaker model in the same AWS Region
and AWS account. For information on creating a model, see
CreateModel.
\item \code{TransformInput} - Describes the dataset to be transformed and the
Amazon S3 location where it is stored.
\item \code{TransformOutput} - Identifies the Amazon S3 location where you want
Amazon SageMaker to save the results from the transform job.
\item \code{TransformResources} - Identifies the ML compute instances for the
transform job.
}

For more information about how batch transformation works Amazon
SageMaker, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html}{How It Works}.
}
\section{Request syntax}{
\preformatted{svc$create_transform_job(
  TransformJobName = "string",
  ModelName = "string",
  MaxConcurrentTransforms = 123,
  MaxPayloadInMB = 123,
  BatchStrategy = "MultiRecord"|"SingleRecord",
  Environment = list(
    "string"
  ),
  TransformInput = list(
    DataSource = list(
      S3DataSource = list(
        S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
        S3Uri = "string"
      )
    ),
    ContentType = "string",
    CompressionType = "None"|"Gzip",
    SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
  ),
  TransformOutput = list(
    S3OutputPath = "string",
    Accept = "string",
    AssembleWith = "None"|"Line",
    KmsKeyId = "string"
  ),
  TransformResources = list(
    InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
    InstanceCount = 123,
    VolumeKmsKeyId = "string"
  ),
  DataProcessing = list(
    InputFilter = "string",
    OutputFilter = "string",
    JoinSource = "Input"|"None"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
