% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_forecast}
\alias{forecastservice_create_forecast}
\title{Creates a forecast for each item in the TARGET_TIME_SERIES dataset that
was used to train the predictor}
\usage{
forecastservice_create_forecast(
  ForecastName,
  PredictorArn,
  ForecastTypes = NULL,
  Tags = NULL,
  TimeSeriesSelector = NULL
)
}
\arguments{
\item{ForecastName}{[required] A name for the forecast.}

\item{PredictorArn}{[required] The Amazon Resource Name (ARN) of the predictor to use to generate the
forecast.}

\item{ForecastTypes}{The quantiles at which probabilistic forecasts are generated. \strong{You can
currently specify up to 5 quantiles per forecast}. Accepted values
include \verb{0.01 to 0.99} (increments of .01 only) and \code{mean}. The mean
forecast is different from the median (0.50) when the distribution is
not symmetric (for example, Beta and Negative Binomial).

The default quantiles are the quantiles you specified during predictor
creation. If you didn't specify quantiles, the default values are
\verb{["0.1", "0.5", "0.9"]}.}

\item{Tags}{The optional metadata that you apply to the forecast to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for keys as it is reserved for AWS use. You cannot
edit or delete tag keys with this prefix. Values can have this
prefix. If a tag value has \code{aws} as its prefix but the key does not,
then Forecast considers it to be a user tag and will count against
the limit of 50 tags. Tags with only the key prefix of \code{aws} do not
count against your tags per resource limit.
}}

\item{TimeSeriesSelector}{Defines the set of time series that are used to create the forecasts in
a \code{TimeSeriesIdentifiers} object.

The \code{TimeSeriesIdentifiers} object needs the following information:
\itemize{
\item \code{DataSource}
\item \code{Format}
\item \code{Schema}
}}
}
\description{
Creates a forecast for each item in the \code{TARGET_TIME_SERIES} dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the \code{\link[=forecastservice_create_forecast_export_job]{create_forecast_export_job}} operation.

See \url{https://paws-r.github.io/docs/forecastservice/create_forecast.html} for full documentation.
}
\keyword{internal}
