% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_variable}
\alias{frauddetector_create_variable}
\title{Creates a variable}
\usage{
frauddetector_create_variable(
  name,
  dataType,
  dataSource,
  defaultValue,
  description = NULL,
  variableType = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name of the variable.}

\item{dataType}{[required] The data type.}

\item{dataSource}{[required] The source of the data.}

\item{defaultValue}{[required] The default value for the variable when no value is received.}

\item{description}{The description.}

\item{variableType}{The variable type. For more information see \href{https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types}{Variable types}.

Valid Values:
\code{AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT}}

\item{tags}{A collection of key and value pairs.}
}
\description{
Creates a variable.

See \url{https://paws-r.github.io/docs/frauddetector/create_variable.html} for full documentation.
}
\keyword{internal}
