% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_update_slot_type}
\alias{lexmodelsv2_update_slot_type}
\title{Updates the configuration of an existing slot type}
\usage{
lexmodelsv2_update_slot_type(
  slotTypeId,
  slotTypeName,
  description = NULL,
  slotTypeValues = NULL,
  valueSelectionSetting = NULL,
  parentSlotTypeSignature = NULL,
  botId,
  botVersion,
  localeId,
  externalSourceSetting = NULL
)
}
\arguments{
\item{slotTypeId}{[required] The unique identifier of the slot type to update.}

\item{slotTypeName}{[required] The new name of the slot type.}

\item{description}{The new description of the slot type.}

\item{slotTypeValues}{A new list of values and their optional synonyms that define the values
that the slot type can take.}

\item{valueSelectionSetting}{The strategy that Amazon Lex should use when deciding on a value from
the list of slot type values.}

\item{parentSlotTypeSignature}{The new built-in slot type that should be used as the parent of this
slot type.}

\item{botId}{[required] The identifier of the bot that contains the slot type.}

\item{botVersion}{[required] The version of the bot that contains the slot type. Must be \code{DRAFT}.}

\item{localeId}{[required] The identifier of the language and locale that contains the slot type.
The string must match one of the supported locales. For more
information, see \href{https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html}{Supported languages}.}

\item{externalSourceSetting}{}
}
\description{
Updates the configuration of an existing slot type.

See \url{https://paws-r.github.io/docs/lexmodelsv2/update_slot_type.html} for full documentation.
}
\keyword{internal}
