% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_inference_recommendations_job}
\alias{sagemaker_create_inference_recommendations_job}
\title{Starts a recommendation job}
\usage{
sagemaker_create_inference_recommendations_job(
  JobName,
  JobType,
  RoleArn,
  InputConfig,
  JobDescription = NULL,
  StoppingConditions = NULL,
  OutputConfig = NULL,
  Tags = NULL
)
}
\arguments{
\item{JobName}{[required] A name for the recommendation job. The name must be unique within the
Amazon Web Services Region and within your Amazon Web Services account.}

\item{JobType}{[required] Defines the type of recommendation job. Specify \code{Default} to initiate an
instance recommendation and \code{Advanced} to initiate a load test. If left
unspecified, Amazon SageMaker Inference Recommender will run an instance
recommendation (\code{DEFAULT}) job.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that enables Amazon
SageMaker to perform tasks on your behalf.}

\item{InputConfig}{[required] Provides information about the versioned model package Amazon Resource
Name (ARN), the traffic pattern, and endpoint configurations.}

\item{JobDescription}{Description of the recommendation job.}

\item{StoppingConditions}{A set of conditions for stopping a recommendation job. If any of the
conditions are met, the job is automatically stopped.}

\item{OutputConfig}{Provides information about the output artifacts and the KMS key to use
for Amazon S3 server-side encryption.}

\item{Tags}{The metadata that you apply to Amazon Web Services resources to help you
categorize and organize them. Each tag consists of a key and a value,
both of which you define. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging Amazon Web Services Resources}
in the Amazon Web Services General Reference.}
}
\description{
Starts a recommendation job. You can create either an instance recommendation or load test job.

See \url{https://paws-r.github.io/docs/sagemaker/create_inference_recommendations_job.html} for full documentation.
}
\keyword{internal}
