% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_put_project_policy}
\alias{rekognition_put_project_policy}
\title{Attaches a project policy to a Amazon Rekognition Custom Labels project
in a trusting AWS account}
\usage{
rekognition_put_project_policy(
  ProjectArn,
  PolicyName,
  PolicyRevisionId = NULL,
  PolicyDocument
)
}
\arguments{
\item{ProjectArn}{[required] The Amazon Resource Name (ARN) of the project that the project policy is
attached to.}

\item{PolicyName}{[required] A name for the policy.}

\item{PolicyRevisionId}{The revision ID for the Project Policy. Each time you modify a policy,
Amazon Rekognition Custom Labels generates and assigns a new
\code{PolicyRevisionId} and then deletes the previous version of the policy.}

\item{PolicyDocument}{[required] A resource policy to add to the model. The policy is a JSON structure
that contains one or more statements that define the policy. The policy
must follow the IAM syntax. For more information about the contents of a
JSON policy document, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON policy reference}.}
}
\description{
Attaches a project policy to a Amazon Rekognition Custom Labels project in a trusting AWS account. A project policy specifies that a trusted AWS account can copy a model version from a trusting AWS account to a project in the trusted AWS account. To copy a model version you use the \code{\link[=rekognition_copy_project_version]{copy_project_version}} operation.

See \url{https://www.paws-r-sdk.com/docs/rekognition_put_project_policy/} for full documentation.
}
\keyword{internal}
