% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_endpoint_weights_and_capacities}
\alias{sagemaker_update_endpoint_weights_and_capacities}
\title{Updates variant weight of one or more variants associated with an
existing endpoint, or capacity of one variant associated with an
existing endpoint}
\usage{
sagemaker_update_endpoint_weights_and_capacities(
  EndpointName,
  DesiredWeightsAndCapacities
)
}
\arguments{
\item{EndpointName}{[required] The name of an existing SageMaker endpoint.}

\item{DesiredWeightsAndCapacities}{[required] An object that provides new capacity and weight values for a variant.}
}
\description{
Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to \code{Updating}. After updating the endpoint, it sets the status to \code{InService}. To check the status of an endpoint, use the \code{\link[=sagemaker_describe_endpoint]{describe_endpoint}} API.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_endpoint_weights_and_capacities/} for full documentation.
}
\keyword{internal}
