% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_language_models}
\alias{transcribeservice_list_language_models}
\title{Provides a list of custom language models that match the specified
criteria}
\usage{
transcribeservice_list_language_models(
  StatusEquals = NULL,
  NameContains = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{StatusEquals}{Returns only custom language models with the specified status. Language
models are ordered by creation date, with the newest model first. If you
don't include \code{StatusEquals}, all custom language models are returned.}

\item{NameContains}{Returns only the custom language models that contain the specified
string. The search is not case sensitive.}

\item{NextToken}{If your \code{\link[=transcribeservice_list_language_models]{list_language_models}}
request returns more results than can be displayed, \code{NextToken} is
displayed in the response with an associated string. To get the next
page of results, copy this string and repeat your request, including
\code{NextToken} with the value of the copied string. Repeat as needed to
view all your results.}

\item{MaxResults}{The maximum number of custom language models to return in each page of
results. If there are fewer results than the value that you specify,
only the actual results are returned. If you don't specify a value, a
default of 5 is used.}
}
\description{
Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.

See \url{https://www.paws-r-sdk.com/docs/transcribeservice_list_language_models/} for full documentation.
}
\keyword{internal}
