% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_projects}
\alias{sagemaker_list_projects}
\title{Gets a list of the projects in an Amazon Web Services account}
\usage{
sagemaker_list_projects(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns the projects that were created after a specified
time.}

\item{CreationTimeBefore}{A filter that returns the projects that were created before a specified
time.}

\item{MaxResults}{The maximum number of projects to return in the response.}

\item{NameContains}{A filter that returns the projects whose name contains a specified
string.}

\item{NextToken}{If the result of the previous \code{\link[=sagemaker_list_projects]{list_projects}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of projects, use the token in the next request.}

\item{SortBy}{The field by which to sort results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\description{
Gets a list of the projects in an Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_projects/} for full documentation.
}
\keyword{internal}
