% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_update_agent_knowledge_base}
\alias{bedrockagent_update_agent_knowledge_base}
\title{Updates the configuration for a knowledge base that has been associated
with an agent}
\usage{
bedrockagent_update_agent_knowledge_base(
  agentId,
  agentVersion,
  description = NULL,
  knowledgeBaseId,
  knowledgeBaseState = NULL
)
}
\arguments{
\item{agentId}{[required] The unique identifier of the agent associated with the knowledge base
that you want to update.}

\item{agentVersion}{[required] The version of the agent associated with the knowledge base that you
want to update.}

\item{description}{Specifies a new description for the knowledge base associated with an
agent.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base that has been associated
with an agent.}

\item{knowledgeBaseState}{Specifies whether the agent uses the knowledge base or not when sending
an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html}{InvokeAgent}
request.}
}
\description{
Updates the configuration for a knowledge base that has been associated with an agent.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_knowledge_base/} for full documentation.
}
\keyword{internal}
