% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model_explainability_job_definition}
\alias{sagemaker_create_model_explainability_job_definition}
\title{Creates the definition for a model explainability job}
\usage{
sagemaker_create_model_explainability_job_definition(
  JobDefinitionName,
  ModelExplainabilityBaselineConfig = NULL,
  ModelExplainabilityAppSpecification,
  ModelExplainabilityJobInput,
  ModelExplainabilityJobOutputConfig,
  JobResources,
  NetworkConfig = NULL,
  RoleArn,
  StoppingCondition = NULL,
  Tags = NULL
)
}
\arguments{
\item{JobDefinitionName}{[required] The name of the model explainability job definition. The name must be
unique within an Amazon Web Services Region in the Amazon Web Services
account.}

\item{ModelExplainabilityBaselineConfig}{The baseline configuration for a model explainability job.}

\item{ModelExplainabilityAppSpecification}{[required] Configures the model explainability job to run a specified Docker
container image.}

\item{ModelExplainabilityJobInput}{[required] Inputs for the model explainability job.}

\item{ModelExplainabilityJobOutputConfig}{[required]}

\item{JobResources}{[required]}

\item{NetworkConfig}{Networking options for a model explainability job.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
can assume to perform tasks on your behalf.}

\item{StoppingCondition}{}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL}{Using Cost Allocation Tags}
in the \emph{Amazon Web Services Billing and Cost Management User Guide}.}
}
\description{
Creates the definition for a model explainability job.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_model_explainability_job_definition/} for full documentation.
}
\keyword{internal}
