% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_auto_scaling_groups}
\alias{autoscaling_describe_auto_scaling_groups}
\title{Describes one or more Auto Scaling groups}
\usage{
autoscaling_describe_auto_scaling_groups(AutoScalingGroupNames,
  NextToken, MaxRecords)
}
\arguments{
\item{AutoScalingGroupNames}{The names of the Auto Scaling groups. Each name can be a maximum of 1600
characters. By default, you can only specify up to 50 names. You can
optionally increase this limit using the \code{MaxRecords} parameter.

If you omit this parameter, all Auto Scaling groups are described.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The default value
is \code{50} and the maximum value is \code{100}.}
}
\description{
Describes one or more Auto Scaling groups.
}
\section{Request syntax}{
\preformatted{svc$describe_auto_scaling_groups(
  AutoScalingGroupNames = list(
    "string"
  ),
  NextToken = "string",
  MaxRecords = 123
)
}
}

\examples{
# This example describes the specified Auto Scaling group.
\donttest{svc$describe_auto_scaling_groups(
  AutoScalingGroupNames = list(
    "my-auto-scaling-group"
  )
)}

}
\keyword{internal}
