% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_execute_policy}
\alias{autoscaling_execute_policy}
\title{Executes the specified policy}
\usage{
autoscaling_execute_policy(AutoScalingGroupName, PolicyName,
  HonorCooldown, MetricValue, BreachThreshold)
}
\arguments{
\item{AutoScalingGroupName}{The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name or ARN of the policy.}

\item{HonorCooldown}{Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
to complete before executing the policy.

Valid only if the policy type is \code{SimpleScaling}. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling cooldowns for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MetricValue}{The metric value to compare to \code{BreachThreshold}. This enables you to
execute a policy of type \code{StepScaling} and determine which step
adjustment to use. For example, if the breach threshold is 50 and you
want to use a step adjustment with a lower bound of 0 and an upper bound
of 10, you can set the metric value to 59.

If you specify a metric value that doesn't correspond to a step
adjustment for the policy, the call returns an error.

Required if the policy type is \code{StepScaling} and not supported
otherwise.}

\item{BreachThreshold}{The breach threshold for the alarm.

Required if the policy type is \code{StepScaling} and not supported
otherwise.}
}
\description{
Executes the specified policy. This can be useful for testing the design
of your scaling policy.
}
\section{Request syntax}{
\preformatted{svc$execute_policy(
  AutoScalingGroupName = "string",
  PolicyName = "string",
  HonorCooldown = TRUE|FALSE,
  MetricValue = 123.0,
  BreachThreshold = 123.0
)
}
}

\examples{
\dontrun{
# This example executes the specified policy.
svc$execute_policy(
  AutoScalingGroupName = "my-auto-scaling-group",
  BreachThreshold = 50,
  MetricValue = 59,
  PolicyName = "my-step-scale-out-policy"
)
}

}
\keyword{internal}
