% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_detect_stack_set_drift}
\alias{cloudformation_detect_stack_set_drift}
\title{Detect drift on a stack set}
\usage{
cloudformation_detect_stack_set_drift(StackSetName,
  OperationPreferences, OperationId)
}
\arguments{
\item{StackSetName}{[required] The name of the stack set on which to perform the drift detection
operation.}

\item{OperationPreferences}{}

\item{OperationId}{\emph{The ID of the stack set operation.}}
}
\description{
Detect drift on a stack set. When CloudFormation performs drift
detection on a stack set, it performs drift detection on the stack
associated with each stack instance in the stack set. For more
information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html}{How CloudFormation Performs Drift Detection on a Stack Set}.

\code{DetectStackSetDrift} returns the \code{OperationId} of the stack set drift
detection operation. Use this operation id with
\verb{<a>DescribeStackSetOperation</a>} to monitor the progress of the
drift detection operation. The drift detection operation may take some
time, depending on the number of stack instances included in the stack
set, as well as the number of resources included in each stack.

Once the operation has completed, use the following actions to return
drift information:
\itemize{
\item Use \verb{<a>DescribeStackSet</a>} to return detailed informaiton about
the stack set, including detailed information about the last
\emph{completed} drift operation performed on the stack set. (Information
about drift operations that are in progress is not included.)
\item Use \verb{<a>ListStackInstances</a>} to return a list of stack
instances belonging to the stack set, including the drift status and
last drift time checked of each instance.
\item Use \verb{<a>DescribeStackInstance</a>} to return detailed information
about a specific stack instance, including its drift status and last
drift time checked.
}

For more information on performing a drift detection operation on a
stack set, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html}{Detecting Unmanaged Changes in Stack Sets}.

You can only run a single drift detection operation on a given stack set
at one time.

To stop a drift detection stack set operation, use
\verb{<a>StopStackSetOperation</a>}.
}
\section{Request syntax}{
\preformatted{svc$detect_stack_set_drift(
  StackSetName = "string",
  OperationPreferences = list(
    RegionOrder = list(
      "string"
    ),
    FailureToleranceCount = 123,
    FailureTolerancePercentage = 123,
    MaxConcurrentCount = 123,
    MaxConcurrentPercentage = 123
  ),
  OperationId = "string"
)
}
}

\keyword{internal}
