% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_start_query}
\alias{cloudwatchlogs_start_query}
\title{Schedules a query of a log group using CloudWatch Logs Insights}
\usage{
cloudwatchlogs_start_query(logGroupName, logGroupNames, startTime,
  endTime, queryString, limit)
}
\arguments{
\item{logGroupName}{The log group on which to perform the query.

A \code{StartQuery} operation must include a \code{logGroupNames} or a
\code{logGroupName} parameter, but not both.}

\item{logGroupNames}{The list of log groups to be queried. You can include up to 20 log
groups.

A \code{StartQuery} operation must include a \code{logGroupNames} or a
\code{logGroupName} parameter, but not both.}

\item{startTime}{[required] The beginning of the time range to query. The range is inclusive, so the
specified start time is included in the query. Specified as epoch time,
the number of seconds since January 1, 1970, 00:00:00 UTC.}

\item{endTime}{[required] The end of the time range to query. The range is inclusive, so the
specified end time is included in the query. Specified as epoch time,
the number of seconds since January 1, 1970, 00:00:00 UTC.}

\item{queryString}{[required] The query string to use. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html}{CloudWatch Logs Insights Query Syntax}.}

\item{limit}{The maximum number of log events to return in the query. If the query
string uses the \code{fields} command, only the specified fields and their
values are returned. The default is 1000.}
}
\description{
Schedules a query of a log group using CloudWatch Logs Insights. You
specify the log group and time range to query and the query string to
use.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html}{CloudWatch Logs Insights Query Syntax}.

Queries time out after 15 minutes of execution. If your queries are
timing out, reduce the time range being searched or partition your query
into a number of queries.
}
\section{Request syntax}{
\preformatted{svc$start_query(
  logGroupName = "string",
  logGroupNames = list(
    "string"
  ),
  startTime = 123,
  endTime = 123,
  queryString = "string",
  limit = 123
)
}
}

\keyword{internal}
