% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_checkout_license}
\alias{licensemanager_checkout_license}
\title{Checks out the specified license}
\usage{
licensemanager_checkout_license(ProductSKU, CheckoutType,
  KeyFingerprint, Entitlements, ClientToken, Beneficiary, NodeId)
}
\arguments{
\item{ProductSKU}{[required] Product SKU.}

\item{CheckoutType}{[required] Checkout type.}

\item{KeyFingerprint}{[required] Key fingerprint identifying the license.}

\item{Entitlements}{[required] License entitlements.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{Beneficiary}{License beneficiary.}

\item{NodeId}{Node ID.}
}
\description{
Checks out the specified license.
}
\section{Request syntax}{
\preformatted{svc$checkout_license(
  ProductSKU = "string",
  CheckoutType = "PROVISIONAL",
  KeyFingerprint = "string",
  Entitlements = list(
    list(
      Name = "string",
      Value = "string",
      Unit = "Count"|"None"|"Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"
    )
  ),
  ClientToken = "string",
  Beneficiary = "string",
  NodeId = "string"
)
}
}

\keyword{internal}
