% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_ungroup_resources}
\alias{resourcegroups_ungroup_resources}
\title{Removes the specified resources from the specified group}
\usage{
resourcegroups_ungroup_resources(Group, ResourceArns)
}
\arguments{
\item{Group}{[required] The name or the ARN of the resource group from which to remove the
resources.}

\item{ResourceArns}{[required] The ARNs of the resources to be removed from the group.}
}
\value{
A list with the following syntax:\preformatted{list(
  Succeeded = list(
    "string"
  ),
  Failed = list(
    list(
      ResourceArn = "string",
      ErrorMessage = "string",
      ErrorCode = "string"
    )
  ),
  Pending = list(
    list(
      ResourceArn = "string"
    )
  )
)
}
}
\description{
Removes the specified resources from the specified group.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item \code{resource-groups:UngroupResources}
}
}
\section{Request syntax}{
\preformatted{svc$ungroup_resources(
  Group = "string",
  ResourceArns = list(
    "string"
  )
)
}
}

\keyword{internal}
