# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Service Quotas
#'
#' @description
#' With Service Quotas, you can view and manage your quotas easily as your
#' AWS workloads grow. Quotas, also referred to as limits, are the maximum
#' number of resources that you can create in your AWS account. For more
#' information, see the [Service Quotas User
#' Guide](https://docs.aws.amazon.com/servicequotas/latest/userguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- servicequotas(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- servicequotas()
#' svc$associate_service_quota_template(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=servicequotas_associate_service_quota_template]{associate_service_quota_template} \tab Associates your quota request template with your organization\cr
#'  \link[=servicequotas_delete_service_quota_increase_request_from_template]{delete_service_quota_increase_request_from_template} \tab Deletes the quota increase request for the specified quota from your quota request template\cr
#'  \link[=servicequotas_disassociate_service_quota_template]{disassociate_service_quota_template} \tab Disables your quota request template\cr
#'  \link[=servicequotas_get_association_for_service_quota_template]{get_association_for_service_quota_template} \tab Retrieves the status of the association for the quota request template\cr
#'  \link[=servicequotas_get_aws_default_service_quota]{get_aws_default_service_quota} \tab Retrieves the default value for the specified quota\cr
#'  \link[=servicequotas_get_requested_service_quota_change]{get_requested_service_quota_change} \tab Retrieves information about the specified quota increase request\cr
#'  \link[=servicequotas_get_service_quota]{get_service_quota} \tab Retrieves the applied quota value for the specified quota\cr
#'  \link[=servicequotas_get_service_quota_increase_request_from_template]{get_service_quota_increase_request_from_template} \tab Retrieves information about the specified quota increase request in your quota request template\cr
#'  \link[=servicequotas_list_aws_default_service_quotas]{list_aws_default_service_quotas} \tab Lists the default values for the quotas for the specified AWS service\cr
#'  \link[=servicequotas_list_requested_service_quota_change_history]{list_requested_service_quota_change_history} \tab Retrieves the quota increase requests for the specified service\cr
#'  \link[=servicequotas_list_requested_service_quota_change_history_by_quota]{list_requested_service_quota_change_history_by_quota} \tab Retrieves the quota increase requests for the specified quota\cr
#'  \link[=servicequotas_list_service_quota_increase_requests_in_template]{list_service_quota_increase_requests_in_template} \tab Lists the quota increase requests in the specified quota request template\cr
#'  \link[=servicequotas_list_service_quotas]{list_service_quotas} \tab Lists the applied quota values for the specified AWS service\cr
#'  \link[=servicequotas_list_services]{list_services} \tab Lists the names and codes for the services integrated with Service Quotas\cr
#'  \link[=servicequotas_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags assigned to the specified applied quota\cr
#'  \link[=servicequotas_put_service_quota_increase_request_into_template]{put_service_quota_increase_request_into_template} \tab Adds a quota increase request to your quota request template\cr
#'  \link[=servicequotas_request_service_quota_increase]{request_service_quota_increase} \tab Submits a quota increase request for the specified quota\cr
#'  \link[=servicequotas_tag_resource]{tag_resource} \tab Adds tags to the specified applied quota\cr
#'  \link[=servicequotas_untag_resource]{untag_resource} \tab Removes tags from the specified applied quota
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname servicequotas
#' @export
servicequotas <- function(config = list()) {
  svc <- .servicequotas$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.servicequotas <- list()

.servicequotas$operations <- list()

.servicequotas$metadata <- list(
  service_name = "servicequotas",
  endpoints = list("*" = list(endpoint = "servicequotas.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "servicequotas.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "servicequotas.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "servicequotas.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Service Quotas",
  api_version = "2019-06-24",
  signing_name = "servicequotas",
  json_version = "1.1",
  target_prefix = "ServiceQuotasV20190624"
)

.servicequotas$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.servicequotas$metadata, handlers, config)
}
