% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_subscription_filter}
\alias{cloudwatchlogs_put_subscription_filter}
\title{Creates or updates a subscription filter and associates it with the
specified log group}
\usage{
cloudwatchlogs_put_subscription_filter(logGroupName, filterName,
  filterPattern, destinationArn, roleArn, distribution)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{filterName}{[required] A name for the subscription filter. If you are updating an existing
filter, you must specify the correct name in \code{filterName}. Otherwise,
the call fails because you cannot associate a second filter with a log
group. To find the name of the filter currently associated with a log
group, use DescribeSubscriptionFilters.}

\item{filterPattern}{[required] A filter pattern for subscribing to a filtered stream of log events.}

\item{destinationArn}{[required] The ARN of the destination to deliver matching log events to. Currently,
the supported destinations are:
\itemize{
\item An Amazon Kinesis stream belonging to the same account as the
subscription filter, for same-account delivery.
\item A logical destination (specified using an ARN) belonging to a
different account, for cross-account delivery.
\item An Amazon Kinesis Firehose delivery stream belonging to the same
account as the subscription filter, for same-account delivery.
\item An AWS Lambda function belonging to the same account as the
subscription filter, for same-account delivery.
}}

\item{roleArn}{The ARN of an IAM role that grants CloudWatch Logs permissions to
deliver ingested log events to the destination stream. You don't need
to provide the ARN when you are working with a logical destination for
cross-account delivery.}

\item{distribution}{The method used to distribute log data to the destination. By default
log data is grouped by log stream, but the grouping can be set to random
for a more even distribution. This property is only applicable when the
destination is an Amazon Kinesis stream.}
}
\description{
Creates or updates a subscription filter and associates it with the
specified log group. Subscription filters allow you to subscribe to a
real-time stream of log events ingested through PutLogEvents and have
them delivered to a specific destination. Currently, the supported
destinations are:
}
\details{
\itemize{
\item An Amazon Kinesis stream belonging to the same account as the
subscription filter, for same-account delivery.
\item A logical destination that belongs to a different account, for
cross-account delivery.
\item An Amazon Kinesis Firehose delivery stream that belongs to the same
account as the subscription filter, for same-account delivery.
\item An AWS Lambda function that belongs to the same account as the
subscription filter, for same-account delivery.
}

There can only be one subscription filter associated with a log group.
If you are updating an existing filter, you must specify the correct
name in \code{filterName}. Otherwise, the call fails because you cannot
associate a second filter with a log group.
}
\section{Request syntax}{
\preformatted{svc$put_subscription_filter(
  logGroupName = "string",
  filterName = "string",
  filterPattern = "string",
  destinationArn = "string",
  roleArn = "string",
  distribution = "Random"|"ByLogStream"
)
}
}

\keyword{internal}
