% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_organization_conformance_pack_statuses}
\alias{configservice_describe_organization_conformance_pack_statuses}
\title{Provides organization conformance pack deployment status for an
organization}
\usage{
configservice_describe_organization_conformance_pack_statuses(
  OrganizationConformancePackNames, Limit, NextToken)
}
\arguments{
\item{OrganizationConformancePackNames}{The names of organization conformance packs for which you want status
details. If you do not specify any names, AWS Config returns details for
all your organization conformance packs.}

\item{Limit}{The maximum number of OrganizationConformancePackStatuses returned on
each page. If you do no specify a number, AWS Config uses the default.
The default is 100.}

\item{NextToken}{The nextToken string returned on a previous page that you use to get the
next page of results in a paginated response.}
}
\description{
Provides organization conformance pack deployment status for an
organization.
}
\details{
The status is not considered successful until organization conformance
pack is successfully deployed in all the member accounts with an
exception of excluded accounts.

When you specify the limit and the next token, you receive a paginated
response. Limit and next token are not applicable if you specify
organization conformance pack names. They are only applicable, when you
request all the organization conformance packs.

Only a master account can call this API.
}
\section{Request syntax}{
\preformatted{svc$describe_organization_conformance_pack_statuses(
  OrganizationConformancePackNames = list(
    "string"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
