# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include autoscalingplans_service.R
NULL

#' Creates a scaling plan
#'
#' @description
#' Creates a scaling plan.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/create_scaling_plan.html](https://paws-r.github.io/docs/autoscalingplans/create_scaling_plan.html) for full documentation.
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan. Names cannot contain vertical bars,
#' colons, or forward slashes.
#' @param ApplicationSource &#91;required&#93; A CloudFormation stack or set of tags. You can create one scaling plan
#' per application source.
#' 
#' For more information, see
#' [ApplicationSource](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html)
#' in the *AWS Auto Scaling API Reference*.
#' @param ScalingInstructions &#91;required&#93; The scaling instructions.
#' 
#' For more information, see
#' [ScalingInstruction](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html)
#' in the *AWS Auto Scaling API Reference*.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_create_scaling_plan
autoscalingplans_create_scaling_plan <- function(ScalingPlanName, ApplicationSource, ScalingInstructions) {
  op <- new_operation(
    name = "CreateScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$create_scaling_plan_input(ScalingPlanName = ScalingPlanName, ApplicationSource = ApplicationSource, ScalingInstructions = ScalingInstructions)
  output <- .autoscalingplans$create_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$create_scaling_plan <- autoscalingplans_create_scaling_plan

#' Deletes the specified scaling plan
#'
#' @description
#' Deletes the specified scaling plan.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/delete_scaling_plan.html](https://paws-r.github.io/docs/autoscalingplans/delete_scaling_plan.html) for full documentation.
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_delete_scaling_plan
autoscalingplans_delete_scaling_plan <- function(ScalingPlanName, ScalingPlanVersion) {
  op <- new_operation(
    name = "DeleteScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$delete_scaling_plan_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion)
  output <- .autoscalingplans$delete_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$delete_scaling_plan <- autoscalingplans_delete_scaling_plan

#' Describes the scalable resources in the specified scaling plan
#'
#' @description
#' Describes the scalable resources in the specified scaling plan.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/describe_scaling_plan_resources.html](https://paws-r.github.io/docs/autoscalingplans/describe_scaling_plan_resources.html) for full documentation.
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' @param MaxResults The maximum number of scalable resources to return. The value must be
#' between 1 and 50. The default value is 50.
#' @param NextToken The token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_describe_scaling_plan_resources
autoscalingplans_describe_scaling_plan_resources <- function(ScalingPlanName, ScalingPlanVersion, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPlanResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$describe_scaling_plan_resources_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, MaxResults = MaxResults, NextToken = NextToken)
  output <- .autoscalingplans$describe_scaling_plan_resources_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$describe_scaling_plan_resources <- autoscalingplans_describe_scaling_plan_resources

#' Describes one or more of your scaling plans
#'
#' @description
#' Describes one or more of your scaling plans.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/describe_scaling_plans.html](https://paws-r.github.io/docs/autoscalingplans/describe_scaling_plans.html) for full documentation.
#'
#' @param ScalingPlanNames The names of the scaling plans (up to 10). If you specify application
#' sources, you cannot specify scaling plan names.
#' @param ScalingPlanVersion The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' 
#' If you specify a scaling plan version, you must also specify a scaling
#' plan name.
#' @param ApplicationSources The sources for the applications (up to 10). If you specify scaling plan
#' names, you cannot specify application sources.
#' @param MaxResults The maximum number of scalable resources to return. This value can be
#' between 1 and 50. The default value is 50.
#' @param NextToken The token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_describe_scaling_plans
autoscalingplans_describe_scaling_plans <- function(ScalingPlanNames = NULL, ScalingPlanVersion = NULL, ApplicationSources = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$describe_scaling_plans_input(ScalingPlanNames = ScalingPlanNames, ScalingPlanVersion = ScalingPlanVersion, ApplicationSources = ApplicationSources, MaxResults = MaxResults, NextToken = NextToken)
  output <- .autoscalingplans$describe_scaling_plans_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$describe_scaling_plans <- autoscalingplans_describe_scaling_plans

#' Retrieves the forecast data for a scalable resource
#'
#' @description
#' Retrieves the forecast data for a scalable resource.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/get_scaling_plan_resource_forecast_data.html](https://paws-r.github.io/docs/autoscalingplans/get_scaling_plan_resource_forecast_data.html) for full documentation.
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service. The only valid value is `autoscaling`.
#' @param ResourceId &#91;required&#93; The ID of the resource. This string consists of a prefix
#' (`autoScalingGroup`) followed by the name of a specified Auto Scaling
#' group (`my-asg`). Example: `autoScalingGroup/my-asg`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension for the resource. The only valid value is
#' `autoscaling:autoScalingGroup:DesiredCapacity`.
#' @param ForecastDataType &#91;required&#93; The type of forecast data to get.
#' 
#' -   `LoadForecast`: The load metric forecast.
#' 
#' -   `CapacityForecast`: The capacity forecast.
#' 
#' -   `ScheduledActionMinCapacity`: The minimum capacity for each
#'     scheduled scaling action. This data is calculated as the larger of
#'     two values: the capacity forecast or the minimum capacity in the
#'     scaling instruction.
#' 
#' -   `ScheduledActionMaxCapacity`: The maximum capacity for each
#'     scheduled scaling action. The calculation used is determined by the
#'     predictive scaling maximum capacity behavior setting in the scaling
#'     instruction.
#' @param StartTime &#91;required&#93; The inclusive start time of the time range for the forecast data to get.
#' The date and time can be at most 56 days before the current date and
#' time.
#' @param EndTime &#91;required&#93; The exclusive end time of the time range for the forecast data to get.
#' The maximum time duration between the start and end time is seven days.
#' 
#' Although this parameter can accept a date and time that is more than two
#' days in the future, the availability of forecast data has limits. AWS
#' Auto Scaling only issues forecasts for periods of two days in advance.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_get_scaling_plan_resource_forecast_data
autoscalingplans_get_scaling_plan_resource_forecast_data <- function(ScalingPlanName, ScalingPlanVersion, ServiceNamespace, ResourceId, ScalableDimension, ForecastDataType, StartTime, EndTime) {
  op <- new_operation(
    name = "GetScalingPlanResourceForecastData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$get_scaling_plan_resource_forecast_data_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, ForecastDataType = ForecastDataType, StartTime = StartTime, EndTime = EndTime)
  output <- .autoscalingplans$get_scaling_plan_resource_forecast_data_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$get_scaling_plan_resource_forecast_data <- autoscalingplans_get_scaling_plan_resource_forecast_data

#' Updates the specified scaling plan
#'
#' @description
#' Updates the specified scaling plan.
#'
#' See [https://paws-r.github.io/docs/autoscalingplans/update_scaling_plan.html](https://paws-r.github.io/docs/autoscalingplans/update_scaling_plan.html) for full documentation.
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. The only valid value is `1`.
#' Currently, you cannot have multiple scaling plan versions.
#' @param ApplicationSource A CloudFormation stack or set of tags.
#' 
#' For more information, see
#' [ApplicationSource](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html)
#' in the *AWS Auto Scaling API Reference*.
#' @param ScalingInstructions The scaling instructions.
#' 
#' For more information, see
#' [ScalingInstruction](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html)
#' in the *AWS Auto Scaling API Reference*.
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_update_scaling_plan
autoscalingplans_update_scaling_plan <- function(ScalingPlanName, ScalingPlanVersion, ApplicationSource = NULL, ScalingInstructions = NULL) {
  op <- new_operation(
    name = "UpdateScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$update_scaling_plan_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, ApplicationSource = ApplicationSource, ScalingInstructions = ScalingInstructions)
  output <- .autoscalingplans$update_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$update_scaling_plan <- autoscalingplans_update_scaling_plan
