% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_cancel_query}
\alias{cloudtrail_cancel_query}
\title{Cancels a query if the query is not in a terminated state, such as
CANCELLED, FAILED, TIMED_OUT, or FINISHED}
\usage{
cloudtrail_cancel_query(EventDataStore, QueryId)
}
\arguments{
\item{EventDataStore}{[required] The ARN (or the ID suffix of the ARN) of an event data store on which
the specified query is running.}

\item{QueryId}{[required] The ID of the query that you want to cancel. The \code{QueryId} comes from
the response of a \code{\link[=cloudtrail_start_query]{start_query}} operation.}
}
\description{
Cancels a query if the query is not in a terminated state, such as \code{CANCELLED}, \code{FAILED}, \code{TIMED_OUT}, or \code{FINISHED}. You must specify an ARN value for \code{EventDataStore}. The ID of the query that you want to cancel is also required. When you run \code{\link[=cloudtrail_cancel_query]{cancel_query}}, the query status might show as \code{CANCELLED} even if the operation is not yet finished.

See \url{https://paws-r.github.io/docs/cloudtrail/cancel_query.html} for full documentation.
}
\keyword{internal}
