% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_update_event_data_store}
\alias{cloudtrail_update_event_data_store}
\title{Updates an event data store}
\usage{
cloudtrail_update_event_data_store(
  EventDataStore,
  Name = NULL,
  AdvancedEventSelectors = NULL,
  MultiRegionEnabled = NULL,
  OrganizationEnabled = NULL,
  RetentionPeriod = NULL,
  TerminationProtectionEnabled = NULL
)
}
\arguments{
\item{EventDataStore}{[required] The ARN (or the ID suffix of the ARN) of the event data store that you
want to update.}

\item{Name}{The event data store name.}

\item{AdvancedEventSelectors}{The advanced event selectors used to select events for the event data
store.}

\item{MultiRegionEnabled}{Specifies whether an event data store collects events from all regions,
or only from the region in which it was created.}

\item{OrganizationEnabled}{Specifies whether an event data store collects events logged for an
organization in Organizations.}

\item{RetentionPeriod}{The retention period, in days.}

\item{TerminationProtectionEnabled}{Indicates that termination protection is enabled and the event data
store cannot be automatically deleted.}
}
\description{
Updates an event data store. The required \code{EventDataStore} value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. \code{RetentionPeriod} is in days, and valid values are integers between 90 and 2555. By default, \code{TerminationProtection} is enabled. \code{AdvancedEventSelectors} includes or excludes management and data events in your event data store; for more information about \code{AdvancedEventSelectors}, see PutEventSelectorsRequest$AdvancedEventSelectors.

See \url{https://paws-r.github.io/docs/cloudtrail/update_event_data_store.html} for full documentation.
}
\keyword{internal}
