% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_start_replay}
\alias{cloudwatchevents_start_replay}
\title{Starts the specified replay}
\usage{
cloudwatchevents_start_replay(
  ReplayName,
  Description = NULL,
  EventSourceArn,
  EventStartTime,
  EventEndTime,
  Destination
)
}
\arguments{
\item{ReplayName}{[required] The name of the replay to start.}

\item{Description}{A description for the replay to start.}

\item{EventSourceArn}{[required] The ARN of the archive to replay events from.}

\item{EventStartTime}{[required] A time stamp for the time to start replaying events. Only events that
occurred between the \code{EventStartTime} and \code{EventEndTime} are replayed.}

\item{EventEndTime}{[required] A time stamp for the time to stop replaying events. Only events that
occurred between the \code{EventStartTime} and \code{EventEndTime} are replayed.}

\item{Destination}{[required] A \code{ReplayDestination} object that includes details about the destination
for the replay.}
}
\description{
Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an \code{EventStartTime} and an \code{EventEndTime} that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use \code{\link[=cloudwatchevents_describe_replay]{describe_replay}} to determine the progress of a replay. The value returned for \code{EventLastReplayedTime} indicates the time within the specified time range associated with the last event replayed.

See \url{https://paws-r.github.io/docs/cloudwatchevents/start_replay.html} for full documentation.
}
\keyword{internal}
