% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_create_log_group}
\alias{cloudwatchlogs_create_log_group}
\title{Creates a log group with the specified name}
\usage{
cloudwatchlogs_create_log_group(logGroupName, kmsKeyId = NULL, tags = NULL)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{kmsKeyId}{The Amazon Resource Name (ARN) of the CMK to use when encrypting log
data. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms}{Amazon Resource Names - Key Management Service}.}

\item{tags}{The key-value pairs to use for the tags.

CloudWatch Logs doesn’t support IAM policies that prevent users from
assigning specified tags to log groups using the
\code{aws:Resource/key-name } or \code{aws:TagKeys} condition keys. For more
information about using tags to control access, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Controlling access to Amazon Web Services resources using tags}.}
}
\description{
Creates a log group with the specified name. You can create up to 20,000 log groups per account.

See \url{https://paws-r.github.io/docs/cloudwatchlogs/create_log_group.html} for full documentation.
}
\keyword{internal}
