% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_remediation_execution_status}
\alias{configservice_describe_remediation_execution_status}
\title{Provides a detailed view of a Remediation Execution for a set of
resources including state, timestamps for when steps for the remediation
execution occur, and any error messages for steps that have failed}
\usage{
configservice_describe_remediation_execution_status(
  ConfigRuleName,
  ResourceKeys = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ConfigRuleName}{[required] A list of Config rule names.}

\item{ResourceKeys}{A list of resource keys to be processed with the current request. Each
element in the list consists of the resource type and resource ID.}

\item{Limit}{The maximum number of RemediationExecutionStatuses returned on each
page. The default is maximum. If you specify 0, Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when steps for the remediation execution occur, and any error messages for steps that have failed. When you specify the limit and the next token, you receive a paginated response.

See \url{https://paws-r.github.io/docs/configservice/describe_remediation_execution_status.html} for full documentation.
}
\keyword{internal}
