% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_enable_policy_type}
\alias{organizations_enable_policy_type}
\title{Enables a policy type in a root}
\usage{
organizations_enable_policy_type(RootId, PolicyType)
}
\arguments{
\item{RootId}{[required] The unique identifier (ID) of the root in which you want to enable a
policy type. You can get the ID from the
\code{\link[=organizations_list_roots]{list_roots}} operation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a root ID
string requires "r-" followed by from 4 to 32 lowercase letters or
digits.}

\item{PolicyType}{[required] The policy type that you want to enable. You can specify one of the
following values:
\itemize{
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html}{AISERVICES_OPT_OUT_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html}{BACKUP_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html}{SERVICE_CONTROL_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html}{TAG_POLICY}
}}
}
\description{
Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root. You can undo this by using the \code{\link[=organizations_disable_policy_type]{disable_policy_type}} operation.

See \url{https://paws-r.github.io/docs/organizations/enable_policy_type.html} for full documentation.
}
\keyword{internal}
