% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_ops_summary}
\alias{ssm_get_ops_summary}
\title{View a summary of operations metadata (OpsData) based on specified
filters and aggregators}
\usage{
ssm_get_ops_summary(
  SyncName = NULL,
  Filters = NULL,
  Aggregators = NULL,
  ResultAttributes = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{SyncName}{Specify the name of a resource data sync to get.}

\item{Filters}{Optional filters used to scope down the returned OpsData.}

\item{Aggregators}{Optional aggregators that return counts of OpsData based on one or more
expressions.}

\item{ResultAttributes}{The OpsData data type to return.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer.

See \url{https://paws-r.github.io/docs/ssm/get_ops_summary.html} for full documentation.
}
\keyword{internal}
