% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetics_operations.R
\name{synthetics_describe_canaries}
\alias{synthetics_describe_canaries}
\title{This operation returns a list of the canaries in your account, along
with full details about each canary}
\usage{
synthetics_describe_canaries(NextToken = NULL, MaxResults = NULL, Names = NULL)
}
\arguments{
\item{NextToken}{A token that indicates that there is more data available. You can use
this token in a subsequent operation to retrieve the next set of
results.}

\item{MaxResults}{Specify this parameter to limit how many canaries are returned each time
you use the \code{\link[=synthetics_describe_canaries]{describe_canaries}}
operation. If you omit this parameter, the default of 100 is used.}

\item{Names}{Use this parameter to return only canaries that match the names that you
specify here. You can specify as many as five canary names.

If you specify this parameter, the operation is successful only if you
have authorization to view all the canaries that you specify in your
request. If you do not have permission to view any of the canaries, the
request fails with a 403 response.

You are required to use this parameter if you are logged on to a user or
role that has an IAM policy that restricts which canaries that you are
allowed to view. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html}{Limiting a user to viewing specific canaries}.}
}
\description{
This operation returns a list of the canaries in your account, along with full details about each canary.

See \url{https://paws-r.github.io/docs/synthetics/describe_canaries.html} for full documentation.
}
\keyword{internal}
