# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudformation_service.R
NULL

#' Activate trusted access with Organizations
#'
#' @description
#' Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated, the management account has permissions to create and manage StackSets for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_activate_organizations_access/](https://www.paws-r-sdk.com/docs/cloudformation_activate_organizations_access/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname cloudformation_activate_organizations_access
cloudformation_activate_organizations_access <- function() {
  op <- new_operation(
    name = "ActivateOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$activate_organizations_access_input()
  output <- .cloudformation$activate_organizations_access_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$activate_organizations_access <- cloudformation_activate_organizations_access

#' Activates a public third-party extension, making it available for use in
#' stack templates
#'
#' @description
#' Activates a public third-party extension, making it available for use in stack templates. For more information, see [Using public extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html) in the *CloudFormation User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_activate_type/](https://www.paws-r-sdk.com/docs/cloudformation_activate_type/) for full documentation.
#'
#' @param Type The extension type.
#' 
#' Conditional: You must specify `PublicTypeArn`, or `TypeName`, `Type`,
#' and `PublisherId`.
#' @param PublicTypeArn The Amazon Resource Name (ARN) of the public extension.
#' 
#' Conditional: You must specify `PublicTypeArn`, or `TypeName`, `Type`,
#' and `PublisherId`.
#' @param PublisherId The ID of the extension publisher.
#' 
#' Conditional: You must specify `PublicTypeArn`, or `TypeName`, `Type`,
#' and `PublisherId`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify `PublicTypeArn`, or `TypeName`, `Type`,
#' and `PublisherId`.
#' @param TypeNameAlias An alias to assign to the public extension, in this account and Region.
#' If you specify an alias for the extension, CloudFormation treats the
#' alias as the extension type name within this account and Region. You
#' must use the alias to refer to the extension in your templates, API
#' calls, and CloudFormation console.
#' 
#' An extension alias must be unique within a given account and Region. You
#' can activate the same public resource multiple times in the same account
#' and Region, using different type name aliases.
#' @param AutoUpdate Whether to automatically update the extension in this account and Region
#' when a new *minor* version is published by the extension publisher.
#' Major versions released by the publisher must be manually updated.
#' 
#' The default is `true`.
#' @param LoggingConfig Contains logging configuration information for an extension.
#' @param ExecutionRoleArn The name of the IAM execution role to use to activate the extension.
#' @param VersionBump Manually updates a previously-activated type to a new major or minor
#' version, if available. You can also use this parameter to update the
#' value of `AutoUpdate`.
#' 
#' -   `MAJOR`: CloudFormation updates the extension to the newest major
#'     version, if one is available.
#' 
#' -   `MINOR`: CloudFormation updates the extension to the newest minor
#'     version, if one is available.
#' @param MajorVersion The major version of this extension you want to activate, if multiple
#' major versions are available. The default is the latest major version.
#' CloudFormation uses the latest available *minor* version of the major
#' version selected.
#' 
#' You can specify `MajorVersion` or `VersionBump`, but not both.
#'
#' @keywords internal
#'
#' @rdname cloudformation_activate_type
cloudformation_activate_type <- function(Type = NULL, PublicTypeArn = NULL, PublisherId = NULL, TypeName = NULL, TypeNameAlias = NULL, AutoUpdate = NULL, LoggingConfig = NULL, ExecutionRoleArn = NULL, VersionBump = NULL, MajorVersion = NULL) {
  op <- new_operation(
    name = "ActivateType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$activate_type_input(Type = Type, PublicTypeArn = PublicTypeArn, PublisherId = PublisherId, TypeName = TypeName, TypeNameAlias = TypeNameAlias, AutoUpdate = AutoUpdate, LoggingConfig = LoggingConfig, ExecutionRoleArn = ExecutionRoleArn, VersionBump = VersionBump, MajorVersion = MajorVersion)
  output <- .cloudformation$activate_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$activate_type <- cloudformation_activate_type

#' Returns configuration data for the specified CloudFormation extensions,
#' from the CloudFormation registry for the account and Region
#'
#' @description
#' Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_batch_describe_type_configurations/](https://www.paws-r-sdk.com/docs/cloudformation_batch_describe_type_configurations/) for full documentation.
#'
#' @param TypeConfigurationIdentifiers &#91;required&#93; The list of identifiers for the desired extension configurations.
#'
#' @keywords internal
#'
#' @rdname cloudformation_batch_describe_type_configurations
cloudformation_batch_describe_type_configurations <- function(TypeConfigurationIdentifiers) {
  op <- new_operation(
    name = "BatchDescribeTypeConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$batch_describe_type_configurations_input(TypeConfigurationIdentifiers = TypeConfigurationIdentifiers)
  output <- .cloudformation$batch_describe_type_configurations_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$batch_describe_type_configurations <- cloudformation_batch_describe_type_configurations

#' Cancels an update on the specified stack
#'
#' @description
#' Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_cancel_update_stack/](https://www.paws-r-sdk.com/docs/cloudformation_cancel_update_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; If you don't pass a parameter to `StackName`, the API returns a response
#' that describes all resources in the account.
#' 
#' The IAM policy below can be added to IAM policies when you want to limit
#' resource-level permissions and avoid returning a response when no
#' parameter is sent in the request:
#' 
#' `{ "Version": "2012-10-17", "Statement": [{ "Effect": "Deny", "Action": "cloudformation:DescribeStacks", "NotResource": "arn:aws:cloudformation:*:*:stack/*/*" }] }`
#' 
#' The name or the unique stack ID that's associated with the stack.
#' @param ClientRequestToken A unique identifier for this
#' [`cancel_update_stack`][cloudformation_cancel_update_stack] request.
#' Specify this token if you plan to retry requests so that CloudFormation
#' knows that you're not attempting to cancel an update on a stack with the
#' same name. You might retry
#' [`cancel_update_stack`][cloudformation_cancel_update_stack] requests to
#' ensure that CloudFormation successfully received them.
#'
#' @keywords internal
#'
#' @rdname cloudformation_cancel_update_stack
cloudformation_cancel_update_stack <- function(StackName, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "CancelUpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$cancel_update_stack_input(StackName = StackName, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$cancel_update_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$cancel_update_stack <- cloudformation_cancel_update_stack

#' For a specified stack that's in the UPDATE_ROLLBACK_FAILED state,
#' continues rolling it back to the UPDATE_ROLLBACK_COMPLETE state
#'
#' @description
#' For a specified stack that's in the `UPDATE_ROLLBACK_FAILED` state, continues rolling it back to the `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually [fix the error](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed) and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state), and then try to update the stack again.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_continue_update_rollback/](https://www.paws-r-sdk.com/docs/cloudformation_continue_update_rollback/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the unique ID of the stack that you want to continue rolling
#' back.
#' 
#' Don't specify the name of a nested stack (a stack that was created by
#' using the `AWS::CloudFormation::Stack` resource). Instead, use this
#' operation on the parent stack (the stack that contains the
#' `AWS::CloudFormation::Stack` resource).
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management
#' (IAM) role that CloudFormation assumes to roll back the stack.
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' CloudFormation always uses this role for all future operations on the
#' stack. Provided that users have permission to operate on the stack,
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least permission.
#' 
#' If you don't specify a value, CloudFormation uses the role that was
#' previously associated with the stack. If no role is available,
#' CloudFormation uses a temporary session that's generated from your user
#' credentials.
#' @param ResourcesToSkip A list of the logical IDs of the resources that CloudFormation skips
#' during the continue update rollback operation. You can specify only
#' resources that are in the `UPDATE_FAILED` state because a rollback
#' failed. You can't specify resources that are in the `UPDATE_FAILED`
#' state for other reasons, for example, because an update was canceled. To
#' check why a resource update failed, use the
#' [`describe_stack_resources`][cloudformation_describe_stack_resources]
#' action, and view the resource status reason.
#' 
#' Specify this property to skip rolling back resources that CloudFormation
#' can't successfully roll back. We recommend that you
#' [troubleshoot](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
#' resources before skipping them. CloudFormation sets the status of the
#' specified resources to `UPDATE_COMPLETE` and continues to roll back the
#' stack. After the rollback is complete, the state of the skipped
#' resources will be inconsistent with the state of the resources in the
#' stack template. Before performing another stack update, you must update
#' the stack or resources to be consistent with each other. If you don't,
#' subsequent stack updates might fail, and the stack will become
#' unrecoverable.
#' 
#' Specify the minimum number of resources required to successfully roll
#' back your stack. For example, a failed resource update might cause
#' dependent resources to fail. In this case, it might not be necessary to
#' skip the dependent resources.
#' 
#' To skip resources that are part of nested stacks, use the following
#' format: `NestedStackName.ResourceLogicalID`. If you want to specify the
#' logical ID of a stack resource (`Type: AWS::CloudFormation::Stack`) in
#' the `ResourcesToSkip` list, then its corresponding embedded stack must
#' be in one of the following states: `DELETE_IN_PROGRESS`,
#' `DELETE_COMPLETE`, or `DELETE_FAILED`.
#' 
#' Don't confuse a child stack's name with its corresponding logical ID
#' defined in the parent stack. For an example of a continue update
#' rollback operation with nested stacks, see [Using ResourcesToSkip to
#' recover a nested stacks
#' hierarchy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks).
#' @param ClientRequestToken A unique identifier for this
#' [`continue_update_rollback`][cloudformation_continue_update_rollback]
#' request. Specify this token if you plan to retry requests so that
#' CloudFormation knows that you're not attempting to continue the rollback
#' to a stack with the same name. You might retry
#' [`continue_update_rollback`][cloudformation_continue_update_rollback]
#' requests to ensure that CloudFormation successfully received them.
#'
#' @keywords internal
#'
#' @rdname cloudformation_continue_update_rollback
cloudformation_continue_update_rollback <- function(StackName, RoleARN = NULL, ResourcesToSkip = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "ContinueUpdateRollback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$continue_update_rollback_input(StackName = StackName, RoleARN = RoleARN, ResourcesToSkip = ResourcesToSkip, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$continue_update_rollback_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$continue_update_rollback <- cloudformation_continue_update_rollback

#' Creates a list of changes that will be applied to a stack so that you
#' can review the changes before executing them
#'
#' @description
#' Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_create_change_set/](https://www.paws-r-sdk.com/docs/cloudformation_create_change_set/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the unique ID of the stack for which you are creating a
#' change set. CloudFormation generates the change set by comparing this
#' stack's information with the information that you submit, such as a
#' modified template or different parameter input values.
#' @param TemplateBody A structure that contains the body of the revised template, with a
#' minimum length of 1 byte and a maximum length of 51,200 bytes.
#' CloudFormation generates the change set by comparing this template with
#' the template of the stack that you specified.
#' 
#' Conditional: You must specify only `TemplateBody` or `TemplateURL`.
#' @param TemplateURL The location of the file that contains the revised template. The URL
#' must point to a template (max size: 460,800 bytes) that's located in an
#' Amazon S3 bucket or a Systems Manager document. CloudFormation generates
#' the change set by comparing this template with the stack that you
#' specified.
#' 
#' Conditional: You must specify only `TemplateBody` or `TemplateURL`.
#' @param UsePreviousTemplate Whether to reuse the template that's associated with the stack to create
#' the change set.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' change set. For more information, see the Parameter data type.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for CloudFormation to create the
#' stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your Amazon Web Services account; for example, by
#'     creating new Identity and Access Management (IAM) users. For those
#'     stacks, you must explicitly acknowledge this by specifying one of
#'     these capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities,
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we suggest that you
#'     review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM resources in
#'     CloudFormation
#'     templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually creating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     create a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by CloudFormation.
#' 
#'     This capacity doesn't apply to creating change sets, and specifying
#'     it when creating change sets has no effect.
#' 
#'     If you want to create a stack from a stack template that contains
#'     macros *and* nested stacks, you must create or update the stack
#'     directly from the template using the
#'     [`create_stack`][cloudformation_create_stack] or
#'     [`update_stack`][cloudformation_update_stack] action, and specifying
#'     this capability.
#' 
#'     For more information about macros, see [Using CloudFormation macros
#'     to perform custom processing on
#'     templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with if
#' you execute this change set, such as `AWS::EC2::Instance`,
#' `AWS::EC2::*`, or `Custom::MyCustomInstance`.
#' 
#' If the list of resource types doesn't include a resource type that
#' you're updating, the stack update fails. By default, CloudFormation
#' grants permissions to all resource types. Identity and Access Management
#' (IAM) uses this parameter for condition keys in IAM policies for
#' CloudFormation. For more information, see [Controlling access with
#' Identity and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
#' in the CloudFormation User Guide.
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management
#' (IAM) role that CloudFormation assumes when executing the change set.
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' CloudFormation uses this role for all future operations on the stack.
#' Provided that users have permission to operate on the stack,
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least permission.
#' 
#' If you don't specify a value, CloudFormation uses the role that was
#' previously associated with the stack. If no role is available,
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param RollbackConfiguration The rollback triggers for CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param NotificationARNs The Amazon Resource Names (ARNs) of Amazon Simple Notification Service
#' (Amazon SNS) topics that CloudFormation associates with the stack. To
#' remove all associated notification topics, specify an empty list.
#' @param Tags Key-value pairs to associate with this stack. CloudFormation also
#' propagates these tags to resources in the stack. You can specify a
#' maximum of 50 tags.
#' @param ChangeSetName &#91;required&#93; The name of the change set. The name must be unique among all change
#' sets that are associated with the specified stack.
#' 
#' A change set name can contain only alphanumeric, case sensitive
#' characters, and hyphens. It must start with an alphabetical character
#' and can't exceed 128 characters.
#' @param ClientToken A unique identifier for this
#' [`create_change_set`][cloudformation_create_change_set] request. Specify
#' this token if you plan to retry requests so that CloudFormation knows
#' that you're not attempting to create another change set with the same
#' name. You might retry
#' [`create_change_set`][cloudformation_create_change_set] requests to
#' ensure that CloudFormation successfully received them.
#' @param Description A description to help you identify this change set.
#' @param ChangeSetType The type of change set operation. To create a change set for a new
#' stack, specify `CREATE`. To create a change set for an existing stack,
#' specify `UPDATE`. To create a change set for an import operation,
#' specify `IMPORT`.
#' 
#' If you create a change set for a new stack, CloudFormation creates a
#' stack with a unique stack ID, but no template or resources. The stack
#' will be in the
#' [REVIEW_IN_PROGRESS](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
#' state until you execute the change set.
#' 
#' By default, CloudFormation specifies `UPDATE`. You can't use the
#' `UPDATE` type to create a change set for a new stack or the `CREATE`
#' type to create a change set for an existing stack.
#' @param ResourcesToImport The resources to import into your stack.
#' @param IncludeNestedStacks Creates a change set for the all nested stacks specified in the
#' template. The default behavior of this action is set to `False`. To
#' include nested sets in a change set, specify `True`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_change_set
cloudformation_create_change_set <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, Parameters = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, RollbackConfiguration = NULL, NotificationARNs = NULL, Tags = NULL, ChangeSetName, ClientToken = NULL, Description = NULL, ChangeSetType = NULL, ResourcesToImport = NULL, IncludeNestedStacks = NULL) {
  op <- new_operation(
    name = "CreateChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_change_set_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, Parameters = Parameters, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, RollbackConfiguration = RollbackConfiguration, NotificationARNs = NotificationARNs, Tags = Tags, ChangeSetName = ChangeSetName, ClientToken = ClientToken, Description = Description, ChangeSetType = ChangeSetType, ResourcesToImport = ResourcesToImport, IncludeNestedStacks = IncludeNestedStacks)
  output <- .cloudformation$create_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_change_set <- cloudformation_create_change_set

#' Creates a stack as specified in the template
#'
#' @description
#' Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the [`describe_stacks`][cloudformation_describe_stacks] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_create_stack/](https://www.paws-r-sdk.com/docs/cloudformation_create_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name that's associated with the stack. The name must be unique in
#' the Region in which you are creating the stack.
#' 
#' A stack name can contain only alphanumeric characters (case sensitive)
#' and hyphens. It must start with an alphabetical character and can't be
#' longer than 128 characters.
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information, go to
#' [Template
#' anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify either the `TemplateBody` or the
#' `TemplateURL` parameter, but not both.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that's located in an Amazon S3 bucket
#' or a Systems Manager document. For more information, go to the [Template
#' anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify either the `TemplateBody` or the
#' `TemplateURL` parameter, but not both.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' stack. For more information, see the
#' [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
#' data type.
#' @param DisableRollback Set to `true` to disable rollback of the stack if stack creation failed.
#' You can specify either `DisableRollback` or `OnFailure`, but not both.
#' 
#' Default: `false`
#' @param RollbackConfiguration The rollback triggers for CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param TimeoutInMinutes The amount of time that can pass before the stack status becomes
#' CREATE_FAILED; if `DisableRollback` is not set or is set to `false`, the
#' stack will be rolled back.
#' @param NotificationARNs The Amazon Simple Notification Service (Amazon SNS) topic ARNs to
#' publish stack related events. You can find your Amazon SNS topic ARNs
#' using the Amazon SNS console or your Command Line Interface (CLI).
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for CloudFormation to create the
#' stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your Amazon Web Services account; for example, by
#'     creating new Identity and Access Management (IAM) users. For those
#'     stacks, you must explicitly acknowledge this by specifying one of
#'     these capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities,
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually creating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     create a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by CloudFormation.
#' 
#'     If you want to create a stack from a stack template that contains
#'     macros *and* nested stacks, you must create the stack directly from
#'     the template using this capability.
#' 
#'     You should only create stacks directly from a stack template that
#'     contains macros if you know what processing the macro performs.
#' 
#'     Each macro relies on an underlying Lambda service function for
#'     processing stack templates. Be aware that the Lambda function owner
#'     can update the function operation without CloudFormation being
#'     notified.
#' 
#'     For more information, see [Using CloudFormation macros to perform
#'     custom processing on
#'     templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with for
#' this create stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`,
#' or `Custom::MyCustomInstance`. Use the following syntax to describe
#' template resource types: `AWS::*` (for all Amazon Web Services
#' resources), `Custom::*` (for all custom resources),
#' `Custom::logical_ID ` (for a specific custom resource),
#' `AWS::service_name::*` (for all resources of a particular Amazon Web
#' Services service), and `AWS::service_name::resource_logical_ID ` (for a
#' specific Amazon Web Services resource).
#' 
#' If the list of resource types doesn't include a resource that you're
#' creating, the stack creation fails. By default, CloudFormation grants
#' permissions to all resource types. Identity and Access Management (IAM)
#' uses this parameter for CloudFormation-specific condition keys in IAM
#' policies. For more information, see [Controlling Access with Identity
#' and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management
#' (IAM) role that CloudFormation assumes to create the stack.
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' CloudFormation always uses this role for all future operations on the
#' stack. Provided that users have permission to operate on the stack,
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, CloudFormation uses the role that was
#' previously associated with the stack. If no role is available,
#' CloudFormation uses a temporary session that's generated from your user
#' credentials.
#' @param OnFailure Determines what action will be taken if stack creation fails. This must
#' be one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. You can specify either
#' `OnFailure` or `DisableRollback`, but not both.
#' 
#' Default: `ROLLBACK`
#' @param StackPolicyBody Structure containing the stack policy body. For more information, go to
#' [Prevent Updates to Stack
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
#' in the *CloudFormation User Guide*. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' @param StackPolicyURL Location of a file containing the stack policy. The URL must point to a
#' policy (maximum size: 16 KB) located in an S3 bucket in the same Region
#' as the stack. You can specify either the `StackPolicyBody` or the
#' `StackPolicyURL` parameter, but not both.
#' @param Tags Key-value pairs to associate with this stack. CloudFormation also
#' propagates these tags to the resources created in the stack. A maximum
#' number of 50 tags can be specified.
#' @param ClientRequestToken A unique identifier for this
#' [`create_stack`][cloudformation_create_stack] request. Specify this
#' token if you plan to retry requests so that CloudFormation knows that
#' you're not attempting to create a stack with the same name. You might
#' retry [`create_stack`][cloudformation_create_stack] requests to ensure
#' that CloudFormation successfully received them.
#' 
#' All events initiated by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a [`create_stack`][cloudformation_create_stack]
#' operation with the token `token1`, then all the `StackEvents` generated
#' by that operation will have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#' @param EnableTerminationProtection Whether to enable termination protection on the specified stack. If a
#' user attempts to delete a stack with termination protection enabled, the
#' operation fails and the stack remains unchanged. For more information,
#' see [Protecting a Stack From Being
#' Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
#' in the *CloudFormation User Guide*. Termination protection is
#' deactivated on stacks by default.
#' 
#' For [nested
#' stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
#' termination protection is set on the root stack and can't be changed
#' directly on the nested stack.
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack
cloudformation_create_stack <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, Parameters = NULL, DisableRollback = NULL, RollbackConfiguration = NULL, TimeoutInMinutes = NULL, NotificationARNs = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, OnFailure = NULL, StackPolicyBody = NULL, StackPolicyURL = NULL, Tags = NULL, ClientRequestToken = NULL, EnableTerminationProtection = NULL) {
  op <- new_operation(
    name = "CreateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, Parameters = Parameters, DisableRollback = DisableRollback, RollbackConfiguration = RollbackConfiguration, TimeoutInMinutes = TimeoutInMinutes, NotificationARNs = NotificationARNs, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, OnFailure = OnFailure, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL, Tags = Tags, ClientRequestToken = ClientRequestToken, EnableTerminationProtection = EnableTerminationProtection)
  output <- .cloudformation$create_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack <- cloudformation_create_stack

#' Creates stack instances for the specified accounts, within the specified
#' Amazon Web Services Regions
#'
#' @description
#' Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_create_stack_instances/](https://www.paws-r-sdk.com/docs/cloudformation_create_stack_instances/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to create stack
#' instances from.
#' @param Accounts \[Self-managed permissions\] The names of one or more Amazon Web
#' Services accounts that you want to create stack instances in the
#' specified Region(s) for.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[Service-managed permissions\] The Organizations accounts for which to
#' create stack instances in the specified Amazon Web Services Regions.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The names of one or more Amazon Web Services Regions where you want to
#' create stack instances using the specified Amazon Web Services accounts.
#' @param ParameterOverrides A list of stack set parameters whose values you want to override in the
#' selected stack instances.
#' 
#' Any overridden parameter values will be applied to all stack instances
#' in the specified accounts and Amazon Web Services Regions. When
#' specifying parameters and their values, be aware of how CloudFormation
#' sets parameter values during stack instance operations:
#' 
#' -   To override the current value for a parameter, include the parameter
#'     and specify its value.
#' 
#' -   To leave an overridden parameter set to its present value, include
#'     the parameter and specify `UsePreviousValue` as `true`. (You can't
#'     specify both a value and set `UsePreviousValue` to `true`.)
#' 
#' -   To set an overridden parameter back to the value specified in the
#'     stack set, specify a parameter list but don't include the parameter
#'     in the list.
#' 
#' -   To leave all parameters set to their present values, don't specify
#'     this property at all.
#' 
#' During stack set updates, any parameter values overridden for a stack
#' instance aren't updated, but retain their overridden value.
#' 
#' You can only override the parameter *values* that are specified in the
#' stack set; to add or delete a parameter itself, use
#' [`update_stack_set`][cloudformation_update_stack_set] to update the
#' stack set template.
#' @param OperationPreferences Preferences for how CloudFormation performs this stack set operation.
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' CloudFormation performs the stack set operation only once, even if you
#' retry the request multiple times. You might retry stack set operation
#' requests to ensure that CloudFormation successfully received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack_instances
cloudformation_create_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, ParameterOverrides = NULL, OperationPreferences = NULL, OperationId = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "CreateStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, ParameterOverrides = ParameterOverrides, OperationPreferences = OperationPreferences, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$create_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack_instances <- cloudformation_create_stack_instances

#' Creates a stack set
#'
#' @description
#' Creates a stack set.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_create_stack_set/](https://www.paws-r-sdk.com/docs/cloudformation_create_stack_set/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name to associate with the stack set. The name must be unique in the
#' Region where you create your stack set.
#' 
#' A stack name can contain only alphanumeric characters (case-sensitive)
#' and hyphens. It must start with an alphabetic character and can't be
#' longer than 128 characters.
#' @param Description A description of the stack set. You can use the description to identify
#' the stack set's purpose or other important information.
#' @param TemplateBody The structure that contains the template body, with a minimum length of
#' 1 byte and a maximum length of 51,200 bytes. For more information, see
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify either the TemplateBody or the TemplateURL
#' parameter, but not both.
#' @param TemplateURL The location of the file that contains the template body. The URL must
#' point to a template (maximum size: 460,800 bytes) that's located in an
#' Amazon S3 bucket or a Systems Manager document. For more information,
#' see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify either the TemplateBody or the TemplateURL
#' parameter, but not both.
#' @param StackId The stack ID you are importing into a new stack set. Specify the Amazon
#' Resource Name (ARN) of the stack.
#' @param Parameters The input parameters for the stack set template.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack set
#' template contains certain capabilities in order for CloudFormation to
#' create the stack set and related stack instances.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your Amazon Web Services account; for example, by
#'     creating new Identity and Access Management (IAM) users. For those
#'     stack sets, you must explicitly acknowledge this by specifying one
#'     of these capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities,
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some templates reference macros. If your stack set template
#'     references one or more macros, you must create the stack set
#'     directly from the processed template, without first reviewing the
#'     resulting changes in a change set. To create the stack set directly,
#'     you must acknowledge this capability. For more information, see
#'     [Using CloudFormation Macros to Perform Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' 
#'     Stack sets with service-managed permissions don't currently support
#'     the use of macros in templates. (This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by CloudFormation.) Even if you
#'     specify this capability for a stack set with service-managed
#'     permissions, if you reference a macro in your template the stack set
#'     operation will fail.
#' @param Tags The key-value pairs to associate with this stack set and the stacks
#' created from it. CloudFormation also propagates these tags to supported
#' resources that are created in the stacks. A maximum number of 50 tags
#' can be specified.
#' 
#' If you specify tags as part of a
#' [`create_stack_set`][cloudformation_create_stack_set] action,
#' CloudFormation checks to see if you have the required IAM permission to
#' tag resources. If you don't, the entire
#' [`create_stack_set`][cloudformation_create_stack_set] action fails with
#' an `access denied` error, and the stack set is not created.
#' @param AdministrationRoleARN The Amazon Resource Name (ARN) of the IAM role to use to create this
#' stack set.
#' 
#' Specify an IAM role only if you are using customized administrator roles
#' to control which users or groups can manage specific stack sets within
#' the same administrator account. For more information, see
#' [Prerequisites: Granting Permissions for Stack Set
#' Operations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
#' in the *CloudFormation User Guide*.
#' @param ExecutionRoleName The name of the IAM execution role to use to create the stack set. If
#' you do not specify an execution role, CloudFormation uses the
#' `AWSCloudFormationStackSetExecutionRole` role for the stack set
#' operation.
#' 
#' Specify an IAM role only if you are using customized execution roles to
#' control which stack resources users and groups can include in their
#' stack sets.
#' @param PermissionModel Describes how the IAM roles required for stack set operations are
#' created. By default, `SELF-MANAGED` is specified.
#' 
#' -   With `self-managed` permissions, you must create the administrator
#'     and execution roles required to deploy to target accounts. For more
#'     information, see [Grant Self-Managed Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
#' 
#' -   With `service-managed` permissions, StackSets automatically creates
#'     the IAM roles required to deploy to accounts managed by
#'     Organizations. For more information, see [Grant Service-Managed
#'     Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
#' @param AutoDeployment Describes whether StackSets automatically deploys to Organizations
#' accounts that are added to the target organization or organizational
#' unit (OU). Specify only if `PermissionModel` is `SERVICE_MANAGED`.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   To create a stack set with service-managed permissions while signed
#'     in to the management account, specify `SELF`.
#' 
#' -   To create a stack set with service-managed permissions while signed
#'     in to a delegated administrator account, specify `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     admin in the management account. For more information, see [Register
#'     a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#' 
#' Stack sets with service-managed permissions are created in the
#' management account, including stack sets that are created by delegated
#' administrators.
#' @param ClientRequestToken A unique identifier for this
#' [`create_stack_set`][cloudformation_create_stack_set] request. Specify
#' this token if you plan to retry requests so that CloudFormation knows
#' that you're not attempting to create another stack set with the same
#' name. You might retry
#' [`create_stack_set`][cloudformation_create_stack_set] requests to ensure
#' that CloudFormation successfully received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' @param ManagedExecution Describes whether StackSets performs non-conflicting operations
#' concurrently and queues conflicting operations.
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack_set
cloudformation_create_stack_set <- function(StackSetName, Description = NULL, TemplateBody = NULL, TemplateURL = NULL, StackId = NULL, Parameters = NULL, Capabilities = NULL, Tags = NULL, AdministrationRoleARN = NULL, ExecutionRoleName = NULL, PermissionModel = NULL, AutoDeployment = NULL, CallAs = NULL, ClientRequestToken = NULL, ManagedExecution = NULL) {
  op <- new_operation(
    name = "CreateStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_set_input(StackSetName = StackSetName, Description = Description, TemplateBody = TemplateBody, TemplateURL = TemplateURL, StackId = StackId, Parameters = Parameters, Capabilities = Capabilities, Tags = Tags, AdministrationRoleARN = AdministrationRoleARN, ExecutionRoleName = ExecutionRoleName, PermissionModel = PermissionModel, AutoDeployment = AutoDeployment, CallAs = CallAs, ClientRequestToken = ClientRequestToken, ManagedExecution = ManagedExecution)
  output <- .cloudformation$create_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack_set <- cloudformation_create_stack_set

#' Deactivates trusted access with Organizations
#'
#' @description
#' Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not have permissions to create and manage service-managed StackSets for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_deactivate_organizations_access/](https://www.paws-r-sdk.com/docs/cloudformation_deactivate_organizations_access/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname cloudformation_deactivate_organizations_access
cloudformation_deactivate_organizations_access <- function() {
  op <- new_operation(
    name = "DeactivateOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$deactivate_organizations_access_input()
  output <- .cloudformation$deactivate_organizations_access_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$deactivate_organizations_access <- cloudformation_deactivate_organizations_access

#' Deactivates a public extension that was previously activated in this
#' account and Region
#'
#' @description
#' Deactivates a public extension that was previously activated in this account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_deactivate_type/](https://www.paws-r-sdk.com/docs/cloudformation_deactivate_type/) for full documentation.
#'
#' @param TypeName The type name of the extension, in this account and Region. If you
#' specified a type name alias when enabling the extension, use the type
#' name alias.
#' 
#' Conditional: You must specify either `Arn`, or `TypeName` and `Type`.
#' @param Type The extension type.
#' 
#' Conditional: You must specify either `Arn`, or `TypeName` and `Type`.
#' @param Arn The Amazon Resource Name (ARN) for the extension, in this account and
#' Region.
#' 
#' Conditional: You must specify either `Arn`, or `TypeName` and `Type`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_deactivate_type
cloudformation_deactivate_type <- function(TypeName = NULL, Type = NULL, Arn = NULL) {
  op <- new_operation(
    name = "DeactivateType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$deactivate_type_input(TypeName = TypeName, Type = Type, Arn = Arn)
  output <- .cloudformation$deactivate_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$deactivate_type <- cloudformation_deactivate_type

#' Deletes the specified change set
#'
#' @description
#' Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_delete_change_set/](https://www.paws-r-sdk.com/docs/cloudformation_delete_change_set/) for full documentation.
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' to delete.
#' @param StackName If you specified the name of a change set to delete, specify the stack
#' name or Amazon Resource Name (ARN) that's associated with it.
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_change_set
cloudformation_delete_change_set <- function(ChangeSetName, StackName = NULL) {
  op <- new_operation(
    name = "DeleteChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName)
  output <- .cloudformation$delete_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_change_set <- cloudformation_delete_change_set

#' Deletes a specified stack
#'
#' @description
#' Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the [`describe_stacks`][cloudformation_describe_stacks] operation if the deletion has been completed successfully.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_delete_stack/](https://www.paws-r-sdk.com/docs/cloudformation_delete_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that's associated with the stack.
#' @param RetainResources For stacks in the `DELETE_FAILED` state, a list of resource logical IDs
#' that are associated with the resources you want to retain. During
#' deletion, CloudFormation deletes the stack but doesn't delete the
#' retained resources.
#' 
#' Retaining resources is useful when you can't delete a resource, such as
#' a non-empty S3 bucket, but you want to delete the stack.
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management
#' (IAM) role that CloudFormation assumes to delete the stack.
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' 
#' If you don't specify a value, CloudFormation uses the role that was
#' previously associated with the stack. If no role is available,
#' CloudFormation uses a temporary session that's generated from your user
#' credentials.
#' @param ClientRequestToken A unique identifier for this
#' [`delete_stack`][cloudformation_delete_stack] request. Specify this
#' token if you plan to retry requests so that CloudFormation knows that
#' you're not attempting to delete a stack with the same name. You might
#' retry [`delete_stack`][cloudformation_delete_stack] requests to ensure
#' that CloudFormation successfully received them.
#' 
#' All events initiated by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a [`create_stack`][cloudformation_create_stack]
#' operation with the token `token1`, then all the `StackEvents` generated
#' by that operation will have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack
cloudformation_delete_stack <- function(StackName, RetainResources = NULL, RoleARN = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "DeleteStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_input(StackName = StackName, RetainResources = RetainResources, RoleARN = RoleARN, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$delete_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack <- cloudformation_delete_stack

#' Deletes stack instances for the specified accounts, in the specified
#' Amazon Web Services Regions
#'
#' @description
#' Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_delete_stack_instances/](https://www.paws-r-sdk.com/docs/cloudformation_delete_stack_instances/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to delete stack
#' instances for.
#' @param Accounts \[Self-managed permissions\] The names of the Amazon Web Services
#' accounts that you want to delete stack instances for.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[Service-managed permissions\] The Organizations accounts from which to
#' delete stack instances.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The Amazon Web Services Regions where you want to delete stack set
#' instances.
#' @param OperationPreferences Preferences for how CloudFormation performs this stack set operation.
#' @param RetainStacks &#91;required&#93; Removes the stack instances from the specified stack set, but doesn't
#' delete the stacks. You can't reassociate a retained stack or add an
#' existing, saved stack to a new stack set.
#' 
#' For more information, see [Stack set operation
#' options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' CloudFormation performs the stack set operation only once, even if you
#' retry the request multiple times. You can retry stack set operation
#' requests to ensure that CloudFormation successfully received them.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack_instances
cloudformation_delete_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, OperationPreferences = NULL, RetainStacks, OperationId = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "DeleteStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, OperationPreferences = OperationPreferences, RetainStacks = RetainStacks, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$delete_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack_instances <- cloudformation_delete_stack_instances

#' Deletes a stack set
#'
#' @description
#' Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more information about how to complete this, see [`delete_stack_instances`][cloudformation_delete_stack_instances].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_delete_stack_set/](https://www.paws-r-sdk.com/docs/cloudformation_delete_stack_set/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you're deleting. You can
#' obtain this value by running
#' [`list_stack_sets`][cloudformation_list_stack_sets].
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack_set
cloudformation_delete_stack_set <- function(StackSetName, CallAs = NULL) {
  op <- new_operation(
    name = "DeleteStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_set_input(StackSetName = StackSetName, CallAs = CallAs)
  output <- .cloudformation$delete_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack_set <- cloudformation_delete_stack_set

#' Marks an extension or extension version as DEPRECATED in the
#' CloudFormation registry, removing it from active use
#'
#' @description
#' Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_deregister_type/](https://www.paws-r-sdk.com/docs/cloudformation_deregister_type/) for full documentation.
#'
#' @param Arn The Amazon Resource Name (ARN) of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Type The kind of extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the extension. The version ID is the
#' value at the end of the Amazon Resource Name (ARN) assigned to the
#' extension version when it is registered.
#'
#' @keywords internal
#'
#' @rdname cloudformation_deregister_type
cloudformation_deregister_type <- function(Arn = NULL, Type = NULL, TypeName = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "DeregisterType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$deregister_type_input(Arn = Arn, Type = Type, TypeName = TypeName, VersionId = VersionId)
  output <- .cloudformation$deregister_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$deregister_type <- cloudformation_deregister_type

#' Retrieves your account's CloudFormation limits, such as the maximum
#' number of stacks that you can create in your account
#'
#' @description
#' Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [CloudFormation Quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_account_limits/](https://www.paws-r-sdk.com/docs/cloudformation_describe_account_limits/) for full documentation.
#'
#' @param NextToken A string that identifies the next page of limits that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_account_limits
cloudformation_describe_account_limits <- function(NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_account_limits_input(NextToken = NextToken)
  output <- .cloudformation$describe_account_limits_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_account_limits <- cloudformation_describe_account_limits

#' Returns the inputs for the change set and a list of changes that
#' CloudFormation will make if you execute the change set
#'
#' @description
#' Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Updating Stacks Using Change Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the CloudFormation User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_change_set/](https://www.paws-r-sdk.com/docs/cloudformation_describe_change_set/) for full documentation.
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' to describe.
#' @param StackName If you specified the name of a change set, specify the stack name or ID
#' (ARN) of the change set you want to describe.
#' @param NextToken A string (provided by the
#' [`describe_change_set`][cloudformation_describe_change_set] response
#' output) that identifies the next page of information that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_change_set
cloudformation_describe_change_set <- function(ChangeSetName, StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_change_set <- cloudformation_describe_change_set

#' Returns hook-related information for the change set and a list of
#' changes that CloudFormation makes when you run the change set
#'
#' @description
#' Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_change_set_hooks/](https://www.paws-r-sdk.com/docs/cloudformation_describe_change_set_hooks/) for full documentation.
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' to describe.
#' @param StackName If you specified the name of a change set, specify the stack name or
#' stack ID (ARN) of the change set you want to describe.
#' @param NextToken A string, provided by the
#' [`describe_change_set_hooks`][cloudformation_describe_change_set_hooks]
#' response output, that identifies the next page of information that you
#' want to retrieve.
#' @param LogicalResourceId If specified, lists only the hooks related to the specified
#' `LogicalResourceId`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_change_set_hooks
cloudformation_describe_change_set_hooks <- function(ChangeSetName, StackName = NULL, NextToken = NULL, LogicalResourceId = NULL) {
  op <- new_operation(
    name = "DescribeChangeSetHooks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_change_set_hooks_input(ChangeSetName = ChangeSetName, StackName = StackName, NextToken = NextToken, LogicalResourceId = LogicalResourceId)
  output <- .cloudformation$describe_change_set_hooks_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_change_set_hooks <- cloudformation_describe_change_set_hooks

#' Retrieves information about the account's OrganizationAccess status
#'
#' @description
#' Retrieves information about the account's `OrganizationAccess` status. This API can be called either by the management account or the delegated administrator by using the `CallAs` parameter. This API can also be called without the `CallAs` parameter by the management account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_organizations_access/](https://www.paws-r-sdk.com/docs/cloudformation_describe_organizations_access/) for full documentation.
#'
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_organizations_access
cloudformation_describe_organizations_access <- function(CallAs = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_organizations_access_input(CallAs = CallAs)
  output <- .cloudformation$describe_organizations_access_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_organizations_access <- cloudformation_describe_organizations_access

#' Returns information about a CloudFormation extension publisher
#'
#' @description
#' Returns information about a CloudFormation extension publisher.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_publisher/](https://www.paws-r-sdk.com/docs/cloudformation_describe_publisher/) for full documentation.
#'
#' @param PublisherId The ID of the extension publisher.
#' 
#' If you don't supply a `PublisherId`, and you have registered as an
#' extension publisher,
#' [`describe_publisher`][cloudformation_describe_publisher] returns
#' information about your own publisher account.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_publisher
cloudformation_describe_publisher <- function(PublisherId = NULL) {
  op <- new_operation(
    name = "DescribePublisher",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_publisher_input(PublisherId = PublisherId)
  output <- .cloudformation$describe_publisher_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_publisher <- cloudformation_describe_publisher

#' Returns information about a stack drift detection operation
#'
#' @description
#' Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_drift_detection_status/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_drift_detection_status/) for full documentation.
#'
#' @param StackDriftDetectionId &#91;required&#93; The ID of the drift detection results of this operation.
#' 
#' CloudFormation generates new results, with a new drift detection ID,
#' each time this operation is run. However, the number of drift results
#' CloudFormation retains for any given stack, and for how long, may vary.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_drift_detection_status
cloudformation_describe_stack_drift_detection_status <- function(StackDriftDetectionId) {
  op <- new_operation(
    name = "DescribeStackDriftDetectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_drift_detection_status_input(StackDriftDetectionId = StackDriftDetectionId)
  output <- .cloudformation$describe_stack_drift_detection_status_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_drift_detection_status <- cloudformation_describe_stack_drift_detection_status

#' Returns all stack related events for a specified stack in reverse
#' chronological order
#'
#' @description
#' Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, go to [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html) in the CloudFormation User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_events/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_events/) for full documentation.
#'
#' @param StackName The name or the unique stack ID that's associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of events that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_events
cloudformation_describe_stack_events <- function(StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStackEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_events_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_stack_events_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_events <- cloudformation_describe_stack_events

#' Returns the stack instance that's associated with the specified
#' StackSet, Amazon Web Services account, and Amazon Web Services Region
#'
#' @description
#' Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_instance/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_instance/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or the unique stack ID of the stack set that you want to get
#' stack instance information for.
#' @param StackInstanceAccount &#91;required&#93; The ID of an Amazon Web Services account that's associated with this
#' stack instance.
#' @param StackInstanceRegion &#91;required&#93; The name of a Region that's associated with this stack instance.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_instance
cloudformation_describe_stack_instance <- function(StackSetName, StackInstanceAccount, StackInstanceRegion, CallAs = NULL) {
  op <- new_operation(
    name = "DescribeStackInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_instance_input(StackSetName = StackSetName, StackInstanceAccount = StackInstanceAccount, StackInstanceRegion = StackInstanceRegion, CallAs = CallAs)
  output <- .cloudformation$describe_stack_instance_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_instance <- cloudformation_describe_stack_instance

#' Returns a description of the specified resource in the specified stack
#'
#' @description
#' Returns a description of the specified resource in the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resource/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resource/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that's associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param LogicalResourceId &#91;required&#93; The logical name of the resource as specified in the template.
#' 
#' Default: There is no default value.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resource
cloudformation_describe_stack_resource <- function(StackName, LogicalResourceId) {
  op <- new_operation(
    name = "DescribeStackResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resource_input(StackName = StackName, LogicalResourceId = LogicalResourceId)
  output <- .cloudformation$describe_stack_resource_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resource <- cloudformation_describe_stack_resource

#' Returns drift information for the resources that have been checked for
#' drift in the specified stack
#'
#' @description
#' Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resource_drifts/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resource_drifts/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for which you want drift information.
#' @param StackResourceDriftStatusFilters The resource drift status values to use as filters for the resource
#' drift results returned.
#' 
#' -   `DELETED`: The resource differs from its expected template
#'     configuration in that the resource has been deleted.
#' 
#' -   `MODIFIED`: One or more resource properties differ from their
#'     expected template values.
#' 
#' -   `IN_SYNC`: The resource's actual configuration matches its expected
#'     template configuration.
#' 
#' -   `NOT_CHECKED`: CloudFormation doesn't currently return this value.
#' @param NextToken A string that identifies the next page of stack resource drift results.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resource_drifts
cloudformation_describe_stack_resource_drifts <- function(StackName, StackResourceDriftStatusFilters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeStackResourceDrifts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resource_drifts_input(StackName = StackName, StackResourceDriftStatusFilters = StackResourceDriftStatusFilters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudformation$describe_stack_resource_drifts_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resource_drifts <- cloudformation_describe_stack_resource_drifts

#' Returns Amazon Web Services resource descriptions for running and
#' deleted stacks
#'
#' @description
#' Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resources/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_resources/) for full documentation.
#'
#' @param StackName The name or the unique stack ID that is associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' 
#' Required: Conditional. If you don't specify `StackName`, you must
#' specify `PhysicalResourceId`.
#' @param LogicalResourceId The logical name of the resource as specified in the template.
#' 
#' Default: There is no default value.
#' @param PhysicalResourceId The name or unique identifier that corresponds to a physical instance ID
#' of a resource supported by CloudFormation.
#' 
#' For example, for an Amazon Elastic Compute Cloud (EC2) instance,
#' `PhysicalResourceId` corresponds to the `InstanceId`. You can pass the
#' EC2 `InstanceId` to
#' [`describe_stack_resources`][cloudformation_describe_stack_resources] to
#' find which stack the instance belongs to and what other resources are
#' part of the stack.
#' 
#' Required: Conditional. If you don't specify `PhysicalResourceId`, you
#' must specify `StackName`.
#' 
#' Default: There is no default value.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resources
cloudformation_describe_stack_resources <- function(StackName = NULL, LogicalResourceId = NULL, PhysicalResourceId = NULL) {
  op <- new_operation(
    name = "DescribeStackResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resources_input(StackName = StackName, LogicalResourceId = LogicalResourceId, PhysicalResourceId = PhysicalResourceId)
  output <- .cloudformation$describe_stack_resources_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resources <- cloudformation_describe_stack_resources

#' Returns the description of the specified StackSet
#'
#' @description
#' Returns the description of the specified StackSet.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_set/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_set/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set whose description you want.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_set
cloudformation_describe_stack_set <- function(StackSetName, CallAs = NULL) {
  op <- new_operation(
    name = "DescribeStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_set_input(StackSetName = StackSetName, CallAs = CallAs)
  output <- .cloudformation$describe_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_set <- cloudformation_describe_stack_set

#' Returns the description of the specified StackSet operation
#'
#' @description
#' Returns the description of the specified StackSet operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_set_operation/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_set_operation/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or the unique stack ID of the stack set for the stack
#' operation.
#' @param OperationId &#91;required&#93; The unique ID of the stack set operation.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_set_operation
cloudformation_describe_stack_set_operation <- function(StackSetName, OperationId, CallAs = NULL) {
  op <- new_operation(
    name = "DescribeStackSetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_set_operation_input(StackSetName = StackSetName, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$describe_stack_set_operation_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_set_operation <- cloudformation_describe_stack_set_operation

#' Returns the description for the specified stack; if no stack name was
#' specified, then it returns the description for all the stacks created
#'
#' @description
#' Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_stacks/](https://www.paws-r-sdk.com/docs/cloudformation_describe_stacks/) for full documentation.
#'
#' @param StackName If you don't pass a parameter to `StackName`, the API returns a response
#' that describes all resources in the account. This requires
#' [`list_stacks`][cloudformation_list_stacks] and
#' [`describe_stacks`][cloudformation_describe_stacks] permissions.
#' 
#' The IAM policy below can be added to IAM policies when you want to limit
#' resource-level permissions and avoid returning a response when no
#' parameter is sent in the request:
#' 
#' \{ "Version": "2012-10-17", "Statement": \[\{ "Effect": "Deny",
#' "Action": "cloudformation:DescribeStacks", "NotResource":
#' "arn:aws:cloudformation:*:*:stack/*/*" \}\] \}
#' 
#' The name or the unique stack ID that's associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of stacks that you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stacks
cloudformation_describe_stacks <- function(StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stacks_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_stacks_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stacks <- cloudformation_describe_stacks

#' Returns detailed information about an extension that has been registered
#'
#' @description
#' Returns detailed information about an extension that has been registered.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_type/](https://www.paws-r-sdk.com/docs/cloudformation_describe_type/) for full documentation.
#'
#' @param Type The kind of extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Arn The Amazon Resource Name (ARN) of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the extension. The version ID is the
#' value at the end of the Amazon Resource Name (ARN) assigned to the
#' extension version when it is registered.
#' 
#' If you specify a `VersionId`,
#' [`describe_type`][cloudformation_describe_type] returns information
#' about that specific extension version. Otherwise, it returns information
#' about the default extension version.
#' @param PublisherId The publisher ID of the extension publisher.
#' 
#' Extensions provided by Amazon Web Services are not assigned a publisher
#' ID.
#' @param PublicVersionNumber The version number of a public third-party extension.
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_type
cloudformation_describe_type <- function(Type = NULL, TypeName = NULL, Arn = NULL, VersionId = NULL, PublisherId = NULL, PublicVersionNumber = NULL) {
  op <- new_operation(
    name = "DescribeType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_type_input(Type = Type, TypeName = TypeName, Arn = Arn, VersionId = VersionId, PublisherId = PublisherId, PublicVersionNumber = PublicVersionNumber)
  output <- .cloudformation$describe_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_type <- cloudformation_describe_type

#' Returns information about an extension's registration, including its
#' current status and type and version identifiers
#'
#' @description
#' Returns information about an extension's registration, including its current status and type and version identifiers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_describe_type_registration/](https://www.paws-r-sdk.com/docs/cloudformation_describe_type_registration/) for full documentation.
#'
#' @param RegistrationToken &#91;required&#93; The identifier for this registration request.
#' 
#' This registration token is generated by CloudFormation when you initiate
#' a registration request using
#' [`register_type`][cloudformation_register_type].
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_type_registration
cloudformation_describe_type_registration <- function(RegistrationToken) {
  op <- new_operation(
    name = "DescribeTypeRegistration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_type_registration_input(RegistrationToken = RegistrationToken)
  output <- .cloudformation$describe_type_registration_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_type_registration <- cloudformation_describe_type_registration

#' Detects whether a stack's actual configuration differs, or has drifted,
#' from its expected configuration, as defined in the stack template and
#' any values specified as template parameters
#'
#' @description
#' Detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_drift/](https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_drift/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for which you want to detect drift.
#' @param LogicalResourceIds The logical names of any resources you want to use as filters.
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_drift
cloudformation_detect_stack_drift <- function(StackName, LogicalResourceIds = NULL) {
  op <- new_operation(
    name = "DetectStackDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_drift_input(StackName = StackName, LogicalResourceIds = LogicalResourceIds)
  output <- .cloudformation$detect_stack_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_drift <- cloudformation_detect_stack_drift

#' Returns information about whether a resource's actual configuration
#' differs, or has drifted, from its expected configuration, as defined in
#' the stack template and any values specified as template parameters
#'
#' @description
#' Returns information about whether a resource's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_resource_drift/](https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_resource_drift/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack to which the resource belongs.
#' @param LogicalResourceId &#91;required&#93; The logical name of the resource for which to return drift information.
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_resource_drift
cloudformation_detect_stack_resource_drift <- function(StackName, LogicalResourceId) {
  op <- new_operation(
    name = "DetectStackResourceDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_resource_drift_input(StackName = StackName, LogicalResourceId = LogicalResourceId)
  output <- .cloudformation$detect_stack_resource_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_resource_drift <- cloudformation_detect_stack_resource_drift

#' Detect drift on a stack set
#'
#' @description
#' Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see [How CloudFormation performs drift detection on a stack set](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_set_drift/](https://www.paws-r-sdk.com/docs/cloudformation_detect_stack_set_drift/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name of the stack set on which to perform the drift detection
#' operation.
#' @param OperationPreferences The user-specified preferences for how CloudFormation performs a stack
#' set operation.
#' 
#' For more information about maximum concurrent accounts and failure
#' tolerance, see [Stack set operation
#' options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
#' @param OperationId *The ID of the stack set operation.*
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_set_drift
cloudformation_detect_stack_set_drift <- function(StackSetName, OperationPreferences = NULL, OperationId = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "DetectStackSetDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_set_drift_input(StackSetName = StackSetName, OperationPreferences = OperationPreferences, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$detect_stack_set_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_set_drift <- cloudformation_detect_stack_set_drift

#' Returns the estimated monthly cost of a template
#'
#' @description
#' Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_estimate_template_cost/](https://www.paws-r-sdk.com/docs/cloudformation_estimate_template_cost/) for full documentation.
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. (For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.)
#' 
#' Conditional: You must pass `TemplateBody` or `TemplateURL`. If both are
#' passed, only `TemplateBody` is used.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template that's located in an Amazon S3 bucket or a Systems Manager
#' document. For more information, go to [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#' @param Parameters A list of `Parameter` structures that specify input parameters.
#'
#' @keywords internal
#'
#' @rdname cloudformation_estimate_template_cost
cloudformation_estimate_template_cost <- function(TemplateBody = NULL, TemplateURL = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "EstimateTemplateCost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$estimate_template_cost_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL, Parameters = Parameters)
  output <- .cloudformation$estimate_template_cost_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$estimate_template_cost <- cloudformation_estimate_template_cost

#' Updates a stack using the input information that was provided when the
#' specified change set was created
#'
#' @description
#' Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the [`describe_stacks`][cloudformation_describe_stacks] action to view the status of the update.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_execute_change_set/](https://www.paws-r-sdk.com/docs/cloudformation_execute_change_set/) for full documentation.
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' use to update the specified stack.
#' @param StackName If you specified the name of a change set, specify the stack name or
#' Amazon Resource Name (ARN) that's associated with the change set you
#' want to execute.
#' @param ClientRequestToken A unique identifier for this
#' [`execute_change_set`][cloudformation_execute_change_set] request.
#' Specify this token if you plan to retry requests so that CloudFormation
#' knows that you're not attempting to execute a change set to update a
#' stack with the same name. You might retry
#' [`execute_change_set`][cloudformation_execute_change_set] requests to
#' ensure that CloudFormation successfully received them.
#' @param DisableRollback Preserves the state of previously provisioned resources when an
#' operation fails.
#' 
#' Default: `True`
#'
#' @keywords internal
#'
#' @rdname cloudformation_execute_change_set
cloudformation_execute_change_set <- function(ChangeSetName, StackName = NULL, ClientRequestToken = NULL, DisableRollback = NULL) {
  op <- new_operation(
    name = "ExecuteChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$execute_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName, ClientRequestToken = ClientRequestToken, DisableRollback = DisableRollback)
  output <- .cloudformation$execute_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$execute_change_set <- cloudformation_execute_change_set

#' Returns the stack policy for a specified stack
#'
#' @description
#' Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_get_stack_policy/](https://www.paws-r-sdk.com/docs/cloudformation_get_stack_policy/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or unique stack ID that's associated with the stack whose
#' policy you want to get.
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_stack_policy
cloudformation_get_stack_policy <- function(StackName) {
  op <- new_operation(
    name = "GetStackPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_stack_policy_input(StackName = StackName)
  output <- .cloudformation$get_stack_policy_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_stack_policy <- cloudformation_get_stack_policy

#' Returns the template body for a specified stack
#'
#' @description
#' Returns the template body for a specified stack. You can get the template for running or deleted stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_get_template/](https://www.paws-r-sdk.com/docs/cloudformation_get_template/) for full documentation.
#'
#' @param StackName The name or the unique stack ID that's associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param ChangeSetName The name or Amazon Resource Name (ARN) of a change set for which
#' CloudFormation returns the associated template. If you specify a name,
#' you must also specify the `StackName`.
#' @param TemplateStage For templates that include transforms, the stage of the template that
#' CloudFormation returns. To get the user-submitted template, specify
#' `Original`. To get the template after CloudFormation has processed all
#' transforms, specify `Processed`.
#' 
#' If the template doesn't include transforms, `Original` and `Processed`
#' return the same template. By default, CloudFormation specifies
#' `Processed`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_template
cloudformation_get_template <- function(StackName = NULL, ChangeSetName = NULL, TemplateStage = NULL) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_template_input(StackName = StackName, ChangeSetName = ChangeSetName, TemplateStage = TemplateStage)
  output <- .cloudformation$get_template_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_template <- cloudformation_get_template

#' Returns information about a new or existing template
#'
#' @description
#' Returns information about a new or existing template. The [`get_template_summary`][cloudformation_get_template_summary] action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or stack set.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_get_template_summary/](https://www.paws-r-sdk.com/docs/cloudformation_get_template_summary/) for full documentation.
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information about
#' templates, see [Template
#' anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that's located in an Amazon S3 bucket
#' or a Systems Manager document. For more information about templates, see
#' [Template
#' anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param StackName The name or the stack ID that's associated with the stack, which aren't
#' always interchangeable. For running stacks, you can specify either the
#' stack's name or its unique stack ID. For deleted stack, you must specify
#' the unique stack ID.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param StackSetName The name or unique ID of the stack set from which the stack was created.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_template_summary
cloudformation_get_template_summary <- function(TemplateBody = NULL, TemplateURL = NULL, StackName = NULL, StackSetName = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "GetTemplateSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_template_summary_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL, StackName = StackName, StackSetName = StackSetName, CallAs = CallAs)
  output <- .cloudformation$get_template_summary_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_template_summary <- cloudformation_get_template_summary

#' Import existing stacks into a new stack sets
#'
#' @description
#' Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_import_stacks_to_stack_set/](https://www.paws-r-sdk.com/docs/cloudformation_import_stacks_to_stack_set/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name of the stack set. The name must be unique in the Region where
#' you create your stack set.
#' @param StackIds The IDs of the stacks you are importing into a stack set. You import up
#' to 10 stacks per stack set at a time.
#' 
#' Specify either `StackIds` or `StackIdsUrl`.
#' @param StackIdsUrl The Amazon S3 URL which contains list of stack ids to be inputted.
#' 
#' Specify either `StackIds` or `StackIdsUrl`.
#' @param OrganizationalUnitIds The list of OU ID's to which the stacks being imported has to be mapped
#' as deployment target.
#' @param OperationPreferences The user-specified preferences for how CloudFormation performs a stack
#' set operation.
#' 
#' For more information about maximum concurrent accounts and failure
#' tolerance, see [Stack set operation
#' options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
#' @param OperationId A unique, user defined, identifier for the stack set operation.
#' @param CallAs By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   For service managed stack sets, specify `DELEGATED_ADMIN`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_import_stacks_to_stack_set
cloudformation_import_stacks_to_stack_set <- function(StackSetName, StackIds = NULL, StackIdsUrl = NULL, OrganizationalUnitIds = NULL, OperationPreferences = NULL, OperationId = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "ImportStacksToStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$import_stacks_to_stack_set_input(StackSetName = StackSetName, StackIds = StackIds, StackIdsUrl = StackIdsUrl, OrganizationalUnitIds = OrganizationalUnitIds, OperationPreferences = OperationPreferences, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$import_stacks_to_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$import_stacks_to_stack_set <- cloudformation_import_stacks_to_stack_set

#' Returns the ID and status of each active change set for a stack
#'
#' @description
#' Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_change_sets/](https://www.paws-r-sdk.com/docs/cloudformation_list_change_sets/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the Amazon Resource Name (ARN) of the stack for which you
#' want to list change sets.
#' @param NextToken A string (provided by the
#' [`list_change_sets`][cloudformation_list_change_sets] response output)
#' that identifies the next page of change sets that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_change_sets
cloudformation_list_change_sets <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListChangeSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_change_sets_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$list_change_sets_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_change_sets <- cloudformation_list_change_sets

#' Lists all exported output values in the account and Region in which you
#' call this action
#'
#' @description
#' Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the [Fn::ImportValue](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_exports/](https://www.paws-r-sdk.com/docs/cloudformation_list_exports/) for full documentation.
#'
#' @param NextToken A string (provided by the [`list_exports`][cloudformation_list_exports]
#' response output) that identifies the next page of exported output values
#' that you asked to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_exports
cloudformation_list_exports <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListExports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_exports_input(NextToken = NextToken)
  output <- .cloudformation$list_exports_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_exports <- cloudformation_list_exports

#' Lists all stacks that are importing an exported output value
#'
#' @description
#' Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see [`list_exports`][cloudformation_list_exports].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_imports/](https://www.paws-r-sdk.com/docs/cloudformation_list_imports/) for full documentation.
#'
#' @param ExportName &#91;required&#93; The name of the exported output value. CloudFormation returns the stack
#' names that are importing this value.
#' @param NextToken A string (provided by the [`list_imports`][cloudformation_list_imports]
#' response output) that identifies the next page of stacks that are
#' importing the specified exported output value.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_imports
cloudformation_list_imports <- function(ExportName, NextToken = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_imports_input(ExportName = ExportName, NextToken = NextToken)
  output <- .cloudformation$list_imports_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_imports <- cloudformation_list_imports

#' Returns summary information about stack instances that are associated
#' with the specified stack set
#'
#' @description
#' Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stack_instances/](https://www.paws-r-sdk.com/docs/cloudformation_list_stack_instances/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to list stack
#' instances for.
#' @param NextToken If the previous request didn't return all the remaining results, the
#' response's `NextToken` parameter value is set to a token. To retrieve
#' the next set of results, call
#' [`list_stack_instances`][cloudformation_list_stack_instances] again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param Filters The filter to apply to stack instances
#' @param StackInstanceAccount The name of the Amazon Web Services account that you want to list stack
#' instances for.
#' @param StackInstanceRegion The name of the Region where you want to list stack instances.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_instances
cloudformation_list_stack_instances <- function(StackSetName, NextToken = NULL, MaxResults = NULL, Filters = NULL, StackInstanceAccount = NULL, StackInstanceRegion = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "ListStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_instances_input(StackSetName = StackSetName, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, StackInstanceAccount = StackInstanceAccount, StackInstanceRegion = StackInstanceRegion, CallAs = CallAs)
  output <- .cloudformation$list_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_instances <- cloudformation_list_stack_instances

#' Returns descriptions of all resources of the specified stack
#'
#' @description
#' Returns descriptions of all resources of the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stack_resources/](https://www.paws-r-sdk.com/docs/cloudformation_list_stack_resources/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that is associated with the stack, which
#' aren't always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of stack resources that you want
#' to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_resources
cloudformation_list_stack_resources <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListStackResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_resources_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$list_stack_resources_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_resources <- cloudformation_list_stack_resources

#' Returns summary information about the results of a stack set operation
#'
#' @description
#' Returns summary information about the results of a stack set operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stack_set_operation_results/](https://www.paws-r-sdk.com/docs/cloudformation_list_stack_set_operation_results/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to get operation
#' results for.
#' @param OperationId &#91;required&#93; The ID of the stack set operation.
#' @param NextToken If the previous request didn't return all the remaining results, the
#' response object's `NextToken` parameter value is set to a token. To
#' retrieve the next set of results, call
#' [`list_stack_set_operation_results`][cloudformation_list_stack_set_operation_results]
#' again and assign that token to the request object's `NextToken`
#' parameter. If there are no remaining results, the previous response
#' object's `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#' @param Filters The filter to apply to operation results.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_set_operation_results
cloudformation_list_stack_set_operation_results <- function(StackSetName, OperationId, NextToken = NULL, MaxResults = NULL, CallAs = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListStackSetOperationResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_set_operation_results_input(StackSetName = StackSetName, OperationId = OperationId, NextToken = NextToken, MaxResults = MaxResults, CallAs = CallAs, Filters = Filters)
  output <- .cloudformation$list_stack_set_operation_results_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_set_operation_results <- cloudformation_list_stack_set_operation_results

#' Returns summary information about operations performed on a stack set
#'
#' @description
#' Returns summary information about operations performed on a stack set.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stack_set_operations/](https://www.paws-r-sdk.com/docs/cloudformation_list_stack_set_operations/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to get operation
#' summaries for.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call
#' [`list_stack_set_operations`][cloudformation_list_stack_set_operations]
#' again and assign that token to the request object's `NextToken`
#' parameter. If there are no remaining results, the previous response
#' object's `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_set_operations
cloudformation_list_stack_set_operations <- function(StackSetName, NextToken = NULL, MaxResults = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "ListStackSetOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_set_operations_input(StackSetName = StackSetName, NextToken = NextToken, MaxResults = MaxResults, CallAs = CallAs)
  output <- .cloudformation$list_stack_set_operations_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_set_operations <- cloudformation_list_stack_set_operations

#' Returns summary information about stack sets that are associated with
#' the user
#'
#' @description
#' Returns summary information about stack sets that are associated with the user.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stack_sets/](https://www.paws-r-sdk.com/docs/cloudformation_list_stack_sets/) for full documentation.
#'
#' @param NextToken If the previous paginated request didn't return all the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call
#' [`list_stack_sets`][cloudformation_list_stack_sets] again and assign
#' that token to the request object's `NextToken` parameter. If there are
#' no remaining results, the previous response object's `NextToken`
#' parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param Status The status of the stack sets that you want to get summary information
#' about.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the management account or as a delegated
#' administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_sets
cloudformation_list_stack_sets <- function(NextToken = NULL, MaxResults = NULL, Status = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "ListStackSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_sets_input(NextToken = NextToken, MaxResults = MaxResults, Status = Status, CallAs = CallAs)
  output <- .cloudformation$list_stack_sets_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_sets <- cloudformation_list_stack_sets

#' Returns the summary information for stacks whose status matches the
#' specified StackStatusFilter
#'
#' @description
#' Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_stacks/](https://www.paws-r-sdk.com/docs/cloudformation_list_stacks/) for full documentation.
#'
#' @param NextToken A string that identifies the next page of stacks that you want to
#' retrieve.
#' @param StackStatusFilter Stack status to use as a filter. Specify one or more stack status codes
#' to list only stacks with the specified status codes. For a complete list
#' of stack status codes, see the `StackStatus` parameter of the Stack data
#' type.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stacks
cloudformation_list_stacks <- function(NextToken = NULL, StackStatusFilter = NULL) {
  op <- new_operation(
    name = "ListStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stacks_input(NextToken = NextToken, StackStatusFilter = StackStatusFilter)
  output <- .cloudformation$list_stacks_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stacks <- cloudformation_list_stacks

#' Returns a list of registration tokens for the specified extension(s)
#'
#' @description
#' Returns a list of registration tokens for the specified extension(s).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_type_registrations/](https://www.paws-r-sdk.com/docs/cloudformation_list_type_registrations/) for full documentation.
#'
#' @param Type The kind of extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeArn The Amazon Resource Name (ARN) of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param RegistrationStatusFilter The current status of the extension registration request.
#' 
#' The default is `IN_PROGRESS`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_type_registrations
cloudformation_list_type_registrations <- function(Type = NULL, TypeName = NULL, TypeArn = NULL, RegistrationStatusFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTypeRegistrations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_type_registrations_input(Type = Type, TypeName = TypeName, TypeArn = TypeArn, RegistrationStatusFilter = RegistrationStatusFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudformation$list_type_registrations_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_type_registrations <- cloudformation_list_type_registrations

#' Returns summary information about the versions of an extension
#'
#' @description
#' Returns summary information about the versions of an extension.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_type_versions/](https://www.paws-r-sdk.com/docs/cloudformation_list_type_versions/) for full documentation.
#'
#' @param Type The kind of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the extension for which you want version summary
#' information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Arn The Amazon Resource Name (ARN) of the extension for which you want
#' version summary information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param DeprecatedStatus The deprecation status of the extension versions that you want to get
#' summary information about.
#' 
#' Valid values include:
#' 
#' -   `LIVE`: The extension version is registered and can be used in
#'     CloudFormation operations, dependent on its provisioning behavior
#'     and visibility scope.
#' 
#' -   `DEPRECATED`: The extension version has been deregistered and can no
#'     longer be used in CloudFormation operations.
#' 
#' The default is `LIVE`.
#' @param PublisherId The publisher ID of the extension publisher.
#' 
#' Extensions published by Amazon aren't assigned a publisher ID.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_type_versions
cloudformation_list_type_versions <- function(Type = NULL, TypeName = NULL, Arn = NULL, MaxResults = NULL, NextToken = NULL, DeprecatedStatus = NULL, PublisherId = NULL) {
  op <- new_operation(
    name = "ListTypeVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_type_versions_input(Type = Type, TypeName = TypeName, Arn = Arn, MaxResults = MaxResults, NextToken = NextToken, DeprecatedStatus = DeprecatedStatus, PublisherId = PublisherId)
  output <- .cloudformation$list_type_versions_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_type_versions <- cloudformation_list_type_versions

#' Returns summary information about extension that have been registered
#' with CloudFormation
#'
#' @description
#' Returns summary information about extension that have been registered with CloudFormation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_list_types/](https://www.paws-r-sdk.com/docs/cloudformation_list_types/) for full documentation.
#'
#' @param Visibility The scope at which the extensions are visible and usable in
#' CloudFormation operations.
#' 
#' Valid values include:
#' 
#' -   `PRIVATE`: Extensions that are visible and usable within this
#'     account and Region. This includes:
#' 
#'     -   Private extensions you have registered in this account and
#'         Region.
#' 
#'     -   Public extensions that you have activated in this account and
#'         Region.
#' 
#' -   `PUBLIC`: Extensions that are publicly visible and available to be
#'     activated within any Amazon Web Services account. This includes
#'     extensions from Amazon Web Services, in addition to third-party
#'     publishers.
#' 
#' The default is `PRIVATE`.
#' @param ProvisioningType For resource types, the provisioning behavior of the resource type.
#' CloudFormation determines the provisioning type during registration,
#' based on the types of handlers in the schema handler package submitted.
#' 
#' Valid values include:
#' 
#' -   `FULLY_MUTABLE`: The resource type includes an update handler to
#'     process updates to the type during stack update operations.
#' 
#' -   `IMMUTABLE`: The resource type doesn't include an update handler, so
#'     the type can't be updated and must instead be replaced during stack
#'     update operations.
#' 
#' -   `NON_PROVISIONABLE`: The resource type doesn't include create, read,
#'     and delete handlers, and therefore can't actually be provisioned.
#' 
#' The default is `FULLY_MUTABLE`.
#' @param DeprecatedStatus The deprecation status of the extension that you want to get summary
#' information about.
#' 
#' Valid values include:
#' 
#' -   `LIVE`: The extension is registered for use in CloudFormation
#'     operations.
#' 
#' -   `DEPRECATED`: The extension has been deregistered and can no longer
#'     be used in CloudFormation operations.
#' @param Type The type of extension.
#' @param Filters Filter criteria to use in determining which extensions to return.
#' 
#' Filters must be compatible with `Visibility` to return valid results.
#' For example, specifying `AWS_TYPES` for `Category` and `PRIVATE` for
#' `Visibility` returns an empty list of types, but specifying `PUBLIC` for
#' `Visibility` returns the desired list.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_types
cloudformation_list_types <- function(Visibility = NULL, ProvisioningType = NULL, DeprecatedStatus = NULL, Type = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_types_input(Visibility = Visibility, ProvisioningType = ProvisioningType, DeprecatedStatus = DeprecatedStatus, Type = Type, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudformation$list_types_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_types <- cloudformation_list_types

#' Publishes the specified extension to the CloudFormation registry as a
#' public extension in this Region
#'
#' @description
#' Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_publish_type/](https://www.paws-r-sdk.com/docs/cloudformation_publish_type/) for full documentation.
#'
#' @param Type The type of the extension.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param Arn The Amazon Resource Name (ARN) of the extension.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param PublicVersionNumber The version number to assign to this version of the extension.
#' 
#' Use the following format, and adhere to semantic versioning when
#' assigning a version number to your extension:
#' 
#' `MAJOR.MINOR.PATCH`
#' 
#' For more information, see [Semantic Versioning
#' 2.0.0](https://semver.org/).
#' 
#' If you don't specify a version number, CloudFormation increments the
#' version number by one minor version release.
#' 
#' You cannot specify a version number the first time you publish a type.
#' CloudFormation automatically sets the first version number to be
#' `1.0.0`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_publish_type
cloudformation_publish_type <- function(Type = NULL, Arn = NULL, TypeName = NULL, PublicVersionNumber = NULL) {
  op <- new_operation(
    name = "PublishType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$publish_type_input(Type = Type, Arn = Arn, TypeName = TypeName, PublicVersionNumber = PublicVersionNumber)
  output <- .cloudformation$publish_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$publish_type <- cloudformation_publish_type

#' Reports progress of a resource handler to CloudFormation
#'
#' @description
#' Reports progress of a resource handler to CloudFormation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_record_handler_progress/](https://www.paws-r-sdk.com/docs/cloudformation_record_handler_progress/) for full documentation.
#'
#' @param BearerToken &#91;required&#93; Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param OperationStatus &#91;required&#93; Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param CurrentOperationStatus Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param StatusMessage Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ErrorCode Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ResourceModel Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ClientRequestToken Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#'
#' @keywords internal
#'
#' @rdname cloudformation_record_handler_progress
cloudformation_record_handler_progress <- function(BearerToken, OperationStatus, CurrentOperationStatus = NULL, StatusMessage = NULL, ErrorCode = NULL, ResourceModel = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "RecordHandlerProgress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$record_handler_progress_input(BearerToken = BearerToken, OperationStatus = OperationStatus, CurrentOperationStatus = CurrentOperationStatus, StatusMessage = StatusMessage, ErrorCode = ErrorCode, ResourceModel = ResourceModel, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$record_handler_progress_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$record_handler_progress <- cloudformation_record_handler_progress

#' Registers your account as a publisher of public extensions in the
#' CloudFormation registry
#'
#' @description
#' Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_register_publisher/](https://www.paws-r-sdk.com/docs/cloudformation_register_publisher/) for full documentation.
#'
#' @param AcceptTermsAndConditions Whether you accept the [Terms and
#' Conditions](https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf)
#' for publishing extensions in the CloudFormation registry. You must
#' accept the terms and conditions in order to register to publish public
#' extensions to the CloudFormation registry.
#' 
#' The default is `false`.
#' @param ConnectionArn If you are using a Bitbucket or GitHub account for identity
#' verification, the Amazon Resource Name (ARN) for your connection to that
#' account.
#' 
#' For more information, see [Registering your account to publish
#' CloudFormation
#' extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs)
#' in the *CloudFormation CLI User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_register_publisher
cloudformation_register_publisher <- function(AcceptTermsAndConditions = NULL, ConnectionArn = NULL) {
  op <- new_operation(
    name = "RegisterPublisher",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$register_publisher_input(AcceptTermsAndConditions = AcceptTermsAndConditions, ConnectionArn = ConnectionArn)
  output <- .cloudformation$register_publisher_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$register_publisher <- cloudformation_register_publisher

#' Registers an extension with the CloudFormation service
#'
#' @description
#' Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_register_type/](https://www.paws-r-sdk.com/docs/cloudformation_register_type/) for full documentation.
#'
#' @param Type The kind of extension.
#' @param TypeName &#91;required&#93; The name of the extension being registered.
#' 
#' We suggest that extension names adhere to the following patterns:
#' 
#' -   For resource types, *company_or_organization*::*service*::*type*.
#' 
#' -   For modules, *company_or_organization*::*service*::*type*::MODULE.
#' 
#' -   For hooks, *MyCompany*::*Testing*::*MyTestHook*.
#' 
#' The following organization namespaces are reserved and can't be used in
#' your extension names:
#' 
#' -   `Alexa`
#' 
#' -   `AMZN`
#' 
#' -   `Amazon`
#' 
#' -   `AWS`
#' 
#' -   `Custom`
#' 
#' -   `Dev`
#' @param SchemaHandlerPackage &#91;required&#93; A URL to the S3 bucket containing the extension project package that
#' contains the necessary files for the extension you want to register.
#' 
#' For information about generating a schema handler package for the
#' extension you want to register, see
#' [submit](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html)
#' in the *CloudFormation CLI User Guide*.
#' 
#' The user registering the extension must be able to access the package in
#' the S3 bucket. That's, the user needs to have
#' [GetObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
#' permissions for the schema handler package. For more information, see
#' [Actions, Resources, and Condition Keys for Amazon
#' S3](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html)
#' in the *Identity and Access Management User Guide*.
#' @param LoggingConfig Specifies logging configuration information for an extension.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role for CloudFormation to
#' assume when invoking the extension.
#' 
#' For CloudFormation to assume the specified execution role, the role must
#' contain a trust relationship with the CloudFormation service principle
#' (`resources.cloudformation.amazonaws.com`). For more information about
#' adding trust relationships, see [Modifying a role trust
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy)
#' in the *Identity and Access Management User Guide*.
#' 
#' If your extension calls Amazon Web Services APIs in any of its handlers,
#' you must create an *\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html}{IAM execution role}* that includes the necessary permissions to call
#' those Amazon Web Services APIs, and provision that execution role in
#' your account. When CloudFormation needs to invoke the resource type
#' handler, CloudFormation assumes this execution role to create a
#' temporary session token, which it then passes to the resource type
#' handler, thereby supplying your resource type with the appropriate
#' credentials.
#' @param ClientRequestToken A unique identifier that acts as an idempotency key for this
#' registration request. Specifying a client request token prevents
#' CloudFormation from generating more than one version of an extension
#' from the same registration request, even if the request is submitted
#' multiple times.
#'
#' @keywords internal
#'
#' @rdname cloudformation_register_type
cloudformation_register_type <- function(Type = NULL, TypeName, SchemaHandlerPackage, LoggingConfig = NULL, ExecutionRoleArn = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "RegisterType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$register_type_input(Type = Type, TypeName = TypeName, SchemaHandlerPackage = SchemaHandlerPackage, LoggingConfig = LoggingConfig, ExecutionRoleArn = ExecutionRoleArn, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$register_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$register_type <- cloudformation_register_type

#' When specifying RollbackStack, you preserve the state of previously
#' provisioned resources when an operation fails
#'
#' @description
#' When specifying [`rollback_stack`][cloudformation_rollback_stack], you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the [`describe_stacks`][cloudformation_describe_stacks] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_rollback_stack/](https://www.paws-r-sdk.com/docs/cloudformation_rollback_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name that's associated with the stack.
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management role
#' that CloudFormation assumes to rollback the stack.
#' @param ClientRequestToken A unique identifier for this
#' [`rollback_stack`][cloudformation_rollback_stack] request.
#'
#' @keywords internal
#'
#' @rdname cloudformation_rollback_stack
cloudformation_rollback_stack <- function(StackName, RoleARN = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "RollbackStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$rollback_stack_input(StackName = StackName, RoleARN = RoleARN, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$rollback_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$rollback_stack <- cloudformation_rollback_stack

#' Sets a stack policy for a specified stack
#'
#' @description
#' Sets a stack policy for a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_set_stack_policy/](https://www.paws-r-sdk.com/docs/cloudformation_set_stack_policy/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or unique stack ID that you want to associate a policy with.
#' @param StackPolicyBody Structure containing the stack policy body. For more information, go to
#' [Prevent updates to stack
#' resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
#' in the CloudFormation User Guide. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' @param StackPolicyURL Location of a file containing the stack policy. The URL must point to a
#' policy (maximum size: 16 KB) located in an Amazon S3 bucket in the same
#' Amazon Web Services Region as the stack. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#'
#' @keywords internal
#'
#' @rdname cloudformation_set_stack_policy
cloudformation_set_stack_policy <- function(StackName, StackPolicyBody = NULL, StackPolicyURL = NULL) {
  op <- new_operation(
    name = "SetStackPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$set_stack_policy_input(StackName = StackName, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL)
  output <- .cloudformation$set_stack_policy_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$set_stack_policy <- cloudformation_set_stack_policy

#' Specifies the configuration data for a registered CloudFormation
#' extension, in the given account and Region
#'
#' @description
#' Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_set_type_configuration/](https://www.paws-r-sdk.com/docs/cloudformation_set_type_configuration/) for full documentation.
#'
#' @param TypeArn The Amazon Resource Name (ARN) for the extension, in this account and
#' Region.
#' 
#' For public extensions, this will be the ARN assigned when you [activate
#' the
#' type](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
#' in this account and Region. For private extensions, this will be the ARN
#' assigned when you [register the
#' type](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
#' in this account and Region.
#' 
#' Do not include the extension versions suffix at the end of the ARN. You
#' can set the configuration for an extension, but not for a specific
#' extension version.
#' @param Configuration &#91;required&#93; The configuration data for the extension, in this account and Region.
#' 
#' The configuration data must be formatted as JSON, and validate against
#' the schema returned in the `ConfigurationSchema` response element of
#' [`describe_type`][cloudformation_describe_type]. For more information,
#' see [Defining account-level configuration data for an
#' extension](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration)
#' in the *CloudFormation CLI User Guide*.
#' @param ConfigurationAlias An alias by which to refer to this extension configuration data.
#' 
#' Conditional: Specifying a configuration alias is required when setting a
#' configuration for a resource type extension.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify `ConfigurationArn`, or `Type` and
#' `TypeName`.
#' @param Type The type of extension.
#' 
#' Conditional: You must specify `ConfigurationArn`, or `Type` and
#' `TypeName`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_set_type_configuration
cloudformation_set_type_configuration <- function(TypeArn = NULL, Configuration, ConfigurationAlias = NULL, TypeName = NULL, Type = NULL) {
  op <- new_operation(
    name = "SetTypeConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$set_type_configuration_input(TypeArn = TypeArn, Configuration = Configuration, ConfigurationAlias = ConfigurationAlias, TypeName = TypeName, Type = Type)
  output <- .cloudformation$set_type_configuration_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$set_type_configuration <- cloudformation_set_type_configuration

#' Specify the default version of an extension
#'
#' @description
#' Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_set_type_default_version/](https://www.paws-r-sdk.com/docs/cloudformation_set_type_default_version/) for full documentation.
#'
#' @param Arn The Amazon Resource Name (ARN) of the extension for which you want
#' version summary information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Type The kind of extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the extension.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the extension. The version ID is the
#' value at the end of the Amazon Resource Name (ARN) assigned to the
#' extension version when it is registered.
#'
#' @keywords internal
#'
#' @rdname cloudformation_set_type_default_version
cloudformation_set_type_default_version <- function(Arn = NULL, Type = NULL, TypeName = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "SetTypeDefaultVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$set_type_default_version_input(Arn = Arn, Type = Type, TypeName = TypeName, VersionId = VersionId)
  output <- .cloudformation$set_type_default_version_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$set_type_default_version <- cloudformation_set_type_default_version

#' Sends a signal to the specified resource with a success or failure
#' status
#'
#' @description
#' Sends a signal to the specified resource with a success or failure status. You can use the [`signal_resource`][cloudformation_signal_resource] operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The [`signal_resource`][cloudformation_signal_resource] operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_signal_resource/](https://www.paws-r-sdk.com/docs/cloudformation_signal_resource/) for full documentation.
#'
#' @param StackName &#91;required&#93; The stack name or unique stack ID that includes the resource that you
#' want to signal.
#' @param LogicalResourceId &#91;required&#93; The logical ID of the resource that you want to signal. The logical ID
#' is the name of the resource that given in the template.
#' @param UniqueId &#91;required&#93; A unique ID of the signal. When you signal Amazon EC2 instances or Auto
#' Scaling groups, specify the instance ID that you are signaling as the
#' unique ID. If you send multiple signals to a single resource (such as
#' signaling a wait condition), each signal requires a different unique ID.
#' @param Status &#91;required&#93; The status of the signal, which is either success or failure. A failure
#' signal causes CloudFormation to immediately fail the stack creation or
#' update.
#'
#' @keywords internal
#'
#' @rdname cloudformation_signal_resource
cloudformation_signal_resource <- function(StackName, LogicalResourceId, UniqueId, Status) {
  op <- new_operation(
    name = "SignalResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$signal_resource_input(StackName = StackName, LogicalResourceId = LogicalResourceId, UniqueId = UniqueId, Status = Status)
  output <- .cloudformation$signal_resource_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$signal_resource <- cloudformation_signal_resource

#' Stops an in-progress operation on a stack set and its associated stack
#' instances
#'
#' @description
#' Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_stop_stack_set_operation/](https://www.paws-r-sdk.com/docs/cloudformation_stop_stack_set_operation/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to stop the
#' operation for.
#' @param OperationId &#91;required&#93; The ID of the stack operation.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_stop_stack_set_operation
cloudformation_stop_stack_set_operation <- function(StackSetName, OperationId, CallAs = NULL) {
  op <- new_operation(
    name = "StopStackSetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$stop_stack_set_operation_input(StackSetName = StackSetName, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$stop_stack_set_operation_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$stop_stack_set_operation <- cloudformation_stop_stack_set_operation

#' Tests a registered extension to make sure it meets all necessary
#' requirements for being published in the CloudFormation registry
#'
#' @description
#' Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_test_type/](https://www.paws-r-sdk.com/docs/cloudformation_test_type/) for full documentation.
#'
#' @param Arn The Amazon Resource Name (ARN) of the extension.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param Type The type of the extension to test.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param TypeName The name of the extension to test.
#' 
#' Conditional: You must specify `Arn`, or `TypeName` and `Type`.
#' @param VersionId The version of the extension to test.
#' 
#' You can specify the version id with either `Arn`, or with `TypeName` and
#' `Type`.
#' 
#' If you don't specify a version, CloudFormation uses the default version
#' of the extension in this account and Region for testing.
#' @param LogDeliveryBucket The S3 bucket to which CloudFormation delivers the contract test
#' execution logs.
#' 
#' CloudFormation delivers the logs by the time contract testing has
#' completed and the extension has been assigned a test type status of
#' `PASSED` or `FAILED`.
#' 
#' The user calling [`test_type`][cloudformation_test_type] must be able to
#' access items in the specified S3 bucket. Specifically, the user needs
#' the following permissions:
#' 
#' -   `GetObject`
#' 
#' -   `PutObject`
#' 
#' For more information, see [Actions, Resources, and Condition Keys for
#' Amazon
#' S3](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html)
#' in the *Amazon Web Services Identity and Access Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_test_type
cloudformation_test_type <- function(Arn = NULL, Type = NULL, TypeName = NULL, VersionId = NULL, LogDeliveryBucket = NULL) {
  op <- new_operation(
    name = "TestType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$test_type_input(Arn = Arn, Type = Type, TypeName = TypeName, VersionId = VersionId, LogDeliveryBucket = LogDeliveryBucket)
  output <- .cloudformation$test_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$test_type <- cloudformation_test_type

#' Updates a stack as specified in the template
#'
#' @description
#' Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the [`describe_stacks`][cloudformation_describe_stacks] action.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_update_stack/](https://www.paws-r-sdk.com/docs/cloudformation_update_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name or unique stack ID of the stack to update.
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. (For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.)
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template that's located in an Amazon S3 bucket or a Systems Manager
#' document. For more information, go to [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param UsePreviousTemplate Reuse the existing template that is associated with the stack that you
#' are updating.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param StackPolicyDuringUpdateBody Structure containing the temporary overriding stack policy body. You can
#' specify either the `StackPolicyDuringUpdateBody` or the
#' `StackPolicyDuringUpdateURL` parameter, but not both.
#' 
#' If you want to update protected resources, specify a temporary
#' overriding stack policy during this update. If you don't specify a stack
#' policy, the current policy that is associated with the stack will be
#' used.
#' @param StackPolicyDuringUpdateURL Location of a file containing the temporary overriding stack policy. The
#' URL must point to a policy (max size: 16KB) located in an S3 bucket in
#' the same Region as the stack. You can specify either the
#' `StackPolicyDuringUpdateBody` or the `StackPolicyDuringUpdateURL`
#' parameter, but not both.
#' 
#' If you want to update protected resources, specify a temporary
#' overriding stack policy during this update. If you don't specify a stack
#' policy, the current policy that is associated with the stack will be
#' used.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' stack. For more information, see the
#' [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
#' data type.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for CloudFormation to update the
#' stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your Amazon Web Services account; for example, by
#'     creating new Identity and Access Management (IAM) users. For those
#'     stacks, you must explicitly acknowledge this by specifying one of
#'     these capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities,
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we suggest that you
#'     review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually updating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     update a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by CloudFormation.
#' 
#'     If you want to update a stack from a stack template that contains
#'     macros *and* nested stacks, you must update the stack directly from
#'     the template using this capability.
#' 
#'     You should only update stacks directly from a stack template that
#'     contains macros if you know what processing the macro performs.
#' 
#'     Each macro relies on an underlying Lambda service function for
#'     processing stack templates. Be aware that the Lambda function owner
#'     can update the function operation without CloudFormation being
#'     notified.
#' 
#'     For more information, see [Using CloudFormation Macros to Perform
#'     Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with for
#' this update stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`,
#' or `Custom::MyCustomInstance`.
#' 
#' If the list of resource types doesn't include a resource that you're
#' updating, the stack update fails. By default, CloudFormation grants
#' permissions to all resource types. Identity and Access Management (IAM)
#' uses this parameter for CloudFormation-specific condition keys in IAM
#' policies. For more information, see [Controlling Access with Identity
#' and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
#' @param RoleARN The Amazon Resource Name (ARN) of an Identity and Access Management
#' (IAM) role that CloudFormation assumes to update the stack.
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' CloudFormation always uses this role for all future operations on the
#' stack. Provided that users have permission to operate on the stack,
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, CloudFormation uses the role that was
#' previously associated with the stack. If no role is available,
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param RollbackConfiguration The rollback triggers for CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param StackPolicyBody Structure containing a new stack policy body. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' 
#' You might update the stack policy, for example, in order to protect a
#' new resource that you created during a stack update. If you don't
#' specify a stack policy, the current policy that is associated with the
#' stack is unchanged.
#' @param StackPolicyURL Location of a file containing the updated stack policy. The URL must
#' point to a policy (max size: 16KB) located in an S3 bucket in the same
#' Region as the stack. You can specify either the `StackPolicyBody` or the
#' `StackPolicyURL` parameter, but not both.
#' 
#' You might update the stack policy, for example, in order to protect a
#' new resource that you created during a stack update. If you don't
#' specify a stack policy, the current policy that is associated with the
#' stack is unchanged.
#' @param NotificationARNs Amazon Simple Notification Service topic Amazon Resource Names (ARNs)
#' that CloudFormation associates with the stack. Specify an empty list to
#' remove all notification topics.
#' @param Tags Key-value pairs to associate with this stack. CloudFormation also
#' propagates these tags to supported resources in the stack. You can
#' specify a maximum number of 50 tags.
#' 
#' If you don't specify this parameter, CloudFormation doesn't modify the
#' stack's tags. If you specify an empty value, CloudFormation removes all
#' associated tags.
#' @param DisableRollback Preserve the state of previously provisioned resources when an operation
#' fails.
#' 
#' Default: `False`
#' @param ClientRequestToken A unique identifier for this
#' [`update_stack`][cloudformation_update_stack] request. Specify this
#' token if you plan to retry requests so that CloudFormation knows that
#' you're not attempting to update a stack with the same name. You might
#' retry [`update_stack`][cloudformation_update_stack] requests to ensure
#' that CloudFormation successfully received them.
#' 
#' All events triggered by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a [`create_stack`][cloudformation_create_stack]
#' operation with the token `token1`, then all the `StackEvents` generated
#' by that operation will have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack
cloudformation_update_stack <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, StackPolicyDuringUpdateBody = NULL, StackPolicyDuringUpdateURL = NULL, Parameters = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, RollbackConfiguration = NULL, StackPolicyBody = NULL, StackPolicyURL = NULL, NotificationARNs = NULL, Tags = NULL, DisableRollback = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, StackPolicyDuringUpdateBody = StackPolicyDuringUpdateBody, StackPolicyDuringUpdateURL = StackPolicyDuringUpdateURL, Parameters = Parameters, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, RollbackConfiguration = RollbackConfiguration, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL, NotificationARNs = NotificationARNs, Tags = Tags, DisableRollback = DisableRollback, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$update_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack <- cloudformation_update_stack

#' Updates the parameter values for stack instances for the specified
#' accounts, within the specified Amazon Web Services Regions
#'
#' @description
#' Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_update_stack_instances/](https://www.paws-r-sdk.com/docs/cloudformation_update_stack_instances/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set associated with the stack
#' instances.
#' @param Accounts \[Self-managed permissions\] The names of one or more Amazon Web
#' Services accounts for which you want to update parameter values for
#' stack instances. The overridden parameter values will be applied to all
#' stack instances in the specified accounts and Amazon Web Services
#' Regions.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[Service-managed permissions\] The Organizations accounts for which you
#' want to update parameter values for stack instances. If your update
#' targets OUs, the overridden parameter values only apply to the accounts
#' that are currently in the target OUs and their child OUs. Accounts added
#' to the target OUs and their child OUs in the future won't use the
#' overridden values.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The names of one or more Amazon Web Services Regions in which you want
#' to update parameter values for stack instances. The overridden parameter
#' values will be applied to all stack instances in the specified accounts
#' and Amazon Web Services Regions.
#' @param ParameterOverrides A list of input parameters whose values you want to update for the
#' specified stack instances.
#' 
#' Any overridden parameter values will be applied to all stack instances
#' in the specified accounts and Amazon Web Services Regions. When
#' specifying parameters and their values, be aware of how CloudFormation
#' sets parameter values during stack instance update operations:
#' 
#' -   To override the current value for a parameter, include the parameter
#'     and specify its value.
#' 
#' -   To leave an overridden parameter set to its present value, include
#'     the parameter and specify `UsePreviousValue` as `true`. (You can't
#'     specify both a value and set `UsePreviousValue` to `true`.)
#' 
#' -   To set an overridden parameter back to the value specified in the
#'     stack set, specify a parameter list but don't include the parameter
#'     in the list.
#' 
#' -   To leave all parameters set to their present values, don't specify
#'     this property at all.
#' 
#' During stack set updates, any parameter values overridden for a stack
#' instance aren't updated, but retain their overridden value.
#' 
#' You can only override the parameter *values* that are specified in the
#' stack set; to add or delete a parameter itself, use
#' [`update_stack_set`][cloudformation_update_stack_set] to update the
#' stack set template. If you add a parameter to a template, before you can
#' override the parameter value specified in the stack set you must first
#' use [`update_stack_set`][cloudformation_update_stack_set] to update all
#' stack instances with the updated template and parameter value specified
#' in the stack set. Once a stack instance has been updated with the new
#' parameter, you can then override the parameter value using
#' [`update_stack_instances`][cloudformation_update_stack_instances].
#' @param OperationPreferences Preferences for how CloudFormation performs this stack set operation.
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' CloudFormation performs the stack set operation only once, even if you
#' retry the request multiple times. You might retry stack set operation
#' requests to ensure that CloudFormation successfully received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack_instances
cloudformation_update_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, ParameterOverrides = NULL, OperationPreferences = NULL, OperationId = NULL, CallAs = NULL) {
  op <- new_operation(
    name = "UpdateStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, ParameterOverrides = ParameterOverrides, OperationPreferences = OperationPreferences, OperationId = OperationId, CallAs = CallAs)
  output <- .cloudformation$update_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack_instances <- cloudformation_update_stack_instances

#' Updates the stack set, and associated stack instances in the specified
#' accounts and Amazon Web Services Regions
#'
#' @description
#' Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_update_stack_set/](https://www.paws-r-sdk.com/docs/cloudformation_update_stack_set/) for full documentation.
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to update.
#' @param Description A brief description of updates that you are making.
#' @param TemplateBody The structure that contains the template body, with a minimum length of
#' 1 byte and a maximum length of 51,200 bytes. For more information, see
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param TemplateURL The location of the file that contains the template body. The URL must
#' point to a template (maximum size: 460,800 bytes) that is located in an
#' Amazon S3 bucket or a Systems Manager document. For more information,
#' see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param UsePreviousTemplate Use the existing template that's associated with the stack set that
#' you're updating.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param Parameters A list of input parameters for the stack set template.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for CloudFormation to update the
#' stack set and its associated stack instances.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your Amazon Web Services account; for example, by
#'     creating new Identity and Access Management (IAM) users. For those
#'     stacks sets, you must explicitly acknowledge this by specifying one
#'     of these capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities,
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some templates reference macros. If your stack set template
#'     references one or more macros, you must update the stack set
#'     directly from the processed template, without first reviewing the
#'     resulting changes in a change set. To update the stack set directly,
#'     you must acknowledge this capability. For more information, see
#'     [Using CloudFormation Macros to Perform Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' 
#'     Stack sets with service-managed permissions do not currently support
#'     the use of macros in templates. (This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by CloudFormation.) Even if you
#'     specify this capability for a stack set with service-managed
#'     permissions, if you reference a macro in your template the stack set
#'     operation will fail.
#' @param Tags The key-value pairs to associate with this stack set and the stacks
#' created from it. CloudFormation also propagates these tags to supported
#' resources that are created in the stacks. You can specify a maximum
#' number of 50 tags.
#' 
#' If you specify tags for this parameter, those tags replace any list of
#' tags that are currently associated with this stack set. This means:
#' 
#' -   If you don't specify this parameter, CloudFormation doesn't modify
#'     the stack's tags.
#' 
#' -   If you specify *any* tags using this parameter, you must specify
#'     *all* the tags that you want associated with this stack set, even
#'     tags you've specified before (for example, when creating the stack
#'     set or during a previous update of the stack set.). Any tags that
#'     you don't include in the updated list of tags are removed from the
#'     stack set, and therefore from the stacks and resources as well.
#' 
#' -   If you specify an empty value, CloudFormation removes all currently
#'     associated tags.
#' 
#' If you specify new tags as part of an
#' [`update_stack_set`][cloudformation_update_stack_set] action,
#' CloudFormation checks to see if you have the required IAM permission to
#' tag resources. If you omit tags that are currently associated with the
#' stack set from the list of tags you specify, CloudFormation assumes that
#' you want to remove those tags from the stack set, and checks to see if
#' you have permission to untag resources. If you don't have the necessary
#' permission(s), the entire
#' [`update_stack_set`][cloudformation_update_stack_set] action fails with
#' an `access denied` error, and the stack set is not updated.
#' @param OperationPreferences Preferences for how CloudFormation performs this stack set operation.
#' @param AdministrationRoleARN The Amazon Resource Name (ARN) of the IAM role to use to update this
#' stack set.
#' 
#' Specify an IAM role only if you are using customized administrator roles
#' to control which users or groups can manage specific stack sets within
#' the same administrator account. For more information, see [Granting
#' Permissions for Stack Set
#' Operations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
#' in the *CloudFormation User Guide*.
#' 
#' If you specified a customized administrator role when you created the
#' stack set, you must specify a customized administrator role, even if it
#' is the same customized administrator role used with this stack set
#' previously.
#' @param ExecutionRoleName The name of the IAM execution role to use to update the stack set. If
#' you do not specify an execution role, CloudFormation uses the
#' `AWSCloudFormationStackSetExecutionRole` role for the stack set
#' operation.
#' 
#' Specify an IAM role only if you are using customized execution roles to
#' control which stack resources users and groups can include in their
#' stack sets.
#' 
#' If you specify a customized execution role, CloudFormation uses that
#' role to update the stack. If you do not specify a customized execution
#' role, CloudFormation performs the update using the role previously
#' associated with the stack set, so long as you have permissions to
#' perform operations on the stack set.
#' @param DeploymentTargets \[Service-managed permissions\] The Organizations accounts in which to
#' update associated stack instances.
#' 
#' To update all the stack instances associated with this stack set, do not
#' specify `DeploymentTargets` or `Regions`.
#' 
#' If the stack set update includes changes to the template (that is, if
#' `TemplateBody` or `TemplateURL` is specified), or the `Parameters`,
#' CloudFormation marks all stack instances with a status of `OUTDATED`
#' prior to updating the stack instances in the specified accounts and
#' Amazon Web Services Regions. If the stack set update doesn't include
#' changes to the template or parameters, CloudFormation updates the stack
#' instances in the specified accounts and Regions, while leaving all other
#' stack instances with their existing stack instance status.
#' @param PermissionModel Describes how the IAM roles required for stack set operations are
#' created. You cannot modify `PermissionModel` if there are stack
#' instances associated with your stack set.
#' 
#' -   With `self-managed` permissions, you must create the administrator
#'     and execution roles required to deploy to target accounts. For more
#'     information, see [Grant Self-Managed Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
#' 
#' -   With `service-managed` permissions, StackSets automatically creates
#'     the IAM roles required to deploy to accounts managed by
#'     Organizations. For more information, see [Grant Service-Managed
#'     Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
#' @param AutoDeployment \[Service-managed permissions\] Describes whether StackSets
#' automatically deploys to Organizations accounts that are added to a
#' target organization or organizational unit (OU).
#' 
#' If you specify `AutoDeployment`, don't specify `DeploymentTargets` or
#' `Regions`.
#' @param OperationId The unique ID for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' CloudFormation performs the stack set operation only once, even if you
#' retry the request multiple times. You might retry stack set operation
#' requests to ensure that CloudFormation successfully received them.
#' 
#' If you don't specify an operation ID, CloudFormation generates one
#' automatically.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#' @param Accounts \[Self-managed permissions\] The accounts in which to update associated
#' stack instances. If you specify accounts, you must also specify the
#' Amazon Web Services Regions in which to update stack set instances.
#' 
#' To update *all* the stack instances associated with this stack set,
#' don't specify the `Accounts` or `Regions` properties.
#' 
#' If the stack set update includes changes to the template (that is, if
#' the `TemplateBody` or `TemplateURL` properties are specified), or the
#' `Parameters` property, CloudFormation marks all stack instances with a
#' status of `OUTDATED` prior to updating the stack instances in the
#' specified accounts and Amazon Web Services Regions. If the stack set
#' update does not include changes to the template or parameters,
#' CloudFormation updates the stack instances in the specified accounts and
#' Amazon Web Services Regions, while leaving all other stack instances
#' with their existing stack instance status.
#' @param Regions The Amazon Web Services Regions in which to update associated stack
#' instances. If you specify Regions, you must also specify accounts in
#' which to update stack set instances.
#' 
#' To update *all* the stack instances associated with this stack set, do
#' not specify the `Accounts` or `Regions` properties.
#' 
#' If the stack set update includes changes to the template (that is, if
#' the `TemplateBody` or `TemplateURL` properties are specified), or the
#' `Parameters` property, CloudFormation marks all stack instances with a
#' status of `OUTDATED` prior to updating the stack instances in the
#' specified accounts and Regions. If the stack set update does not include
#' changes to the template or parameters, CloudFormation updates the stack
#' instances in the specified accounts and Regions, while leaving all other
#' stack instances with their existing stack instance status.
#' @param CallAs \[Service-managed permissions\] Specifies whether you are acting as an
#' account administrator in the organization's management account or as a
#' delegated administrator in a member account.
#' 
#' By default, `SELF` is specified. Use `SELF` for stack sets with
#' self-managed permissions.
#' 
#' -   If you are signed in to the management account, specify `SELF`.
#' 
#' -   If you are signed in to a delegated administrator account, specify
#'     `DELEGATED_ADMIN`.
#' 
#'     Your Amazon Web Services account must be registered as a delegated
#'     administrator in the management account. For more information, see
#'     [Register a delegated
#'     administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
#'     in the *CloudFormation User Guide*.
#' @param ManagedExecution Describes whether StackSets performs non-conflicting operations
#' concurrently and queues conflicting operations.
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack_set
cloudformation_update_stack_set <- function(StackSetName, Description = NULL, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, Parameters = NULL, Capabilities = NULL, Tags = NULL, OperationPreferences = NULL, AdministrationRoleARN = NULL, ExecutionRoleName = NULL, DeploymentTargets = NULL, PermissionModel = NULL, AutoDeployment = NULL, OperationId = NULL, Accounts = NULL, Regions = NULL, CallAs = NULL, ManagedExecution = NULL) {
  op <- new_operation(
    name = "UpdateStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_set_input(StackSetName = StackSetName, Description = Description, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, Parameters = Parameters, Capabilities = Capabilities, Tags = Tags, OperationPreferences = OperationPreferences, AdministrationRoleARN = AdministrationRoleARN, ExecutionRoleName = ExecutionRoleName, DeploymentTargets = DeploymentTargets, PermissionModel = PermissionModel, AutoDeployment = AutoDeployment, OperationId = OperationId, Accounts = Accounts, Regions = Regions, CallAs = CallAs, ManagedExecution = ManagedExecution)
  output <- .cloudformation$update_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack_set <- cloudformation_update_stack_set

#' Updates termination protection for the specified stack
#'
#' @description
#' Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protecting a Stack From Being Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_update_termination_protection/](https://www.paws-r-sdk.com/docs/cloudformation_update_termination_protection/) for full documentation.
#'
#' @param EnableTerminationProtection &#91;required&#93; Whether to enable termination protection on the specified stack.
#' @param StackName &#91;required&#93; The name or unique ID of the stack for which you want to set termination
#' protection.
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_termination_protection
cloudformation_update_termination_protection <- function(EnableTerminationProtection, StackName) {
  op <- new_operation(
    name = "UpdateTerminationProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_termination_protection_input(EnableTerminationProtection = EnableTerminationProtection, StackName = StackName)
  output <- .cloudformation$update_termination_protection_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_termination_protection <- cloudformation_update_termination_protection

#' Validates a specified template
#'
#' @description
#' Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudformation_validate_template/](https://www.paws-r-sdk.com/docs/cloudformation_validate_template/) for full documentation.
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that is located in an Amazon S3
#' bucket or a Systems Manager document. For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#'
#' @keywords internal
#'
#' @rdname cloudformation_validate_template
cloudformation_validate_template <- function(TemplateBody = NULL, TemplateURL = NULL) {
  op <- new_operation(
    name = "ValidateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$validate_template_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL)
  output <- .cloudformation$validate_template_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$validate_template <- cloudformation_validate_template
