# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchlogs_service.R
NULL

#' Associates the specified KMS key with the specified log group
#'
#' @description
#' Associates the specified KMS key with the specified log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_associate_kms_key/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_associate_kms_key/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param kmsKeyId &#91;required&#93; The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
#' data. This must be a symmetric KMS key. For more information, see
#' [Amazon Resource
#' Names](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kms)
#' and [Using Symmetric and Asymmetric
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_associate_kms_key
cloudwatchlogs_associate_kms_key <- function(logGroupName, kmsKeyId) {
  op <- new_operation(
    name = "AssociateKmsKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$associate_kms_key_input(logGroupName = logGroupName, kmsKeyId = kmsKeyId)
  output <- .cloudwatchlogs$associate_kms_key_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$associate_kms_key <- cloudwatchlogs_associate_kms_key

#' Cancels the specified export task
#'
#' @description
#' Cancels the specified export task.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_cancel_export_task/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_cancel_export_task/) for full documentation.
#'
#' @param taskId &#91;required&#93; The ID of the export task.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_cancel_export_task
cloudwatchlogs_cancel_export_task <- function(taskId) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$cancel_export_task_input(taskId = taskId)
  output <- .cloudwatchlogs$cancel_export_task_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$cancel_export_task <- cloudwatchlogs_cancel_export_task

#' Creates an export task so that you can efficiently export data from a
#' log group to an Amazon S3 bucket
#'
#' @description
#' Creates an export task so that you can efficiently export data from a log group to an Amazon S3 bucket. When you perform a [`create_export_task`][cloudwatchlogs_create_export_task] operation, you must use credentials that have permission to write to the S3 bucket that you specify as the destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_export_task/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_export_task/) for full documentation.
#'
#' @param taskName The name of the export task.
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamNamePrefix Export only log streams that match the provided prefix. If you don't
#' specify a value, no prefix filter is applied.
#' @param from &#91;required&#93; The start time of the range for the request, expressed as the number of
#' milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp
#' earlier than this time are not exported.
#' @param to &#91;required&#93; The end time of the range for the request, expressed as the number of
#' milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp
#' later than this time are not exported.
#' 
#' You must specify a time that is not earlier than when this log group was
#' created.
#' @param destination &#91;required&#93; The name of S3 bucket for the exported log data. The bucket must be in
#' the same Amazon Web Services Region.
#' @param destinationPrefix The prefix used as the start of the key for every object exported. If
#' you don't specify a value, the default is `exportedlogs`.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_export_task
cloudwatchlogs_create_export_task <- function(taskName = NULL, logGroupName, logStreamNamePrefix = NULL, from, to, destination, destinationPrefix = NULL) {
  op <- new_operation(
    name = "CreateExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_export_task_input(taskName = taskName, logGroupName = logGroupName, logStreamNamePrefix = logStreamNamePrefix, from = from, to = to, destination = destination, destinationPrefix = destinationPrefix)
  output <- .cloudwatchlogs$create_export_task_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_export_task <- cloudwatchlogs_create_export_task

#' Creates a log group with the specified name
#'
#' @description
#' Creates a log group with the specified name. You can create up to 20,000 log groups per account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_log_group/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_log_group/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param kmsKeyId The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
#' data. For more information, see [Amazon Resource
#' Names](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kms).
#' @param tags The key-value pairs to use for the tags.
#' 
#' You can grant users access to certain log groups while preventing them
#' from accessing other log groups. To do so, tag your groups and use IAM
#' policies that refer to those tags. To assign tags when you create a log
#' group, you must have either the `logs:TagResource` or `logs:TagLogGroup`
#' permission. For more information about tagging, see [Tagging Amazon Web
#' Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' For more information about using tags to control access, see
#' [Controlling access to Amazon Web Services resources using
#' tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_log_group
cloudwatchlogs_create_log_group <- function(logGroupName, kmsKeyId = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_log_group_input(logGroupName = logGroupName, kmsKeyId = kmsKeyId, tags = tags)
  output <- .cloudwatchlogs$create_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_log_group <- cloudwatchlogs_create_log_group

#' Creates a log stream for the specified log group
#'
#' @description
#' Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a single source, such as an application instance or a resource that is being monitored.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_log_stream/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_log_stream/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_log_stream
cloudwatchlogs_create_log_stream <- function(logGroupName, logStreamName) {
  op <- new_operation(
    name = "CreateLogStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_log_stream_input(logGroupName = logGroupName, logStreamName = logStreamName)
  output <- .cloudwatchlogs$create_log_stream_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_log_stream <- cloudwatchlogs_create_log_stream

#' Deletes a CloudWatch Logs account policy
#'
#' @description
#' Deletes a CloudWatch Logs account policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_account_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_account_policy/) for full documentation.
#'
#' @param policyName &#91;required&#93; The name of the policy to delete.
#' @param policyType &#91;required&#93; The type of policy to delete. Currently, the only valid value is
#' `DATA_PROTECTION_POLICY`.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_account_policy
cloudwatchlogs_delete_account_policy <- function(policyName, policyType) {
  op <- new_operation(
    name = "DeleteAccountPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_account_policy_input(policyName = policyName, policyType = policyType)
  output <- .cloudwatchlogs$delete_account_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_account_policy <- cloudwatchlogs_delete_account_policy

#' Deletes the data protection policy from the specified log group
#'
#' @description
#' Deletes the data protection policy from the specified log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_data_protection_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_data_protection_policy/) for full documentation.
#'
#' @param logGroupIdentifier &#91;required&#93; The name or ARN of the log group that you want to delete the data
#' protection policy for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_data_protection_policy
cloudwatchlogs_delete_data_protection_policy <- function(logGroupIdentifier) {
  op <- new_operation(
    name = "DeleteDataProtectionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_data_protection_policy_input(logGroupIdentifier = logGroupIdentifier)
  output <- .cloudwatchlogs$delete_data_protection_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_data_protection_policy <- cloudwatchlogs_delete_data_protection_policy

#' Deletes the specified destination, and eventually disables all the
#' subscription filters that publish to it
#'
#' @description
#' Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This operation does not delete the physical resource encapsulated by the destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_destination/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_destination/) for full documentation.
#'
#' @param destinationName &#91;required&#93; The name of the destination.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_destination
cloudwatchlogs_delete_destination <- function(destinationName) {
  op <- new_operation(
    name = "DeleteDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_destination_input(destinationName = destinationName)
  output <- .cloudwatchlogs$delete_destination_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_destination <- cloudwatchlogs_delete_destination

#' Deletes the specified log group and permanently deletes all the archived
#' log events associated with the log group
#'
#' @description
#' Deletes the specified log group and permanently deletes all the archived log events associated with the log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_log_group/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_log_group/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_log_group
cloudwatchlogs_delete_log_group <- function(logGroupName) {
  op <- new_operation(
    name = "DeleteLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_log_group_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$delete_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_log_group <- cloudwatchlogs_delete_log_group

#' Deletes the specified log stream and permanently deletes all the
#' archived log events associated with the log stream
#'
#' @description
#' Deletes the specified log stream and permanently deletes all the archived log events associated with the log stream.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_log_stream/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_log_stream/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_log_stream
cloudwatchlogs_delete_log_stream <- function(logGroupName, logStreamName) {
  op <- new_operation(
    name = "DeleteLogStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_log_stream_input(logGroupName = logGroupName, logStreamName = logStreamName)
  output <- .cloudwatchlogs$delete_log_stream_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_log_stream <- cloudwatchlogs_delete_log_stream

#' Deletes the specified metric filter
#'
#' @description
#' Deletes the specified metric filter.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_metric_filter/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_metric_filter/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; The name of the metric filter.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_metric_filter
cloudwatchlogs_delete_metric_filter <- function(logGroupName, filterName) {
  op <- new_operation(
    name = "DeleteMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_metric_filter_input(logGroupName = logGroupName, filterName = filterName)
  output <- .cloudwatchlogs$delete_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_metric_filter <- cloudwatchlogs_delete_metric_filter

#' Deletes a saved CloudWatch Logs Insights query definition
#'
#' @description
#' Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved CloudWatch Logs Insights query.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_query_definition/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_query_definition/) for full documentation.
#'
#' @param queryDefinitionId &#91;required&#93; The ID of the query definition that you want to delete. You can use
#' [`describe_query_definitions`][cloudwatchlogs_describe_query_definitions]
#' to retrieve the IDs of your saved query definitions.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_query_definition
cloudwatchlogs_delete_query_definition <- function(queryDefinitionId) {
  op <- new_operation(
    name = "DeleteQueryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_query_definition_input(queryDefinitionId = queryDefinitionId)
  output <- .cloudwatchlogs$delete_query_definition_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_query_definition <- cloudwatchlogs_delete_query_definition

#' Deletes a resource policy from this account
#'
#' @description
#' Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log events to this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_resource_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_resource_policy/) for full documentation.
#'
#' @param policyName The name of the policy to be revoked. This parameter is required.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_resource_policy
cloudwatchlogs_delete_resource_policy <- function(policyName = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_resource_policy_input(policyName = policyName)
  output <- .cloudwatchlogs$delete_resource_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_resource_policy <- cloudwatchlogs_delete_resource_policy

#' Deletes the specified retention policy
#'
#' @description
#' Deletes the specified retention policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_retention_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_retention_policy/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_retention_policy
cloudwatchlogs_delete_retention_policy <- function(logGroupName) {
  op <- new_operation(
    name = "DeleteRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_retention_policy_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$delete_retention_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_retention_policy <- cloudwatchlogs_delete_retention_policy

#' Deletes the specified subscription filter
#'
#' @description
#' Deletes the specified subscription filter.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_subscription_filter/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_delete_subscription_filter/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; The name of the subscription filter.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_subscription_filter
cloudwatchlogs_delete_subscription_filter <- function(logGroupName, filterName) {
  op <- new_operation(
    name = "DeleteSubscriptionFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_subscription_filter_input(logGroupName = logGroupName, filterName = filterName)
  output <- .cloudwatchlogs$delete_subscription_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_subscription_filter <- cloudwatchlogs_delete_subscription_filter

#' Returns a list of all CloudWatch Logs account policies in the account
#'
#' @description
#' Returns a list of all CloudWatch Logs account policies in the account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_account_policies/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_account_policies/) for full documentation.
#'
#' @param policyType &#91;required&#93; Use this parameter to limit the returned policies to only the policies
#' that match the policy type that you specify. Currently, the only valid
#' value is `DATA_PROTECTION_POLICY`.
#' @param policyName Use this parameter to limit the returned policies to only the policy
#' with the name that you specify.
#' @param accountIdentifiers If you are using an account that is set up as a monitoring account for
#' CloudWatch unified cross-account observability, you can use this to
#' specify the account ID of a source account. If you do, the operation
#' returns the account policy for the specified account. Currently, you can
#' specify only one account ID in this parameter.
#' 
#' If you omit this parameter, only the policy in the current account is
#' returned.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_account_policies
cloudwatchlogs_describe_account_policies <- function(policyType, policyName = NULL, accountIdentifiers = NULL) {
  op <- new_operation(
    name = "DescribeAccountPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_account_policies_input(policyType = policyType, policyName = policyName, accountIdentifiers = accountIdentifiers)
  output <- .cloudwatchlogs$describe_account_policies_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_account_policies <- cloudwatchlogs_describe_account_policies

#' Lists all your destinations
#'
#' @description
#' Lists all your destinations. The results are ASCII-sorted by destination name.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_destinations/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_destinations/) for full documentation.
#'
#' @param DestinationNamePrefix The prefix to match. If you don't specify a value, no prefix filter is
#' applied.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default maximum value of 50 items is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_destinations
cloudwatchlogs_describe_destinations <- function(DestinationNamePrefix = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeDestinations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_destinations_input(DestinationNamePrefix = DestinationNamePrefix, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_destinations_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_destinations <- cloudwatchlogs_describe_destinations

#' Lists the specified export tasks
#'
#' @description
#' Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or task status.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_export_tasks/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_export_tasks/) for full documentation.
#'
#' @param taskId The ID of the export task. Specifying a task ID filters the results to
#' one or zero export tasks.
#' @param statusCode The status code of the export task. Specifying a status code filters the
#' results to zero or more export tasks.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default is up to 50 items.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_export_tasks
cloudwatchlogs_describe_export_tasks <- function(taskId = NULL, statusCode = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_export_tasks_input(taskId = taskId, statusCode = statusCode, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_export_tasks_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_export_tasks <- cloudwatchlogs_describe_export_tasks

#' Lists the specified log groups
#'
#' @description
#' Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are ASCII-sorted by log group name.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_log_groups/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_log_groups/) for full documentation.
#'
#' @param accountIdentifiers When `includeLinkedAccounts` is set to `True`, use this parameter to
#' specify the list of accounts to search. You can specify as many as 20
#' account IDs in the array.
#' @param logGroupNamePrefix The prefix to match.
#' 
#' `logGroupNamePrefix` and `logGroupNamePattern` are mutually exclusive.
#' Only one of these parameters can be passed.
#' @param logGroupNamePattern If you specify a string for this parameter, the operation returns only
#' log groups that have names that match the string based on a
#' case-sensitive substring search. For example, if you specify `Foo`, log
#' groups named `FooBar`, `aws/Foo`, and `GroupFoo` would match, but `foo`,
#' `F/o/o` and `Froo` would not match.
#' 
#' If you specify `logGroupNamePattern` in your request, then only `arn`,
#' `creationTime`, and `logGroupName` are included in the response.
#' 
#' `logGroupNamePattern` and `logGroupNamePrefix` are mutually exclusive.
#' Only one of these parameters can be passed.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default is up to 50 items.
#' @param includeLinkedAccounts If you are using a monitoring account, set this to `True` to have the
#' operation return log groups in the accounts listed in
#' `accountIdentifiers`.
#' 
#' If this parameter is set to `true` and `accountIdentifiers` contains a
#' null value, the operation returns all log groups in the monitoring
#' account and all log groups in all source accounts that are linked to the
#' monitoring account.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_log_groups
cloudwatchlogs_describe_log_groups <- function(accountIdentifiers = NULL, logGroupNamePrefix = NULL, logGroupNamePattern = NULL, nextToken = NULL, limit = NULL, includeLinkedAccounts = NULL) {
  op <- new_operation(
    name = "DescribeLogGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_log_groups_input(accountIdentifiers = accountIdentifiers, logGroupNamePrefix = logGroupNamePrefix, logGroupNamePattern = logGroupNamePattern, nextToken = nextToken, limit = limit, includeLinkedAccounts = includeLinkedAccounts)
  output <- .cloudwatchlogs$describe_log_groups_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_log_groups <- cloudwatchlogs_describe_log_groups

#' Lists the log streams for the specified log group
#'
#' @description
#' Lists the log streams for the specified log group. You can list all the log streams or filter the results by prefix. You can also control how the results are ordered.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_log_streams/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_log_streams/) for full documentation.
#'
#' @param logGroupName The name of the log group.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logGroupIdentifier Specify either the name or ARN of the log group to view. If the log
#' group is in a source account and you are using a monitoring account, you
#' must use the log group ARN.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logStreamNamePrefix The prefix to match.
#' 
#' If `orderBy` is `LastEventTime`, you cannot specify this parameter.
#' @param orderBy If the value is `LogStreamName`, the results are ordered by log stream
#' name. If the value is `LastEventTime`, the results are ordered by the
#' event time. The default value is `LogStreamName`.
#' 
#' If you order the results by event time, you cannot specify the
#' `logStreamNamePrefix` parameter.
#' 
#' `lastEventTimestamp` represents the time of the most recent log event in
#' the log stream in CloudWatch Logs. This number is expressed as the
#' number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
#' `lastEventTimestamp` updates on an eventual consistency basis. It
#' typically updates in less than an hour from ingestion, but in rare
#' situations might take longer.
#' @param descending If the value is true, results are returned in descending order. If the
#' value is to false, results are returned in ascending order. The default
#' value is false.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default is up to 50 items.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_log_streams
cloudwatchlogs_describe_log_streams <- function(logGroupName = NULL, logGroupIdentifier = NULL, logStreamNamePrefix = NULL, orderBy = NULL, descending = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeLogStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_log_streams_input(logGroupName = logGroupName, logGroupIdentifier = logGroupIdentifier, logStreamNamePrefix = logStreamNamePrefix, orderBy = orderBy, descending = descending, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_log_streams_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_log_streams <- cloudwatchlogs_describe_log_streams

#' Lists the specified metric filters
#'
#' @description
#' Lists the specified metric filters. You can list all of the metric filters or filter the results by log name, prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_metric_filters/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_metric_filters/) for full documentation.
#'
#' @param logGroupName The name of the log group.
#' @param filterNamePrefix The prefix to match. CloudWatch Logs uses the value that you set here
#' only if you also include the `logGroupName` parameter in your request.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default is up to 50 items.
#' @param metricName Filters results to include only those with the specified metric name. If
#' you include this parameter in your request, you must also include the
#' `metricNamespace` parameter.
#' @param metricNamespace Filters results to include only those in the specified namespace. If you
#' include this parameter in your request, you must also include the
#' `metricName` parameter.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_metric_filters
cloudwatchlogs_describe_metric_filters <- function(logGroupName = NULL, filterNamePrefix = NULL, nextToken = NULL, limit = NULL, metricName = NULL, metricNamespace = NULL) {
  op <- new_operation(
    name = "DescribeMetricFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_metric_filters_input(logGroupName = logGroupName, filterNamePrefix = filterNamePrefix, nextToken = nextToken, limit = limit, metricName = metricName, metricNamespace = metricNamespace)
  output <- .cloudwatchlogs$describe_metric_filters_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_metric_filters <- cloudwatchlogs_describe_metric_filters

#' Returns a list of CloudWatch Logs Insights queries that are scheduled,
#' running, or have been run recently in this account
#'
#' @description
#' Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have been run recently in this account. You can request all queries or limit it to queries of a specific log group or queries with a certain status.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_queries/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_queries/) for full documentation.
#'
#' @param logGroupName Limits the returned queries to only those for the specified log group.
#' @param status Limits the returned queries to only those that have the specified
#' status. Valid values are `Cancelled`, `Complete`, `Failed`, `Running`,
#' and `Scheduled`.
#' @param maxResults Limits the number of returned queries to the specified number.
#' @param nextToken 
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_queries
cloudwatchlogs_describe_queries <- function(logGroupName = NULL, status = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_queries_input(logGroupName = logGroupName, status = status, maxResults = maxResults, nextToken = nextToken)
  output <- .cloudwatchlogs$describe_queries_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_queries <- cloudwatchlogs_describe_queries

#' This operation returns a paginated list of your saved CloudWatch Logs
#' Insights query definitions
#'
#' @description
#' This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_query_definitions/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_query_definitions/) for full documentation.
#'
#' @param queryDefinitionNamePrefix Use this parameter to filter your results to only the query definitions
#' that have names that start with the prefix you specify.
#' @param maxResults Limits the number of returned query definitions to the specified number.
#' @param nextToken 
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_query_definitions
cloudwatchlogs_describe_query_definitions <- function(queryDefinitionNamePrefix = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeQueryDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_query_definitions_input(queryDefinitionNamePrefix = queryDefinitionNamePrefix, maxResults = maxResults, nextToken = nextToken)
  output <- .cloudwatchlogs$describe_query_definitions_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_query_definitions <- cloudwatchlogs_describe_query_definitions

#' Lists the resource policies in this account
#'
#' @description
#' Lists the resource policies in this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_resource_policies/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_resource_policies/) for full documentation.
#'
#' @param nextToken 
#' @param limit The maximum number of resource policies to be displayed with one call of
#' this API.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_resource_policies
cloudwatchlogs_describe_resource_policies <- function(nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeResourcePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_resource_policies_input(nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_resource_policies_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_resource_policies <- cloudwatchlogs_describe_resource_policies

#' Lists the subscription filters for the specified log group
#'
#' @description
#' Lists the subscription filters for the specified log group. You can list all the subscription filters or filter the results by prefix. The results are ASCII-sorted by filter name.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_subscription_filters/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_describe_subscription_filters/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterNamePrefix The prefix to match. If you don't specify a value, no prefix filter is
#' applied.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don't specify a value, the
#' default is up to 50 items.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_subscription_filters
cloudwatchlogs_describe_subscription_filters <- function(logGroupName, filterNamePrefix = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeSubscriptionFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_subscription_filters_input(logGroupName = logGroupName, filterNamePrefix = filterNamePrefix, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_subscription_filters_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_subscription_filters <- cloudwatchlogs_describe_subscription_filters

#' Disassociates the associated KMS key from the specified log group
#'
#' @description
#' Disassociates the associated KMS key from the specified log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_disassociate_kms_key/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_disassociate_kms_key/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_disassociate_kms_key
cloudwatchlogs_disassociate_kms_key <- function(logGroupName) {
  op <- new_operation(
    name = "DisassociateKmsKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$disassociate_kms_key_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$disassociate_kms_key_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$disassociate_kms_key <- cloudwatchlogs_disassociate_kms_key

#' Lists log events from the specified log group
#'
#' @description
#' Lists log events from the specified log group. You can list all the log events or filter the results using a filter pattern, a time range, and the name of the log stream.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_filter_log_events/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_filter_log_events/) for full documentation.
#'
#' @param logGroupName The name of the log group to search.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logGroupIdentifier Specify either the name or ARN of the log group to view log events from.
#' If the log group is in a source account and you are using a monitoring
#' account, you must use the log group ARN.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logStreamNames Filters the results to only logs from the log streams in this list.
#' 
#' If you specify a value for both `logStreamNamePrefix` and
#' `logStreamNames`, the action returns an `InvalidParameterException`
#' error.
#' @param logStreamNamePrefix Filters the results to include only events from log streams that have
#' names starting with this prefix.
#' 
#' If you specify a value for both `logStreamNamePrefix` and
#' `logStreamNames`, but the value for `logStreamNamePrefix` does not match
#' any log stream names specified in `logStreamNames`, the action returns
#' an `InvalidParameterException` error.
#' @param startTime The start of the time range, expressed as the number of milliseconds
#' after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp before this
#' time are not returned.
#' @param endTime The end of the time range, expressed as the number of milliseconds after
#' `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time
#' are not returned.
#' @param filterPattern The filter pattern to use. For more information, see [Filter and Pattern
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
#' 
#' If not provided, all the events are matched.
#' @param nextToken The token for the next set of events to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of events to return. The default is 10,000 events.
#' @param interleaved If the value is true, the operation attempts to provide responses that
#' contain events from multiple log streams within the log group,
#' interleaved in a single response. If the value is false, all the matched
#' log events in the first log stream are searched first, then those in the
#' next log stream, and so on.
#' 
#' **Important** As of June 17, 2019, this parameter is ignored and the
#' value is assumed to be true. The response from this operation always
#' interleaves events from multiple log streams within a log group.
#' @param unmask Specify `true` to display the log event fields with all sensitive data
#' unmasked and visible. The default is `false`.
#' 
#' To use this operation with this parameter, you must be signed into an
#' account with the `logs:Unmask` permission.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_filter_log_events
cloudwatchlogs_filter_log_events <- function(logGroupName = NULL, logGroupIdentifier = NULL, logStreamNames = NULL, logStreamNamePrefix = NULL, startTime = NULL, endTime = NULL, filterPattern = NULL, nextToken = NULL, limit = NULL, interleaved = NULL, unmask = NULL) {
  op <- new_operation(
    name = "FilterLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$filter_log_events_input(logGroupName = logGroupName, logGroupIdentifier = logGroupIdentifier, logStreamNames = logStreamNames, logStreamNamePrefix = logStreamNamePrefix, startTime = startTime, endTime = endTime, filterPattern = filterPattern, nextToken = nextToken, limit = limit, interleaved = interleaved, unmask = unmask)
  output <- .cloudwatchlogs$filter_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$filter_log_events <- cloudwatchlogs_filter_log_events

#' Returns information about a log group data protection policy
#'
#' @description
#' Returns information about a log group data protection policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_data_protection_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_data_protection_policy/) for full documentation.
#'
#' @param logGroupIdentifier &#91;required&#93; The name or ARN of the log group that contains the data protection
#' policy that you want to see.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_data_protection_policy
cloudwatchlogs_get_data_protection_policy <- function(logGroupIdentifier) {
  op <- new_operation(
    name = "GetDataProtectionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_data_protection_policy_input(logGroupIdentifier = logGroupIdentifier)
  output <- .cloudwatchlogs$get_data_protection_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_data_protection_policy <- cloudwatchlogs_get_data_protection_policy

#' Lists log events from the specified log stream
#'
#' @description
#' Lists log events from the specified log stream. You can list all of the log events or filter using a time range.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_events/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_events/) for full documentation.
#'
#' @param logGroupName The name of the log group.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logGroupIdentifier Specify either the name or ARN of the log group to view events from. If
#' the log group is in a source account and you are using a monitoring
#' account, you must use the log group ARN.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' @param startTime The start of the time range, expressed as the number of milliseconds
#' after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp equal to this
#' time or later than this time are included. Events with a timestamp
#' earlier than this time are not included.
#' @param endTime The end of the time range, expressed as the number of milliseconds after
#' `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp equal to or later
#' than this time are not included.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of log events returned. If you don't specify a limit,
#' the default is as many log events as can fit in a response size of 1 MB
#' (up to 10,000 log events).
#' @param startFromHead If the value is true, the earliest log events are returned first. If the
#' value is false, the latest log events are returned first. The default
#' value is false.
#' 
#' If you are using a previous `nextForwardToken` value as the `nextToken`
#' in this operation, you must specify `true` for `startFromHead`.
#' @param unmask Specify `true` to display the log event fields with all sensitive data
#' unmasked and visible. The default is `false`.
#' 
#' To use this operation with this parameter, you must be signed into an
#' account with the `logs:Unmask` permission.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_events
cloudwatchlogs_get_log_events <- function(logGroupName = NULL, logGroupIdentifier = NULL, logStreamName, startTime = NULL, endTime = NULL, nextToken = NULL, limit = NULL, startFromHead = NULL, unmask = NULL) {
  op <- new_operation(
    name = "GetLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_events_input(logGroupName = logGroupName, logGroupIdentifier = logGroupIdentifier, logStreamName = logStreamName, startTime = startTime, endTime = endTime, nextToken = nextToken, limit = limit, startFromHead = startFromHead, unmask = unmask)
  output <- .cloudwatchlogs$get_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_events <- cloudwatchlogs_get_log_events

#' Returns a list of the fields that are included in log events in the
#' specified log group
#'
#' @description
#' Returns a list of the fields that are included in log events in the specified log group. Includes the percentage of log events that contain each field. The search is limited to a time period that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_group_fields/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_group_fields/) for full documentation.
#'
#' @param logGroupName The name of the log group to search.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#' @param time The time to set as the center of the query. If you specify `time`, the
#' 15 minutes before this time are queries. If you omit `time`, the 8
#' minutes before and 8 minutes after this time are searched.
#' 
#' The `time` value is specified as epoch time, which is the number of
#' seconds since `January 1, 1970, 00:00:00 UTC`.
#' @param logGroupIdentifier Specify either the name or ARN of the log group to view. If the log
#' group is in a source account and you are using a monitoring account, you
#' must specify the ARN.
#' 
#' You must include either `logGroupIdentifier` or `logGroupName`, but not
#' both.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_group_fields
cloudwatchlogs_get_log_group_fields <- function(logGroupName = NULL, time = NULL, logGroupIdentifier = NULL) {
  op <- new_operation(
    name = "GetLogGroupFields",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_group_fields_input(logGroupName = logGroupName, time = time, logGroupIdentifier = logGroupIdentifier)
  output <- .cloudwatchlogs$get_log_group_fields_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_group_fields <- cloudwatchlogs_get_log_group_fields

#' Retrieves all of the fields and values of a single log event
#'
#' @description
#' Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original query that produced the `logRecordPointer` retrieved only a subset of fields. Fields are returned as field name/field value pairs.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_record/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_log_record/) for full documentation.
#'
#' @param logRecordPointer &#91;required&#93; The pointer corresponding to the log event record you want to retrieve.
#' You get this from the response of a
#' [`get_query_results`][cloudwatchlogs_get_query_results] operation. In
#' that response, the value of the `@@ptr` field for a log event is the
#' value to use as `logRecordPointer` to retrieve that complete log event
#' record.
#' @param unmask Specify `true` to display the log event fields with all sensitive data
#' unmasked and visible. The default is `false`.
#' 
#' To use this operation with this parameter, you must be signed into an
#' account with the `logs:Unmask` permission.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_record
cloudwatchlogs_get_log_record <- function(logRecordPointer, unmask = NULL) {
  op <- new_operation(
    name = "GetLogRecord",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_record_input(logRecordPointer = logRecordPointer, unmask = unmask)
  output <- .cloudwatchlogs$get_log_record_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_record <- cloudwatchlogs_get_log_record

#' Returns the results from the specified query
#'
#' @description
#' Returns the results from the specified query.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_query_results/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_get_query_results/) for full documentation.
#'
#' @param queryId &#91;required&#93; The ID number of the query.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_query_results
cloudwatchlogs_get_query_results <- function(queryId) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_query_results_input(queryId = queryId)
  output <- .cloudwatchlogs$get_query_results_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_query_results <- cloudwatchlogs_get_query_results

#' Displays the tags associated with a CloudWatch Logs resource
#'
#' @description
#' Displays the tags associated with a CloudWatch Logs resource. Currently, log groups and destinations support tagging.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that you want to view tags for.
#' 
#' The ARN format of a log group is
#' `arn:aws:logs:Region:account-id:log-group:log-group-name `
#' 
#' The ARN format of a destination is
#' `arn:aws:logs:Region:account-id:destination:destination-name `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_list_tags_for_resource
cloudwatchlogs_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .cloudwatchlogs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$list_tags_for_resource <- cloudwatchlogs_list_tags_for_resource

#' The ListTagsLogGroup operation is on the path to deprecation
#'
#' @description
#' The ListTagsLogGroup operation is on the path to deprecation. We recommend that you use [`list_tags_for_resource`][cloudwatchlogs_list_tags_for_resource] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_list_tags_log_group/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_list_tags_log_group/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_list_tags_log_group
cloudwatchlogs_list_tags_log_group <- function(logGroupName) {
  op <- new_operation(
    name = "ListTagsLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$list_tags_log_group_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$list_tags_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$list_tags_log_group <- cloudwatchlogs_list_tags_log_group

#' Creates an account-level data protection policy that applies to all log
#' groups in the account
#'
#' @description
#' Creates an account-level data protection policy that applies to all log groups in the account. A data protection policy can help safeguard sensitive data that's ingested by your log groups by auditing and masking the sensitive log data. Each account can have only one account-level policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_account_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_account_policy/) for full documentation.
#'
#' @param policyName &#91;required&#93; A name for the policy. This must be unique within the account.
#' @param policyDocument &#91;required&#93; Specify the data protection policy, in JSON.
#' 
#' This policy must include two JSON blocks:
#' 
#' -   The first block must include both a `DataIdentifer` array and an
#'     `Operation` property with an `Audit` action. The `DataIdentifer`
#'     array lists the types of sensitive data that you want to mask. For
#'     more information about the available options, see [Types of data
#'     that you can
#'     mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/).
#' 
#'     The `Operation` property with an `Audit` action is required to find
#'     the sensitive data terms. This `Audit` action must contain a
#'     `FindingsDestination` object. You can optionally use that
#'     `FindingsDestination` object to list one or more destinations to
#'     send audit findings to. If you specify destinations such as log
#'     groups, Kinesis Data Firehose streams, and S3 buckets, they must
#'     already exist.
#' 
#' -   The second block must include both a `DataIdentifer` array and an
#'     `Operation` property with an `Deidentify` action. The
#'     `DataIdentifer` array must exactly match the `DataIdentifer` array
#'     in the first block of the policy.
#' 
#'     The `Operation` property with the `Deidentify` action is what
#'     actually masks the data, and it must contain the ` "MaskConfig": {}`
#'     object. The ` "MaskConfig": {}` object must be empty.
#' 
#' For an example data protection policy, see the **Examples** section on
#' this page.
#' 
#' The contents of the two `DataIdentifer` arrays must match exactly.
#' 
#' In addition to the two JSON blocks, the `policyDocument` can also
#' include `Name`, `Description`, and `Version` fields. The `Name` is
#' different than the operation's `policyName` parameter, and is used as a
#' dimension when CloudWatch Logs reports audit findings metrics to
#' CloudWatch.
#' 
#' The JSON specified in `policyDocument` can be up to 30,720 characters.
#' @param policyType &#91;required&#93; Currently the only valid value for this parameter is
#' `DATA_PROTECTION_POLICY`.
#' @param scope Currently the only valid value for this parameter is `GLOBAL`, which
#' specifies that the data protection policy applies to all log groups in
#' the account. If you omit this parameter, the default of `GLOBAL` is
#' used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_account_policy
cloudwatchlogs_put_account_policy <- function(policyName, policyDocument, policyType, scope = NULL) {
  op <- new_operation(
    name = "PutAccountPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_account_policy_input(policyName = policyName, policyDocument = policyDocument, policyType = policyType, scope = scope)
  output <- .cloudwatchlogs$put_account_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_account_policy <- cloudwatchlogs_put_account_policy

#' Creates a data protection policy for the specified log group
#'
#' @description
#' Creates a data protection policy for the specified log group. A data protection policy can help safeguard sensitive data that's ingested by the log group by auditing and masking the sensitive log data.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_data_protection_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_data_protection_policy/) for full documentation.
#'
#' @param logGroupIdentifier &#91;required&#93; Specify either the log group name or log group ARN.
#' @param policyDocument &#91;required&#93; Specify the data protection policy, in JSON.
#' 
#' This policy must include two JSON blocks:
#' 
#' -   The first block must include both a `DataIdentifer` array and an
#'     `Operation` property with an `Audit` action. The `DataIdentifer`
#'     array lists the types of sensitive data that you want to mask. For
#'     more information about the available options, see [Types of data
#'     that you can
#'     mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/).
#' 
#'     The `Operation` property with an `Audit` action is required to find
#'     the sensitive data terms. This `Audit` action must contain a
#'     `FindingsDestination` object. You can optionally use that
#'     `FindingsDestination` object to list one or more destinations to
#'     send audit findings to. If you specify destinations such as log
#'     groups, Kinesis Data Firehose streams, and S3 buckets, they must
#'     already exist.
#' 
#' -   The second block must include both a `DataIdentifer` array and an
#'     `Operation` property with an `Deidentify` action. The
#'     `DataIdentifer` array must exactly match the `DataIdentifer` array
#'     in the first block of the policy.
#' 
#'     The `Operation` property with the `Deidentify` action is what
#'     actually masks the data, and it must contain the ` "MaskConfig": {}`
#'     object. The ` "MaskConfig": {}` object must be empty.
#' 
#' For an example data protection policy, see the **Examples** section on
#' this page.
#' 
#' The contents of the two `DataIdentifer` arrays must match exactly.
#' 
#' In addition to the two JSON blocks, the `policyDocument` can also
#' include `Name`, `Description`, and `Version` fields. The `Name` is used
#' as a dimension when CloudWatch Logs reports audit findings metrics to
#' CloudWatch.
#' 
#' The JSON specified in `policyDocument` can be up to 30,720 characters.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_data_protection_policy
cloudwatchlogs_put_data_protection_policy <- function(logGroupIdentifier, policyDocument) {
  op <- new_operation(
    name = "PutDataProtectionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_data_protection_policy_input(logGroupIdentifier = logGroupIdentifier, policyDocument = policyDocument)
  output <- .cloudwatchlogs$put_data_protection_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_data_protection_policy <- cloudwatchlogs_put_data_protection_policy

#' Creates or updates a destination
#'
#' @description
#' Creates or updates a destination. This operation is used only to create destinations for cross-account subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_destination/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_destination/) for full documentation.
#'
#' @param destinationName &#91;required&#93; A name for the destination.
#' @param targetArn &#91;required&#93; The ARN of an Amazon Kinesis stream to which to deliver matching log
#' events.
#' @param roleArn &#91;required&#93; The ARN of an IAM role that grants CloudWatch Logs permissions to call
#' the Amazon Kinesis `PutRecord` operation on the destination stream.
#' @param tags An optional list of key-value pairs to associate with the resource.
#' 
#' For more information about tagging, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_destination
cloudwatchlogs_put_destination <- function(destinationName, targetArn, roleArn, tags = NULL) {
  op <- new_operation(
    name = "PutDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_destination_input(destinationName = destinationName, targetArn = targetArn, roleArn = roleArn, tags = tags)
  output <- .cloudwatchlogs$put_destination_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_destination <- cloudwatchlogs_put_destination

#' Creates or updates an access policy associated with an existing
#' destination
#'
#' @description
#' Creates or updates an access policy associated with an existing destination. An access policy is an [IAM policy document](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html) that is used to authorize claims to register a subscription filter against a given destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_destination_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_destination_policy/) for full documentation.
#'
#' @param destinationName &#91;required&#93; A name for an existing destination.
#' @param accessPolicy &#91;required&#93; An IAM policy document that authorizes cross-account users to deliver
#' their log events to the associated destination. This can be up to 5120
#' bytes.
#' @param forceUpdate Specify true if you are updating an existing destination policy to grant
#' permission to an organization ID instead of granting permission to
#' individual Amazon Web Services accounts. Before you update a destination
#' policy this way, you must first update the subscription filters in the
#' accounts that send logs to this destination. If you do not, the
#' subscription filters might stop working. By specifying `true` for
#' `forceUpdate`, you are affirming that you have already updated the
#' subscription filters. For more information, see [Updating an existing
#' cross-account
#' subscription](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html)
#' 
#' If you omit this parameter, the default of `false` is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_destination_policy
cloudwatchlogs_put_destination_policy <- function(destinationName, accessPolicy, forceUpdate = NULL) {
  op <- new_operation(
    name = "PutDestinationPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_destination_policy_input(destinationName = destinationName, accessPolicy = accessPolicy, forceUpdate = forceUpdate)
  output <- .cloudwatchlogs$put_destination_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_destination_policy <- cloudwatchlogs_put_destination_policy

#' Uploads a batch of log events to the specified log stream
#'
#' @description
#' Uploads a batch of log events to the specified log stream.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_log_events/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_log_events/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' @param logEvents &#91;required&#93; The log events.
#' @param sequenceToken The sequence token obtained from the response of the previous
#' [`put_log_events`][cloudwatchlogs_put_log_events] call.
#' 
#' The `sequenceToken` parameter is now ignored in
#' [`put_log_events`][cloudwatchlogs_put_log_events] actions.
#' [`put_log_events`][cloudwatchlogs_put_log_events] actions are now
#' accepted and never return `InvalidSequenceTokenException` or
#' `DataAlreadyAcceptedException` even if the sequence token is not valid.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_log_events
cloudwatchlogs_put_log_events <- function(logGroupName, logStreamName, logEvents, sequenceToken = NULL) {
  op <- new_operation(
    name = "PutLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_log_events_input(logGroupName = logGroupName, logStreamName = logStreamName, logEvents = logEvents, sequenceToken = sequenceToken)
  output <- .cloudwatchlogs$put_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_log_events <- cloudwatchlogs_put_log_events

#' Creates or updates a metric filter and associates it with the specified
#' log group
#'
#' @description
#' Creates or updates a metric filter and associates it with the specified log group. With metric filters, you can configure rules to extract metric data from log events ingested through [`put_log_events`][cloudwatchlogs_put_log_events].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_metric_filter/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_metric_filter/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; A name for the metric filter.
#' @param filterPattern &#91;required&#93; A filter pattern for extracting metric data out of ingested log events.
#' @param metricTransformations &#91;required&#93; A collection of information that defines how metric data gets emitted.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_metric_filter
cloudwatchlogs_put_metric_filter <- function(logGroupName, filterName, filterPattern, metricTransformations) {
  op <- new_operation(
    name = "PutMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_metric_filter_input(logGroupName = logGroupName, filterName = filterName, filterPattern = filterPattern, metricTransformations = metricTransformations)
  output <- .cloudwatchlogs$put_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_metric_filter <- cloudwatchlogs_put_metric_filter

#' Creates or updates a query definition for CloudWatch Logs Insights
#'
#' @description
#' Creates or updates a query definition for CloudWatch Logs Insights. For more information, see [Analyzing Log Data with CloudWatch Logs Insights](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_query_definition/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_query_definition/) for full documentation.
#'
#' @param name &#91;required&#93; A name for the query definition. If you are saving numerous query
#' definitions, we recommend that you name them. This way, you can find the
#' ones you want by using the first part of the name as a filter in the
#' `queryDefinitionNamePrefix` parameter of
#' [`describe_query_definitions`][cloudwatchlogs_describe_query_definitions].
#' @param queryDefinitionId If you are updating a query definition, use this parameter to specify
#' the ID of the query definition that you want to update. You can use
#' [`describe_query_definitions`][cloudwatchlogs_describe_query_definitions]
#' to retrieve the IDs of your saved query definitions.
#' 
#' If you are creating a query definition, do not specify this parameter.
#' CloudWatch generates a unique ID for the new query definition and
#' include it in the response to this operation.
#' @param logGroupNames Use this parameter to include specific log groups as part of your query
#' definition.
#' 
#' If you are updating a query definition and you omit this parameter, then
#' the updated definition will contain no log groups.
#' @param queryString &#91;required&#93; The query string to use for this definition. For more information, see
#' [CloudWatch Logs Insights Query
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_query_definition
cloudwatchlogs_put_query_definition <- function(name, queryDefinitionId = NULL, logGroupNames = NULL, queryString) {
  op <- new_operation(
    name = "PutQueryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_query_definition_input(name = name, queryDefinitionId = queryDefinitionId, logGroupNames = logGroupNames, queryString = queryString)
  output <- .cloudwatchlogs$put_query_definition_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_query_definition <- cloudwatchlogs_put_query_definition

#' Creates or updates a resource policy allowing other Amazon Web Services
#' services to put log events to this account, such as Amazon Route 53
#'
#' @description
#' Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_resource_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_resource_policy/) for full documentation.
#'
#' @param policyName Name of the new policy. This parameter is required.
#' @param policyDocument Details of the new policy, including the identity of the principal that
#' is enabled to put logs to this account. This is formatted as a JSON
#' string. This parameter is required.
#' 
#' The following example creates a resource policy enabling the Route 53
#' service to put DNS query logs in to the specified log group. Replace
#' `"logArn"` with the ARN of your CloudWatch Logs resource, such as a log
#' group or log stream.
#' 
#' CloudWatch Logs also supports
#' [aws:SourceArn](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn)
#' and
#' [aws:SourceAccount](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount)
#' condition context keys.
#' 
#' In the example resource policy, you would replace the value of
#' `SourceArn` with the resource making the call from Route 53 to
#' CloudWatch Logs. You would also replace the value of `SourceAccount`
#' with the Amazon Web Services account ID making that call.
#' 
#' `{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }`
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_resource_policy
cloudwatchlogs_put_resource_policy <- function(policyName = NULL, policyDocument = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_resource_policy_input(policyName = policyName, policyDocument = policyDocument)
  output <- .cloudwatchlogs$put_resource_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_resource_policy <- cloudwatchlogs_put_resource_policy

#' Sets the retention of the specified log group
#'
#' @description
#' Sets the retention of the specified log group. With a retention policy, you can configure the number of days for which to retain log events in the specified log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_retention_policy/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_retention_policy/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param retentionInDays &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_retention_policy
cloudwatchlogs_put_retention_policy <- function(logGroupName, retentionInDays) {
  op <- new_operation(
    name = "PutRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_retention_policy_input(logGroupName = logGroupName, retentionInDays = retentionInDays)
  output <- .cloudwatchlogs$put_retention_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_retention_policy <- cloudwatchlogs_put_retention_policy

#' Creates or updates a subscription filter and associates it with the
#' specified log group
#'
#' @description
#' Creates or updates a subscription filter and associates it with the specified log group. With subscription filters, you can subscribe to a real-time stream of log events ingested through [`put_log_events`][cloudwatchlogs_put_log_events] and have them delivered to a specific destination. When log events are sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_subscription_filter/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_subscription_filter/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; A name for the subscription filter. If you are updating an existing
#' filter, you must specify the correct name in `filterName`. To find the
#' name of the filter currently associated with a log group, use
#' [`describe_subscription_filters`][cloudwatchlogs_describe_subscription_filters].
#' @param filterPattern &#91;required&#93; A filter pattern for subscribing to a filtered stream of log events.
#' @param destinationArn &#91;required&#93; The ARN of the destination to deliver matching log events to. Currently,
#' the supported destinations are:
#' 
#' -   An Amazon Kinesis stream belonging to the same account as the
#'     subscription filter, for same-account delivery.
#' 
#' -   A logical destination (specified using an ARN) belonging to a
#'     different account, for cross-account delivery.
#' 
#'     If you're setting up a cross-account subscription, the destination
#'     must have an IAM policy associated with it. The IAM policy must
#'     allow the sender to send logs to the destination. For more
#'     information, see
#'     [`put_destination_policy`][cloudwatchlogs_put_destination_policy].
#' 
#' -   A Kinesis Data Firehose delivery stream belonging to the same
#'     account as the subscription filter, for same-account delivery.
#' 
#' -   A Lambda function belonging to the same account as the subscription
#'     filter, for same-account delivery.
#' @param roleArn The ARN of an IAM role that grants CloudWatch Logs permissions to
#' deliver ingested log events to the destination stream. You don't need to
#' provide the ARN when you are working with a logical destination for
#' cross-account delivery.
#' @param distribution The method used to distribute log data to the destination. By default,
#' log data is grouped by log stream, but the grouping can be set to random
#' for a more even distribution. This property is only applicable when the
#' destination is an Amazon Kinesis data stream.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_subscription_filter
cloudwatchlogs_put_subscription_filter <- function(logGroupName, filterName, filterPattern, destinationArn, roleArn = NULL, distribution = NULL) {
  op <- new_operation(
    name = "PutSubscriptionFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_subscription_filter_input(logGroupName = logGroupName, filterName = filterName, filterPattern = filterPattern, destinationArn = destinationArn, roleArn = roleArn, distribution = distribution)
  output <- .cloudwatchlogs$put_subscription_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_subscription_filter <- cloudwatchlogs_put_subscription_filter

#' Schedules a query of a log group using CloudWatch Logs Insights
#'
#' @description
#' Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group and time range to query and the query string to use.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_start_query/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_start_query/) for full documentation.
#'
#' @param logGroupName The log group on which to perform the query.
#' 
#' A [`start_query`][cloudwatchlogs_start_query] operation must include
#' exactly one of the following parameters: `logGroupName`, `logGroupNames`
#' or `logGroupIdentifiers`.
#' @param logGroupNames The list of log groups to be queried. You can include up to 50 log
#' groups.
#' 
#' A [`start_query`][cloudwatchlogs_start_query] operation must include
#' exactly one of the following parameters: `logGroupName`, `logGroupNames`
#' or `logGroupIdentifiers`.
#' @param logGroupIdentifiers The list of log groups to query. You can include up to 50 log groups.
#' 
#' You can specify them by the log group name or ARN. If a log group that
#' you're querying is in a source account and you're using a monitoring
#' account, you must specify the ARN of the log group here. The query
#' definition must also be defined in the monitoring account.
#' 
#' If you specify an ARN, the ARN can't end with an asterisk (*).
#' 
#' A [`start_query`][cloudwatchlogs_start_query] operation must include
#' exactly one of the following parameters: `logGroupName`, `logGroupNames`
#' or `logGroupIdentifiers`.
#' @param startTime &#91;required&#93; The beginning of the time range to query. The range is inclusive, so the
#' specified start time is included in the query. Specified as epoch time,
#' the number of seconds since `January 1, 1970, 00:00:00 UTC`.
#' @param endTime &#91;required&#93; The end of the time range to query. The range is inclusive, so the
#' specified end time is included in the query. Specified as epoch time,
#' the number of seconds since `January 1, 1970, 00:00:00 UTC`.
#' @param queryString &#91;required&#93; The query string to use. For more information, see [CloudWatch Logs
#' Insights Query
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
#' @param limit The maximum number of log events to return in the query. If the query
#' string uses the `fields` command, only the specified fields and their
#' values are returned. The default is 1000.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_start_query
cloudwatchlogs_start_query <- function(logGroupName = NULL, logGroupNames = NULL, logGroupIdentifiers = NULL, startTime, endTime, queryString, limit = NULL) {
  op <- new_operation(
    name = "StartQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$start_query_input(logGroupName = logGroupName, logGroupNames = logGroupNames, logGroupIdentifiers = logGroupIdentifiers, startTime = startTime, endTime = endTime, queryString = queryString, limit = limit)
  output <- .cloudwatchlogs$start_query_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$start_query <- cloudwatchlogs_start_query

#' Stops a CloudWatch Logs Insights query that is in progress
#'
#' @description
#' Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns an error indicating that the specified query is not running.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_stop_query/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_stop_query/) for full documentation.
#'
#' @param queryId &#91;required&#93; The ID number of the query to stop. To find this ID number, use
#' [`describe_queries`][cloudwatchlogs_describe_queries].
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_stop_query
cloudwatchlogs_stop_query <- function(queryId) {
  op <- new_operation(
    name = "StopQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$stop_query_input(queryId = queryId)
  output <- .cloudwatchlogs$stop_query_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$stop_query <- cloudwatchlogs_stop_query

#' The TagLogGroup operation is on the path to deprecation
#'
#' @description
#' The TagLogGroup operation is on the path to deprecation. We recommend that you use [`tag_resource`][cloudwatchlogs_tag_resource] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_tag_log_group/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_tag_log_group/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param tags &#91;required&#93; The key-value pairs to use for the tags.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_tag_log_group
cloudwatchlogs_tag_log_group <- function(logGroupName, tags) {
  op <- new_operation(
    name = "TagLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$tag_log_group_input(logGroupName = logGroupName, tags = tags)
  output <- .cloudwatchlogs$tag_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$tag_log_group <- cloudwatchlogs_tag_log_group

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' Logs resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource. Currently, the only CloudWatch Logs resources that can be tagged are log groups and destinations.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that you're adding tags to.
#' 
#' The ARN format of a log group is
#' `arn:aws:logs:Region:account-id:log-group:log-group-name `
#' 
#' The ARN format of a destination is
#' `arn:aws:logs:Region:account-id:destination:destination-name `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#' @param tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_tag_resource
cloudwatchlogs_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .cloudwatchlogs$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$tag_resource <- cloudwatchlogs_tag_resource

#' Tests the filter pattern of a metric filter against a sample of log
#' event messages
#'
#' @description
#' Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to validate the correctness of a metric filter pattern.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_test_metric_filter/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_test_metric_filter/) for full documentation.
#'
#' @param filterPattern &#91;required&#93; 
#' @param logEventMessages &#91;required&#93; The log event messages to test.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_test_metric_filter
cloudwatchlogs_test_metric_filter <- function(filterPattern, logEventMessages) {
  op <- new_operation(
    name = "TestMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$test_metric_filter_input(filterPattern = filterPattern, logEventMessages = logEventMessages)
  output <- .cloudwatchlogs$test_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$test_metric_filter <- cloudwatchlogs_test_metric_filter

#' The UntagLogGroup operation is on the path to deprecation
#'
#' @description
#' The UntagLogGroup operation is on the path to deprecation. We recommend that you use [`untag_resource`][cloudwatchlogs_untag_resource] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_untag_log_group/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_untag_log_group/) for full documentation.
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param tags &#91;required&#93; The tag keys. The corresponding tags are removed from the log group.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_untag_log_group
cloudwatchlogs_untag_log_group <- function(logGroupName, tags) {
  op <- new_operation(
    name = "UntagLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$untag_log_group_input(logGroupName = logGroupName, tags = tags)
  output <- .cloudwatchlogs$untag_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$untag_log_group <- cloudwatchlogs_untag_log_group

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchlogs_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchlogs_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the CloudWatch Logs resource that you're removing tags from.
#' 
#' The ARN format of a log group is
#' `arn:aws:logs:Region:account-id:log-group:log-group-name `
#' 
#' The ARN format of a destination is
#' `arn:aws:logs:Region:account-id:destination:destination-name `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_untag_resource
cloudwatchlogs_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .cloudwatchlogs$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$untag_resource <- cloudwatchlogs_untag_resource
