# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Auto Scaling Plans
#'
#' @description
#' AWS Auto Scaling
#' 
#' Use AWS Auto Scaling to create scaling plans for your applications to
#' automatically scale your scalable AWS resources.
#' 
#' **API Summary**
#' 
#' You can use the AWS Auto Scaling service API to accomplish the following
#' tasks:
#' 
#' -   Create and manage scaling plans
#' 
#' -   Define target tracking scaling policies to dynamically scale your
#'     resources based on utilization
#' 
#' -   Scale Amazon EC2 Auto Scaling groups using predictive scaling and
#'     dynamic scaling to scale your Amazon EC2 capacity faster
#' 
#' -   Set minimum and maximum capacity limits
#' 
#' -   Retrieve information on existing scaling plans
#' 
#' -   Access current forecast data and historical forecast data for up to
#'     56 days previous
#' 
#' To learn more about AWS Auto Scaling, including information about
#' granting IAM users required permissions for AWS Auto Scaling actions,
#' see the [AWS Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-a-scaling-plan.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- autoscalingplans(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- autoscalingplans()
#' svc$create_scaling_plan(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=autoscalingplans_create_scaling_plan]{create_scaling_plan} \tab Creates a scaling plan\cr
#'  \link[=autoscalingplans_delete_scaling_plan]{delete_scaling_plan} \tab Deletes the specified scaling plan\cr
#'  \link[=autoscalingplans_describe_scaling_plan_resources]{describe_scaling_plan_resources} \tab Describes the scalable resources in the specified scaling plan\cr
#'  \link[=autoscalingplans_describe_scaling_plans]{describe_scaling_plans} \tab Describes one or more of your scaling plans\cr
#'  \link[=autoscalingplans_get_scaling_plan_resource_forecast_data]{get_scaling_plan_resource_forecast_data} \tab Retrieves the forecast data for a scalable resource\cr
#'  \link[=autoscalingplans_update_scaling_plan]{update_scaling_plan} \tab Updates the specified scaling plan
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname autoscalingplans
#' @export
autoscalingplans <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .autoscalingplans$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.autoscalingplans <- list()

.autoscalingplans$operations <- list()

.autoscalingplans$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("*" = list(endpoint = "autoscaling-plans.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "autoscaling-plans.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "autoscaling-plans.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "autoscaling-plans.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Auto Scaling Plans",
  api_version = "2018-01-06",
  signing_name = "autoscaling-plans",
  json_version = "1.1",
  target_prefix = "AnyScaleScalingPlannerFrontendService"
)

.autoscalingplans$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.autoscalingplans$metadata, handlers, config)
}
