% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_update_stack_set}
\alias{cloudformation_update_stack_set}
\title{Updates the stack set, and associated stack instances in the specified
accounts and Amazon Web Services Regions}
\usage{
cloudformation_update_stack_set(
  StackSetName,
  Description = NULL,
  TemplateBody = NULL,
  TemplateURL = NULL,
  UsePreviousTemplate = NULL,
  Parameters = NULL,
  Capabilities = NULL,
  Tags = NULL,
  OperationPreferences = NULL,
  AdministrationRoleARN = NULL,
  ExecutionRoleName = NULL,
  DeploymentTargets = NULL,
  PermissionModel = NULL,
  AutoDeployment = NULL,
  OperationId = NULL,
  Accounts = NULL,
  Regions = NULL,
  CallAs = NULL,
  ManagedExecution = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to update.}

\item{Description}{A brief description of updates that you are making.}

\item{TemplateBody}{The structure that contains the template body, with a minimum length of
1 byte and a maximum length of 51,200 bytes. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}—or set \code{UsePreviousTemplate} to true.}

\item{TemplateURL}{The location of the file that contains the template body. The URL must
point to a template (maximum size: 460,800 bytes) that is located in an
Amazon S3 bucket or a Systems Manager document. For more information,
see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}—or set \code{UsePreviousTemplate} to true.}

\item{UsePreviousTemplate}{Use the existing template that's associated with the stack set that
you're updating.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}—or set \code{UsePreviousTemplate} to true.}

\item{Parameters}{A list of input parameters for the stack set template.}

\item{Capabilities}{In some cases, you must explicitly acknowledge that your stack template
contains certain capabilities in order for CloudFormation to update the
stack set and its associated stack instances.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your Amazon Web Services account; for example, by
creating new Identity and Access Management (IAM) users. For those
stacks sets, you must explicitly acknowledge this by specifying one
of these capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities,
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html}{AWS::IAM::Group}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html}{AWS::IAM::Policy}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html}{AWS::IAM::User}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see Acknowledging IAM Resources in
CloudFormation Templates.
\item \code{CAPABILITY_AUTO_EXPAND}

Some templates reference macros. If your stack set template
references one or more macros, you must update the stack set
directly from the processed template, without first reviewing the
resulting changes in a change set. To update the stack set directly,
you must acknowledge this capability. For more information, see
Using CloudFormation Macros to Perform Custom Processing on
Templates.

Stack sets with service-managed permissions do not currently support
the use of macros in templates. (This includes the AWS::Include and
AWS::Serverless transforms, which are macros hosted by
CloudFormation.) Even if you specify this capability for a stack set
with service-managed permissions, if you reference a macro in your
template the stack set operation will fail.
}}

\item{Tags}{The key-value pairs to associate with this stack set and the stacks
created from it. CloudFormation also propagates these tags to supported
resources that are created in the stacks. You can specify a maximum
number of 50 tags.

If you specify tags for this parameter, those tags replace any list of
tags that are currently associated with this stack set. This means:
\itemize{
\item If you don't specify this parameter, CloudFormation doesn't modify
the stack's tags.
\item If you specify \emph{any} tags using this parameter, you must specify
\emph{all} the tags that you want associated with this stack set, even
tags you've specified before (for example, when creating the stack
set or during a previous update of the stack set.). Any tags that
you don't include in the updated list of tags are removed from the
stack set, and therefore from the stacks and resources as well.
\item If you specify an empty value, CloudFormation removes all currently
associated tags.
}

If you specify new tags as part of an
\code{\link[=cloudformation_update_stack_set]{update_stack_set}} action,
CloudFormation checks to see if you have the required IAM permission to
tag resources. If you omit tags that are currently associated with the
stack set from the list of tags you specify, CloudFormation assumes that
you want to remove those tags from the stack set, and checks to see if
you have permission to untag resources. If you don't have the necessary
permission(s), the entire
\code{\link[=cloudformation_update_stack_set]{update_stack_set}} action fails with
an \verb{access denied} error, and the stack set is not updated.}

\item{OperationPreferences}{Preferences for how CloudFormation performs this stack set operation.}

\item{AdministrationRoleARN}{The Amazon Resource Name (ARN) of the IAM role to use to update this
stack set.

Specify an IAM role only if you are using customized administrator roles
to control which users or groups can manage specific stack sets within
the same administrator account. For more information, see Granting
Permissions for Stack Set Operations in the \emph{CloudFormation User Guide}.

If you specified a customized administrator role when you created the
stack set, you must specify a customized administrator role, even if it
is the same customized administrator role used with this stack set
previously.}

\item{ExecutionRoleName}{The name of the IAM execution role to use to update the stack set. If
you do not specify an execution role, CloudFormation uses the
\code{AWSCloudFormationStackSetExecutionRole} role for the stack set
operation.

Specify an IAM role only if you are using customized execution roles to
control which stack resources users and groups can include in their
stack sets.

If you specify a customized execution role, CloudFormation uses that
role to update the stack. If you do not specify a customized execution
role, CloudFormation performs the update using the role previously
associated with the stack set, so long as you have permissions to
perform operations on the stack set.}

\item{DeploymentTargets}{[Service-managed permissions] The Organizations accounts in which to
update associated stack instances.

To update all the stack instances associated with this stack set, do not
specify \code{DeploymentTargets} or \code{Regions}.

If the stack set update includes changes to the template (that is, if
\code{TemplateBody} or \code{TemplateURL} is specified), or the \code{Parameters},
CloudFormation marks all stack instances with a status of \code{OUTDATED}
prior to updating the stack instances in the specified accounts and
Amazon Web Services Regions. If the stack set update doesn't include
changes to the template or parameters, CloudFormation updates the stack
instances in the specified accounts and Regions, while leaving all other
stack instances with their existing stack instance status.}

\item{PermissionModel}{Describes how the IAM roles required for stack set operations are
created. You cannot modify \code{PermissionModel} if there are stack
instances associated with your stack set.
\itemize{
\item With \code{self-managed} permissions, you must create the administrator
and execution roles required to deploy to target accounts. For more
information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html}{Grant Self-Managed Stack Set Permissions}.
\item With \code{service-managed} permissions, StackSets automatically creates
the IAM roles required to deploy to accounts managed by
Organizations. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/}{Grant Service-Managed Stack Set Permissions}.
}}

\item{AutoDeployment}{[Service-managed permissions] Describes whether StackSets
automatically deploys to Organizations accounts that are added to a
target organization or organizational unit (OU).

If you specify \code{AutoDeployment}, don't specify \code{DeploymentTargets} or
\code{Regions}.}

\item{OperationId}{The unique ID for this stack set operation.

The operation ID also functions as an idempotency token, to ensure that
CloudFormation performs the stack set operation only once, even if you
retry the request multiple times. You might retry stack set operation
requests to ensure that CloudFormation successfully received them.

If you don't specify an operation ID, CloudFormation generates one
automatically.

Repeating this stack set operation with a new operation ID retries all
stack instances whose status is \code{OUTDATED}.}

\item{Accounts}{[Self-managed permissions] The accounts in which to update associated
stack instances. If you specify accounts, you must also specify the
Amazon Web Services Regions in which to update stack set instances.

To update \emph{all} the stack instances associated with this stack set,
don't specify the \code{Accounts} or \code{Regions} properties.

If the stack set update includes changes to the template (that is, if
the \code{TemplateBody} or \code{TemplateURL} properties are specified), or the
\code{Parameters} property, CloudFormation marks all stack instances with a
status of \code{OUTDATED} prior to updating the stack instances in the
specified accounts and Amazon Web Services Regions. If the stack set
update does not include changes to the template or parameters,
CloudFormation updates the stack instances in the specified accounts and
Amazon Web Services Regions, while leaving all other stack instances
with their existing stack instance status.}

\item{Regions}{The Amazon Web Services Regions in which to update associated stack
instances. If you specify Regions, you must also specify accounts in
which to update stack set instances.

To update \emph{all} the stack instances associated with this stack set, do
not specify the \code{Accounts} or \code{Regions} properties.

If the stack set update includes changes to the template (that is, if
the \code{TemplateBody} or \code{TemplateURL} properties are specified), or the
\code{Parameters} property, CloudFormation marks all stack instances with a
status of \code{OUTDATED} prior to updating the stack instances in the
specified accounts and Regions. If the stack set update does not include
changes to the template or parameters, CloudFormation updates the stack
instances in the specified accounts and Regions, while leaving all other
stack instances with their existing stack instance status.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}

\item{ManagedExecution}{Describes whether StackSets performs non-conflicting operations
concurrently and queues conflicting operations.}
}
\description{
Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_update_stack_set/} for full documentation.
}
\keyword{internal}
