% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_organizations_access}
\alias{cloudformation_describe_organizations_access}
\title{Retrieves information about the account's OrganizationAccess status}
\usage{
cloudformation_describe_organizations_access(CallAs = NULL)
}
\arguments{
\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Retrieves information about the account's \code{OrganizationAccess} status. This API can be called either by the management account or the delegated administrator by using the \code{CallAs} parameter. This API can also be called without the \code{CallAs} parameter by the management account.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_describe_organizations_access/} for full documentation.
}
\keyword{internal}
