% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_deactivate_key_signing_key}
\alias{route53_deactivate_key_signing_key}
\title{Deactivates a key signing key (KSK) so that it will not be used for
signing by DNSSEC}
\usage{
route53_deactivate_key_signing_key(HostedZoneId, Name)
}
\arguments{
\item{HostedZoneId}{[required] A unique string used to identify a hosted zone.}

\item{Name}{[required] An alphanumeric string used to identify a key signing key (KSK).}
}
\description{
Deactivates a key signing key (KSK) so that it will not be used for
signing by DNSSEC. This operation changes the KSK status to \code{INACTIVE}.
}
\section{Request syntax}{
\preformatted{svc$deactivate_key_signing_key(
  HostedZoneId = "string",
  Name = "string"
)
}
}

\keyword{internal}
