% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_delete_traffic_policy}
\alias{route53_delete_traffic_policy}
\title{Deletes a traffic policy}
\usage{
route53_delete_traffic_policy(Id, Version)
}
\arguments{
\item{Id}{[required] The ID of the traffic policy that you want to delete.}

\item{Version}{[required] The version number of the traffic policy that you want to delete.}
}
\description{
Deletes a traffic policy.

When you delete a traffic policy, Route 53 sets a flag on the policy to
indicate that it has been deleted. However, Route 53 never fully deletes
the traffic policy. Note the following:
\itemize{
\item Deleted traffic policies aren't listed if you run
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html}{ListTrafficPolicies}.
\item There's no way to get a list of deleted policies.
\item If you retain the ID of the policy, you can get information about
the policy, including the traffic policy document, by running
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html}{GetTrafficPolicy}.
}
}
\section{Request syntax}{
\preformatted{svc$delete_traffic_policy(
  Id = "string",
  Version = 123
)
}
}

\keyword{internal}
