# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appmesh_service.R
NULL

#' Creates a gateway route
#'
#' @description
#' Creates a gateway route.
#' 
#' A gateway route is attached to a virtual gateway and routes traffic to
#' an existing virtual service. If a route matches a request, it can
#' distribute traffic to a target virtual service.
#' 
#' For more information about gateway routes, see [Gateway
#' routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
#'
#' @usage
#' appmesh_create_gateway_route(clientToken, gatewayRouteName, meshName,
#'   meshOwner, spec, tags, virtualGatewayName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param gatewayRouteName &#91;required&#93; The name to use for the gateway route.
#' @param meshName &#91;required&#93; The name of the service mesh to create the gateway route in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The gateway route specification to apply.
#' @param tags Optional metadata that you can apply to the gateway route to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to associate the gateway route with. If
#' the virtual gateway is in a shared mesh, then you must be the owner of
#' the virtual gateway resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   gatewayRoute = list(
#'     gatewayRouteName = "string",
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           serviceName = "string"
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_gateway_route(
#'   clientToken = "string",
#'   gatewayRouteName = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     grpcRoute = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         serviceName = "string"
#'       )
#'     ),
#'     http2Route = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         prefix = "string"
#'       )
#'     ),
#'     httpRoute = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         prefix = "string"
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_gateway_route
appmesh_create_gateway_route <- function(clientToken = NULL, gatewayRouteName, meshName, meshOwner = NULL, spec, tags = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "CreateGatewayRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
    paginator = list()
  )
  input <- .appmesh$create_gateway_route_input(clientToken = clientToken, gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$create_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_gateway_route <- appmesh_create_gateway_route

#' Creates a service mesh
#'
#' @description
#' Creates a service mesh.
#' 
#' A service mesh is a logical boundary for network traffic between
#' services that are represented by resources within the mesh. After you
#' create your service mesh, you can create virtual services, virtual
#' nodes, virtual routers, and routes to distribute traffic between the
#' applications in your mesh.
#' 
#' For more information about service meshes, see [Service
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html).
#'
#' @usage
#' appmesh_create_mesh(clientToken, meshName, spec, tags)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name to use for the service mesh.
#' @param spec The service mesh specification to apply.
#' @param tags Optional metadata that you can apply to the service mesh to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   mesh = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       egressFilter = list(
#'         type = "ALLOW_ALL"|"DROP_ALL"
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_mesh(
#'   clientToken = "string",
#'   meshName = "string",
#'   spec = list(
#'     egressFilter = list(
#'       type = "ALLOW_ALL"|"DROP_ALL"
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_mesh
appmesh_create_mesh <- function(clientToken = NULL, meshName, spec = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateMesh",
    http_method = "PUT",
    http_path = "/v20190125/meshes",
    paginator = list()
  )
  input <- .appmesh$create_mesh_input(clientToken = clientToken, meshName = meshName, spec = spec, tags = tags)
  output <- .appmesh$create_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_mesh <- appmesh_create_mesh

#' Creates a route that is associated with a virtual router
#'
#' @description
#' Creates a route that is associated with a virtual router.
#' 
#' You can route several different protocols and define a retry policy for
#' a route. Traffic can be routed to one or more virtual nodes.
#' 
#' For more information about routes, see
#' [Routes](https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html).
#'
#' @usage
#' appmesh_create_route(clientToken, meshName, meshOwner, routeName, spec,
#'   tags, virtualRouterName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the route in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name to use for the route.
#' @param spec &#91;required&#93; The route specification to apply.
#' @param tags Optional metadata that you can apply to the route to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router in which to create the route. If the
#' virtual router is in a shared mesh, then you must be the owner of the
#' virtual router resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   route = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     routeName = "string",
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           metadata = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           methodName = "string",
#'           serviceName = "string"
#'         ),
#'         retryPolicy = list(
#'           grpcRetryEvents = list(
#'             "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'           ),
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       priority = 123,
#'       tcpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_route(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   routeName = "string",
#'   spec = list(
#'     grpcRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         metadata = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         methodName = "string",
#'         serviceName = "string"
#'       ),
#'       retryPolicy = list(
#'         grpcRetryEvents = list(
#'           "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'         ),
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     http2Route = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         headers = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'         prefix = "string",
#'         scheme = "http"|"https"
#'       ),
#'       retryPolicy = list(
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     httpRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         headers = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'         prefix = "string",
#'         scheme = "http"|"https"
#'       ),
#'       retryPolicy = list(
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     priority = 123,
#'     tcpRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_route
appmesh_create_route <- function(clientToken = NULL, meshName, meshOwner = NULL, routeName, spec, tags = NULL, virtualRouterName) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
    paginator = list()
  )
  input <- .appmesh$create_route_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, routeName = routeName, spec = spec, tags = tags, virtualRouterName = virtualRouterName)
  output <- .appmesh$create_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_route <- appmesh_create_route

#' Creates a virtual gateway
#'
#' @description
#' Creates a virtual gateway.
#' 
#' A virtual gateway allows resources outside your mesh to communicate to
#' resources that are inside your mesh. The virtual gateway represents an
#' Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or
#' on an Amazon EC2 instance. Unlike a virtual node, which represents an
#' Envoy running with an application, a virtual gateway represents Envoy
#' deployed by itself.
#' 
#' For more information about virtual gateways, see [Virtual
#' gateways](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
#'
#' @usage
#' appmesh_create_virtual_gateway(clientToken, meshName, meshOwner, spec,
#'   tags, virtualGatewayName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual gateway in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual gateway specification to apply.
#' @param tags Optional metadata that you can apply to the virtual gateway to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualGatewayName &#91;required&#93; The name to use for the virtual gateway.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualGateway = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc"
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_virtual_gateway(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     backendDefaults = list(
#'       clientPolicy = list(
#'         tls = list(
#'           enforce = TRUE|FALSE,
#'           ports = list(
#'             123
#'           ),
#'           validation = list(
#'             trust = list(
#'               acm = list(
#'                 certificateAuthorityArns = list(
#'                   "string"
#'                 )
#'               ),
#'               file = list(
#'                 certificateChain = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     listeners = list(
#'       list(
#'         connectionPool = list(
#'           grpc = list(
#'             maxRequests = 123
#'           ),
#'           http = list(
#'             maxConnections = 123,
#'             maxPendingRequests = 123
#'           ),
#'           http2 = list(
#'             maxRequests = 123
#'           )
#'         ),
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           intervalMillis = 123,
#'           path = "string",
#'           port = 123,
#'           protocol = "http"|"http2"|"grpc",
#'           timeoutMillis = 123,
#'           unhealthyThreshold = 123
#'         ),
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"http2"|"grpc"
#'         ),
#'         tls = list(
#'           certificate = list(
#'             acm = list(
#'               certificateArn = "string"
#'             ),
#'             file = list(
#'               certificateChain = "string",
#'               privateKey = "string"
#'             )
#'           ),
#'           mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'         )
#'       )
#'     ),
#'     logging = list(
#'       accessLog = list(
#'         file = list(
#'           path = "string"
#'         )
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_gateway
appmesh_create_virtual_gateway <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "CreateVirtualGateway",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways",
    paginator = list()
  )
  input <- .appmesh$create_virtual_gateway_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$create_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_gateway <- appmesh_create_virtual_gateway

#' Creates a virtual node within a service mesh
#'
#' @description
#' Creates a virtual node within a service mesh.
#' 
#' A virtual node acts as a logical pointer to a particular task group,
#' such as an Amazon ECS service or a Kubernetes deployment. When you
#' create a virtual node, you can specify the service discovery information
#' for your task group, and whether the proxy running in a task group will
#' communicate with other proxies using Transport Layer Security (TLS).
#' 
#' You define a `listener` for any inbound traffic that your virtual node
#' expects. Any virtual service that your virtual node expects to
#' communicate to is specified as a `backend`.
#' 
#' The response metadata for your new virtual node contains the `arn` that
#' is associated with the virtual node. Set this value to the full ARN; for
#' example,
#' `arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp`)
#' as the `APPMESH_RESOURCE_ARN` environment variable for your task group's
#' Envoy proxy container in your task definition or pod spec. This is then
#' mapped to the `node.id` and `node.cluster` Envoy parameters.
#' 
#' By default, App Mesh uses the name of the resource you specified in
#' `APPMESH_RESOURCE_ARN` when Envoy is referring to itself in metrics and
#' traces. You can override this behavior by setting the
#' `APPMESH_RESOURCE_CLUSTER` environment variable with your own name.
#' 
#' AWS Cloud Map is not available in the eu-south-1 Region.
#' 
#' For more information about virtual nodes, see [Virtual
#' nodes](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html).
#' You must be using `1.15.0` or later of the Envoy image when setting
#' these variables. For more information about App Mesh Envoy variables,
#' see [Envoy
#' image](https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html)
#' in the AWS App Mesh User Guide.
#'
#' @usage
#' appmesh_create_virtual_node(clientToken, meshName, meshOwner, spec,
#'   tags, virtualNodeName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual node in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual node specification to apply.
#' @param tags Optional metadata that you can apply to the virtual node to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualNodeName &#91;required&#93; The name to use for the virtual node.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualNode = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       backends = list(
#'         list(
#'           virtualService = list(
#'             clientPolicy = list(
#'               tls = list(
#'                 enforce = TRUE|FALSE,
#'                 ports = list(
#'                   123
#'                 ),
#'                 validation = list(
#'                   trust = list(
#'                     acm = list(
#'                       certificateAuthorityArns = list(
#'                         "string"
#'                       )
#'                     ),
#'                     file = list(
#'                       certificateChain = "string"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             ),
#'             tcp = list(
#'               maxConnections = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           outlierDetection = list(
#'             baseEjectionDuration = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             interval = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             maxEjectionPercent = 123,
#'             maxServerErrors = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           ),
#'           timeout = list(
#'             grpc = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http2 = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             tcp = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             )
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       ),
#'       serviceDiscovery = list(
#'         awsCloudMap = list(
#'           attributes = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           namespaceName = "string",
#'           serviceName = "string"
#'         ),
#'         dns = list(
#'           hostname = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualNodeName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_virtual_node(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     backendDefaults = list(
#'       clientPolicy = list(
#'         tls = list(
#'           enforce = TRUE|FALSE,
#'           ports = list(
#'             123
#'           ),
#'           validation = list(
#'             trust = list(
#'               acm = list(
#'                 certificateAuthorityArns = list(
#'                   "string"
#'                 )
#'               ),
#'               file = list(
#'                 certificateChain = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     backends = list(
#'       list(
#'         virtualService = list(
#'           clientPolicy = list(
#'             tls = list(
#'               enforce = TRUE|FALSE,
#'               ports = list(
#'                 123
#'               ),
#'               validation = list(
#'                 trust = list(
#'                   acm = list(
#'                     certificateAuthorityArns = list(
#'                       "string"
#'                     )
#'                   ),
#'                   file = list(
#'                     certificateChain = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           virtualServiceName = "string"
#'         )
#'       )
#'     ),
#'     listeners = list(
#'       list(
#'         connectionPool = list(
#'           grpc = list(
#'             maxRequests = 123
#'           ),
#'           http = list(
#'             maxConnections = 123,
#'             maxPendingRequests = 123
#'           ),
#'           http2 = list(
#'             maxRequests = 123
#'           ),
#'           tcp = list(
#'             maxConnections = 123
#'           )
#'         ),
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           intervalMillis = 123,
#'           path = "string",
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc",
#'           timeoutMillis = 123,
#'           unhealthyThreshold = 123
#'         ),
#'         outlierDetection = list(
#'           baseEjectionDuration = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           interval = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           maxEjectionPercent = 123,
#'           maxServerErrors = 123
#'         ),
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc"
#'         ),
#'         timeout = list(
#'           grpc = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           http = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           http2 = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           tcp = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           )
#'         ),
#'         tls = list(
#'           certificate = list(
#'             acm = list(
#'               certificateArn = "string"
#'             ),
#'             file = list(
#'               certificateChain = "string",
#'               privateKey = "string"
#'             )
#'           ),
#'           mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'         )
#'       )
#'     ),
#'     logging = list(
#'       accessLog = list(
#'         file = list(
#'           path = "string"
#'         )
#'       )
#'     ),
#'     serviceDiscovery = list(
#'       awsCloudMap = list(
#'         attributes = list(
#'           list(
#'             key = "string",
#'             value = "string"
#'           )
#'         ),
#'         namespaceName = "string",
#'         serviceName = "string"
#'       ),
#'       dns = list(
#'         hostname = "string"
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualNodeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_node
appmesh_create_virtual_node <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualNodeName) {
  op <- new_operation(
    name = "CreateVirtualNode",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes",
    paginator = list()
  )
  input <- .appmesh$create_virtual_node_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualNodeName = virtualNodeName)
  output <- .appmesh$create_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_node <- appmesh_create_virtual_node

#' Creates a virtual router within a service mesh
#'
#' @description
#' Creates a virtual router within a service mesh.
#' 
#' Specify a `listener` for any inbound traffic that your virtual router
#' receives. Create a virtual router for each protocol and port that you
#' need to route. Virtual routers handle traffic for one or more virtual
#' services within your mesh. After you create your virtual router, create
#' and associate routes for your virtual router that direct incoming
#' requests to different virtual nodes.
#' 
#' For more information about virtual routers, see [Virtual
#' routers](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html).
#'
#' @usage
#' appmesh_create_virtual_router(clientToken, meshName, meshOwner, spec,
#'   tags, virtualRouterName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual router in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual router specification to apply.
#' @param tags Optional metadata that you can apply to the virtual router to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualRouterName &#91;required&#93; The name to use for the virtual router.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualRouter = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       listeners = list(
#'         list(
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_virtual_router(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     listeners = list(
#'       list(
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc"
#'         )
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_router
appmesh_create_virtual_router <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualRouterName) {
  op <- new_operation(
    name = "CreateVirtualRouter",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters",
    paginator = list()
  )
  input <- .appmesh$create_virtual_router_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualRouterName = virtualRouterName)
  output <- .appmesh$create_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_router <- appmesh_create_virtual_router

#' Creates a virtual service within a service mesh
#'
#' @description
#' Creates a virtual service within a service mesh.
#' 
#' A virtual service is an abstraction of a real service that is provided
#' by a virtual node directly or indirectly by means of a virtual router.
#' Dependent services call your virtual service by its
#' `virtualServiceName`, and those requests are routed to the virtual node
#' or virtual router that is specified as the provider for the virtual
#' service.
#' 
#' For more information about virtual services, see [Virtual
#' services](https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html).
#'
#' @usage
#' appmesh_create_virtual_service(clientToken, meshName, meshOwner, spec,
#'   tags, virtualServiceName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual service in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then the account that you specify must share the mesh with
#' your account before you can create the resource in the service mesh. For
#' more information about mesh sharing, see [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual service specification to apply.
#' @param tags Optional metadata that you can apply to the virtual service to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualServiceName &#91;required&#93; The name to use for the virtual service.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualService = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       provider = list(
#'         virtualNode = list(
#'           virtualNodeName = "string"
#'         ),
#'         virtualRouter = list(
#'           virtualRouterName = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualServiceName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_virtual_service(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     provider = list(
#'       virtualNode = list(
#'         virtualNodeName = "string"
#'       ),
#'       virtualRouter = list(
#'         virtualRouterName = "string"
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   virtualServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_service
appmesh_create_virtual_service <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualServiceName) {
  op <- new_operation(
    name = "CreateVirtualService",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualServices",
    paginator = list()
  )
  input <- .appmesh$create_virtual_service_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualServiceName = virtualServiceName)
  output <- .appmesh$create_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_service <- appmesh_create_virtual_service

#' Deletes an existing gateway route
#'
#' @description
#' Deletes an existing gateway route.
#'
#' @usage
#' appmesh_delete_gateway_route(gatewayRouteName, meshName, meshOwner,
#'   virtualGatewayName)
#'
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to delete.
#' @param meshName &#91;required&#93; The name of the service mesh to delete the gateway route from.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to delete the route from.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   gatewayRoute = list(
#'     gatewayRouteName = "string",
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           serviceName = "string"
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_gateway_route(
#'   gatewayRouteName = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_gateway_route
appmesh_delete_gateway_route <- function(gatewayRouteName, meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DeleteGatewayRoute",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$delete_gateway_route_input(gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$delete_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_gateway_route <- appmesh_delete_gateway_route

#' Deletes an existing service mesh
#'
#' @description
#' Deletes an existing service mesh.
#' 
#' You must delete all resources (virtual services, routes, virtual
#' routers, and virtual nodes) in the service mesh before you can delete
#' the mesh itself.
#'
#' @usage
#' appmesh_delete_mesh(meshName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   mesh = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       egressFilter = list(
#'         type = "ALLOW_ALL"|"DROP_ALL"
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_mesh(
#'   meshName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_mesh
appmesh_delete_mesh <- function(meshName) {
  op <- new_operation(
    name = "DeleteMesh",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$delete_mesh_input(meshName = meshName)
  output <- .appmesh$delete_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_mesh <- appmesh_delete_mesh

#' Deletes an existing route
#'
#' @description
#' Deletes an existing route.
#'
#' @usage
#' appmesh_delete_route(meshName, meshOwner, routeName, virtualRouterName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the route in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to delete.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to delete the route in.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   route = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     routeName = "string",
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           metadata = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           methodName = "string",
#'           serviceName = "string"
#'         ),
#'         retryPolicy = list(
#'           grpcRetryEvents = list(
#'             "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'           ),
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       priority = 123,
#'       tcpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_route(
#'   meshName = "string",
#'   meshOwner = "string",
#'   routeName = "string",
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_route
appmesh_delete_route <- function(meshName, meshOwner = NULL, routeName, virtualRouterName) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$delete_route_input(meshName = meshName, meshOwner = meshOwner, routeName = routeName, virtualRouterName = virtualRouterName)
  output <- .appmesh$delete_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_route <- appmesh_delete_route

#' Deletes an existing virtual gateway
#'
#' @description
#' Deletes an existing virtual gateway. You cannot delete a virtual gateway
#' if any gateway routes are associated to it.
#'
#' @usage
#' appmesh_delete_virtual_gateway(meshName, meshOwner, virtualGatewayName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual gateway from.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualGateway = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc"
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_gateway(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_gateway
appmesh_delete_virtual_gateway <- function(meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DeleteVirtualGateway",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_gateway_input(meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$delete_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_gateway <- appmesh_delete_virtual_gateway

#' Deletes an existing virtual node
#'
#' @description
#' Deletes an existing virtual node.
#' 
#' You must delete any virtual services that list a virtual node as a
#' service provider before you can delete the virtual node itself.
#'
#' @usage
#' appmesh_delete_virtual_node(meshName, meshOwner, virtualNodeName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual node in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualNode = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       backends = list(
#'         list(
#'           virtualService = list(
#'             clientPolicy = list(
#'               tls = list(
#'                 enforce = TRUE|FALSE,
#'                 ports = list(
#'                   123
#'                 ),
#'                 validation = list(
#'                   trust = list(
#'                     acm = list(
#'                       certificateAuthorityArns = list(
#'                         "string"
#'                       )
#'                     ),
#'                     file = list(
#'                       certificateChain = "string"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             ),
#'             tcp = list(
#'               maxConnections = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           outlierDetection = list(
#'             baseEjectionDuration = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             interval = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             maxEjectionPercent = 123,
#'             maxServerErrors = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           ),
#'           timeout = list(
#'             grpc = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http2 = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             tcp = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             )
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       ),
#'       serviceDiscovery = list(
#'         awsCloudMap = list(
#'           attributes = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           namespaceName = "string",
#'           serviceName = "string"
#'         ),
#'         dns = list(
#'           hostname = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualNodeName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_node(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualNodeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_node
appmesh_delete_virtual_node <- function(meshName, meshOwner = NULL, virtualNodeName) {
  op <- new_operation(
    name = "DeleteVirtualNode",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_node_input(meshName = meshName, meshOwner = meshOwner, virtualNodeName = virtualNodeName)
  output <- .appmesh$delete_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_node <- appmesh_delete_virtual_node

#' Deletes an existing virtual router
#'
#' @description
#' Deletes an existing virtual router.
#' 
#' You must delete any routes associated with the virtual router before you
#' can delete the router itself.
#'
#' @usage
#' appmesh_delete_virtual_router(meshName, meshOwner, virtualRouterName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual router in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualRouter = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       listeners = list(
#'         list(
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_router(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_router
appmesh_delete_virtual_router <- function(meshName, meshOwner = NULL, virtualRouterName) {
  op <- new_operation(
    name = "DeleteVirtualRouter",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_router_input(meshName = meshName, meshOwner = meshOwner, virtualRouterName = virtualRouterName)
  output <- .appmesh$delete_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_router <- appmesh_delete_virtual_router

#' Deletes an existing virtual service
#'
#' @description
#' Deletes an existing virtual service.
#'
#' @usage
#' appmesh_delete_virtual_service(meshName, meshOwner, virtualServiceName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual service in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualService = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       provider = list(
#'         virtualNode = list(
#'           virtualNodeName = "string"
#'         ),
#'         virtualRouter = list(
#'           virtualRouterName = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualServiceName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_service(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_service
appmesh_delete_virtual_service <- function(meshName, meshOwner = NULL, virtualServiceName) {
  op <- new_operation(
    name = "DeleteVirtualService",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_service_input(meshName = meshName, meshOwner = meshOwner, virtualServiceName = virtualServiceName)
  output <- .appmesh$delete_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_service <- appmesh_delete_virtual_service

#' Describes an existing gateway route
#'
#' @description
#' Describes an existing gateway route.
#'
#' @usage
#' appmesh_describe_gateway_route(gatewayRouteName, meshName, meshOwner,
#'   virtualGatewayName)
#'
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to describe.
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway that the gateway route is associated
#' with.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   gatewayRoute = list(
#'     gatewayRouteName = "string",
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           serviceName = "string"
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_gateway_route(
#'   gatewayRouteName = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_gateway_route
appmesh_describe_gateway_route <- function(gatewayRouteName, meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DescribeGatewayRoute",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$describe_gateway_route_input(gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$describe_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_gateway_route <- appmesh_describe_gateway_route

#' Describes an existing service mesh
#'
#' @description
#' Describes an existing service mesh.
#'
#' @usage
#' appmesh_describe_mesh(meshName, meshOwner)
#'
#' @param meshName &#91;required&#93; The name of the service mesh to describe.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   mesh = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       egressFilter = list(
#'         type = "ALLOW_ALL"|"DROP_ALL"
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_mesh(
#'   meshName = "string",
#'   meshOwner = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_mesh
appmesh_describe_mesh <- function(meshName, meshOwner = NULL) {
  op <- new_operation(
    name = "DescribeMesh",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$describe_mesh_input(meshName = meshName, meshOwner = meshOwner)
  output <- .appmesh$describe_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_mesh <- appmesh_describe_mesh

#' Describes an existing route
#'
#' @description
#' Describes an existing route.
#'
#' @usage
#' appmesh_describe_route(meshName, meshOwner, routeName,
#'   virtualRouterName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the route resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to describe.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router that the route is associated with.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   route = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     routeName = "string",
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           metadata = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           methodName = "string",
#'           serviceName = "string"
#'         ),
#'         retryPolicy = list(
#'           grpcRetryEvents = list(
#'             "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'           ),
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       priority = 123,
#'       tcpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_route(
#'   meshName = "string",
#'   meshOwner = "string",
#'   routeName = "string",
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_route
appmesh_describe_route <- function(meshName, meshOwner = NULL, routeName, virtualRouterName) {
  op <- new_operation(
    name = "DescribeRoute",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$describe_route_input(meshName = meshName, meshOwner = meshOwner, routeName = routeName, virtualRouterName = virtualRouterName)
  output <- .appmesh$describe_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_route <- appmesh_describe_route

#' Describes an existing virtual gateway
#'
#' @description
#' Describes an existing virtual gateway.
#'
#' @usage
#' appmesh_describe_virtual_gateway(meshName, meshOwner,
#'   virtualGatewayName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualGateway = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc"
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_virtual_gateway(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_gateway
appmesh_describe_virtual_gateway <- function(meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DescribeVirtualGateway",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_gateway_input(meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$describe_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_gateway <- appmesh_describe_virtual_gateway

#' Describes an existing virtual node
#'
#' @description
#' Describes an existing virtual node.
#'
#' @usage
#' appmesh_describe_virtual_node(meshName, meshOwner, virtualNodeName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual node resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualNode = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       backends = list(
#'         list(
#'           virtualService = list(
#'             clientPolicy = list(
#'               tls = list(
#'                 enforce = TRUE|FALSE,
#'                 ports = list(
#'                   123
#'                 ),
#'                 validation = list(
#'                   trust = list(
#'                     acm = list(
#'                       certificateAuthorityArns = list(
#'                         "string"
#'                       )
#'                     ),
#'                     file = list(
#'                       certificateChain = "string"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             ),
#'             tcp = list(
#'               maxConnections = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           outlierDetection = list(
#'             baseEjectionDuration = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             interval = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             maxEjectionPercent = 123,
#'             maxServerErrors = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           ),
#'           timeout = list(
#'             grpc = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http2 = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             tcp = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             )
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       ),
#'       serviceDiscovery = list(
#'         awsCloudMap = list(
#'           attributes = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           namespaceName = "string",
#'           serviceName = "string"
#'         ),
#'         dns = list(
#'           hostname = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualNodeName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_virtual_node(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualNodeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_node
appmesh_describe_virtual_node <- function(meshName, meshOwner = NULL, virtualNodeName) {
  op <- new_operation(
    name = "DescribeVirtualNode",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_node_input(meshName = meshName, meshOwner = meshOwner, virtualNodeName = virtualNodeName)
  output <- .appmesh$describe_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_node <- appmesh_describe_virtual_node

#' Describes an existing virtual router
#'
#' @description
#' Describes an existing virtual router.
#'
#' @usage
#' appmesh_describe_virtual_router(meshName, meshOwner, virtualRouterName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual router resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualRouter = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       listeners = list(
#'         list(
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_virtual_router(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_router
appmesh_describe_virtual_router <- function(meshName, meshOwner = NULL, virtualRouterName) {
  op <- new_operation(
    name = "DescribeVirtualRouter",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_router_input(meshName = meshName, meshOwner = meshOwner, virtualRouterName = virtualRouterName)
  output <- .appmesh$describe_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_router <- appmesh_describe_virtual_router

#' Describes an existing virtual service
#'
#' @description
#' Describes an existing virtual service.
#'
#' @usage
#' appmesh_describe_virtual_service(meshName, meshOwner,
#'   virtualServiceName)
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual service resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualService = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       provider = list(
#'         virtualNode = list(
#'           virtualNodeName = "string"
#'         ),
#'         virtualRouter = list(
#'           virtualRouterName = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualServiceName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_virtual_service(
#'   meshName = "string",
#'   meshOwner = "string",
#'   virtualServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_service
appmesh_describe_virtual_service <- function(meshName, meshOwner = NULL, virtualServiceName) {
  op <- new_operation(
    name = "DescribeVirtualService",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_service_input(meshName = meshName, meshOwner = meshOwner, virtualServiceName = virtualServiceName)
  output <- .appmesh$describe_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_service <- appmesh_describe_virtual_service

#' Returns a list of existing gateway routes that are associated to a
#' virtual gateway
#'
#' @description
#' Returns a list of existing gateway routes that are associated to a
#' virtual gateway.
#'
#' @usage
#' appmesh_list_gateway_routes(limit, meshName, meshOwner, nextToken,
#'   virtualGatewayName)
#'
#' @param limit The maximum number of results returned by
#' [`list_gateway_routes`][appmesh_list_gateway_routes] in paginated
#' output. When you use this parameter,
#' [`list_gateway_routes`][appmesh_list_gateway_routes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_gateway_routes`][appmesh_list_gateway_routes]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_gateway_routes`][appmesh_list_gateway_routes] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list gateway routes in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_gateway_routes`][appmesh_list_gateway_routes] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to list gateway routes in.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   gatewayRoutes = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       gatewayRouteName = "string",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123,
#'       virtualGatewayName = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_gateway_routes(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string",
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_gateway_routes
appmesh_list_gateway_routes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "ListGatewayRoutes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
    paginator = list()
  )
  input <- .appmesh$list_gateway_routes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$list_gateway_routes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_gateway_routes <- appmesh_list_gateway_routes

#' Returns a list of existing service meshes
#'
#' @description
#' Returns a list of existing service meshes.
#'
#' @usage
#' appmesh_list_meshes(limit, nextToken)
#'
#' @param limit The maximum number of results returned by
#' [`list_meshes`][appmesh_list_meshes] in paginated output. When you use
#' this parameter, [`list_meshes`][appmesh_list_meshes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_meshes`][appmesh_list_meshes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_meshes`][appmesh_list_meshes] returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_meshes`][appmesh_list_meshes] request where `limit` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   meshes = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_meshes(
#'   limit = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_meshes
appmesh_list_meshes <- function(limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListMeshes",
    http_method = "GET",
    http_path = "/v20190125/meshes",
    paginator = list()
  )
  input <- .appmesh$list_meshes_input(limit = limit, nextToken = nextToken)
  output <- .appmesh$list_meshes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_meshes <- appmesh_list_meshes

#' Returns a list of existing routes in a service mesh
#'
#' @description
#' Returns a list of existing routes in a service mesh.
#'
#' @usage
#' appmesh_list_routes(limit, meshName, meshOwner, nextToken,
#'   virtualRouterName)
#'
#' @param limit The maximum number of results returned by
#' [`list_routes`][appmesh_list_routes] in paginated output. When you use
#' this parameter, [`list_routes`][appmesh_list_routes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_routes`][appmesh_list_routes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_routes`][appmesh_list_routes] returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list routes in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_routes`][appmesh_list_routes] request where `limit` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to list routes in.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   routes = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       routeName = "string",
#'       version = 123,
#'       virtualRouterName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_routes(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string",
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_routes
appmesh_list_routes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL, virtualRouterName) {
  op <- new_operation(
    name = "ListRoutes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
    paginator = list()
  )
  input <- .appmesh$list_routes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken, virtualRouterName = virtualRouterName)
  output <- .appmesh$list_routes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_routes <- appmesh_list_routes

#' List the tags for an App Mesh resource
#'
#' @description
#' List the tags for an App Mesh resource.
#'
#' @usage
#' appmesh_list_tags_for_resource(limit, nextToken, resourceArn)
#'
#' @param limit The maximum number of tag results returned by
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] in paginated
#' output. When this parameter is used,
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] request with
#' the returned `nextToken` value. This value can be between 1 and 100. If
#' you don't use this parameter,
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   limit = 123,
#'   nextToken = "string",
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_tags_for_resource
appmesh_list_tags_for_resource <- function(limit = NULL, nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v20190125/tags",
    paginator = list()
  )
  input <- .appmesh$list_tags_for_resource_input(limit = limit, nextToken = nextToken, resourceArn = resourceArn)
  output <- .appmesh$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_tags_for_resource <- appmesh_list_tags_for_resource

#' Returns a list of existing virtual gateways in a service mesh
#'
#' @description
#' Returns a list of existing virtual gateways in a service mesh.
#'
#' @usage
#' appmesh_list_virtual_gateways(limit, meshName, meshOwner, nextToken)
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] in paginated
#' output. When you use this parameter,
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_gateways`][appmesh_list_virtual_gateways]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual gateways in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   virtualGateways = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123,
#'       virtualGatewayName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_gateways(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_gateways
appmesh_list_virtual_gateways <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualGateways",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways",
    paginator = list()
  )
  input <- .appmesh$list_virtual_gateways_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_gateways_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_gateways <- appmesh_list_virtual_gateways

#' Returns a list of existing virtual nodes
#'
#' @description
#' Returns a list of existing virtual nodes.
#'
#' @usage
#' appmesh_list_virtual_nodes(limit, meshName, meshOwner, nextToken)
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] in paginated output.
#' When you use this parameter,
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] returns only `limit`
#' results in a single page along with a `nextToken` response element. You
#' can see the remaining results of the initial request by sending another
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter,
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual nodes in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] request where `limit`
#' was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   virtualNodes = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123,
#'       virtualNodeName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_nodes(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_nodes
appmesh_list_virtual_nodes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualNodes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes",
    paginator = list()
  )
  input <- .appmesh$list_virtual_nodes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_nodes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_nodes <- appmesh_list_virtual_nodes

#' Returns a list of existing virtual routers in a service mesh
#'
#' @description
#' Returns a list of existing virtual routers in a service mesh.
#'
#' @usage
#' appmesh_list_virtual_routers(limit, meshName, meshOwner, nextToken)
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_routers`][appmesh_list_virtual_routers] in paginated
#' output. When you use this parameter,
#' [`list_virtual_routers`][appmesh_list_virtual_routers] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_routers`][appmesh_list_virtual_routers]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_routers`][appmesh_list_virtual_routers] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual routers in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_routers`][appmesh_list_virtual_routers] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   virtualRouters = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123,
#'       virtualRouterName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_routers(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_routers
appmesh_list_virtual_routers <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualRouters",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters",
    paginator = list()
  )
  input <- .appmesh$list_virtual_routers_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_routers_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_routers <- appmesh_list_virtual_routers

#' Returns a list of existing virtual services in a service mesh
#'
#' @description
#' Returns a list of existing virtual services in a service mesh.
#'
#' @usage
#' appmesh_list_virtual_services(limit, meshName, meshOwner, nextToken)
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_services`][appmesh_list_virtual_services] in paginated
#' output. When you use this parameter,
#' [`list_virtual_services`][appmesh_list_virtual_services] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_services`][appmesh_list_virtual_services]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_services`][appmesh_list_virtual_services] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual services in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_services`][appmesh_list_virtual_services] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   virtualServices = list(
#'     list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshName = "string",
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       version = 123,
#'       virtualServiceName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_services(
#'   limit = 123,
#'   meshName = "string",
#'   meshOwner = "string",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_services
appmesh_list_virtual_services <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualServices",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualServices",
    paginator = list()
  )
  input <- .appmesh$list_virtual_services_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_services_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_services <- appmesh_list_virtual_services

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified
#' `resourceArn`. If existing tags on a resource aren't specified in the
#' request parameters, they aren't changed. When a resource is deleted, the
#' tags associated with that resource are also deleted.
#'
#' @usage
#' appmesh_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to add tags to.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' Tag keys can have a maximum character length of 128 characters, and tag
#' values can have a maximum length of 256 characters.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_tag_resource
appmesh_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/v20190125/tag",
    paginator = list()
  )
  input <- .appmesh$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .appmesh$tag_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$tag_resource <- appmesh_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' @usage
#' appmesh_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to delete tags from.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_untag_resource
appmesh_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "PUT",
    http_path = "/v20190125/untag",
    paginator = list()
  )
  input <- .appmesh$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .appmesh$untag_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$untag_resource <- appmesh_untag_resource

#' Updates an existing gateway route that is associated to a specified
#' virtual gateway in a service mesh
#'
#' @description
#' Updates an existing gateway route that is associated to a specified
#' virtual gateway in a service mesh.
#'
#' @usage
#' appmesh_update_gateway_route(clientToken, gatewayRouteName, meshName,
#'   meshOwner, spec, virtualGatewayName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to update.
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new gateway route specification to apply. This overwrites the
#' existing data.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway that the gateway route is associated
#' with.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   gatewayRoute = list(
#'     gatewayRouteName = "string",
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           serviceName = "string"
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           target = list(
#'             virtualService = list(
#'               virtualServiceName = "string"
#'             )
#'           )
#'         ),
#'         match = list(
#'           prefix = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_gateway_route(
#'   clientToken = "string",
#'   gatewayRouteName = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     grpcRoute = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         serviceName = "string"
#'       )
#'     ),
#'     http2Route = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         prefix = "string"
#'       )
#'     ),
#'     httpRoute = list(
#'       action = list(
#'         target = list(
#'           virtualService = list(
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       match = list(
#'         prefix = "string"
#'       )
#'     )
#'   ),
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_gateway_route
appmesh_update_gateway_route <- function(clientToken = NULL, gatewayRouteName, meshName, meshOwner = NULL, spec, virtualGatewayName) {
  op <- new_operation(
    name = "UpdateGatewayRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$update_gateway_route_input(clientToken = clientToken, gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$update_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_gateway_route <- appmesh_update_gateway_route

#' Updates an existing service mesh
#'
#' @description
#' Updates an existing service mesh.
#'
#' @usage
#' appmesh_update_mesh(clientToken, meshName, spec)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to update.
#' @param spec The service mesh specification to apply.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   mesh = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       egressFilter = list(
#'         type = "ALLOW_ALL"|"DROP_ALL"
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_mesh(
#'   clientToken = "string",
#'   meshName = "string",
#'   spec = list(
#'     egressFilter = list(
#'       type = "ALLOW_ALL"|"DROP_ALL"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_mesh
appmesh_update_mesh <- function(clientToken = NULL, meshName, spec = NULL) {
  op <- new_operation(
    name = "UpdateMesh",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$update_mesh_input(clientToken = clientToken, meshName = meshName, spec = spec)
  output <- .appmesh$update_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_mesh <- appmesh_update_mesh

#' Updates an existing route for a specified service mesh and virtual
#' router
#'
#' @description
#' Updates an existing route for a specified service mesh and virtual
#' router.
#'
#' @usage
#' appmesh_update_route(clientToken, meshName, meshOwner, routeName, spec,
#'   virtualRouterName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the route resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to update.
#' @param spec &#91;required&#93; The new route specification to apply. This overwrites the existing data.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router that the route is associated with.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   route = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     routeName = "string",
#'     spec = list(
#'       grpcRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           metadata = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           methodName = "string",
#'           serviceName = "string"
#'         ),
#'         retryPolicy = list(
#'           grpcRetryEvents = list(
#'             "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'           ),
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       http2Route = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       httpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         match = list(
#'           headers = list(
#'             list(
#'               invert = TRUE|FALSE,
#'               match = list(
#'                 exact = "string",
#'                 prefix = "string",
#'                 range = list(
#'                   end = 123,
#'                   start = 123
#'                 ),
#'                 regex = "string",
#'                 suffix = "string"
#'               ),
#'               name = "string"
#'             )
#'           ),
#'           method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'           prefix = "string",
#'           scheme = "http"|"https"
#'         ),
#'         retryPolicy = list(
#'           httpRetryEvents = list(
#'             "string"
#'           ),
#'           maxRetries = 123,
#'           perRetryTimeout = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           tcpRetryEvents = list(
#'             "connection-error"
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           perRequest = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       ),
#'       priority = 123,
#'       tcpRoute = list(
#'         action = list(
#'           weightedTargets = list(
#'             list(
#'               virtualNode = "string",
#'               weight = 123
#'             )
#'           )
#'         ),
#'         timeout = list(
#'           idle = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_route(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   routeName = "string",
#'   spec = list(
#'     grpcRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         metadata = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         methodName = "string",
#'         serviceName = "string"
#'       ),
#'       retryPolicy = list(
#'         grpcRetryEvents = list(
#'           "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
#'         ),
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     http2Route = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         headers = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'         prefix = "string",
#'         scheme = "http"|"https"
#'       ),
#'       retryPolicy = list(
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     httpRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       match = list(
#'         headers = list(
#'           list(
#'             invert = TRUE|FALSE,
#'             match = list(
#'               exact = "string",
#'               prefix = "string",
#'               range = list(
#'                 end = 123,
#'                 start = 123
#'               ),
#'               regex = "string",
#'               suffix = "string"
#'             ),
#'             name = "string"
#'           )
#'         ),
#'         method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
#'         prefix = "string",
#'         scheme = "http"|"https"
#'       ),
#'       retryPolicy = list(
#'         httpRetryEvents = list(
#'           "string"
#'         ),
#'         maxRetries = 123,
#'         perRetryTimeout = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         tcpRetryEvents = list(
#'           "connection-error"
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         ),
#'         perRequest = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     ),
#'     priority = 123,
#'     tcpRoute = list(
#'       action = list(
#'         weightedTargets = list(
#'           list(
#'             virtualNode = "string",
#'             weight = 123
#'           )
#'         )
#'       ),
#'       timeout = list(
#'         idle = list(
#'           unit = "s"|"ms",
#'           value = 123
#'         )
#'       )
#'     )
#'   ),
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_route
appmesh_update_route <- function(clientToken = NULL, meshName, meshOwner = NULL, routeName, spec, virtualRouterName) {
  op <- new_operation(
    name = "UpdateRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$update_route_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, routeName = routeName, spec = spec, virtualRouterName = virtualRouterName)
  output <- .appmesh$update_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_route <- appmesh_update_route

#' Updates an existing virtual gateway in a specified service mesh
#'
#' @description
#' Updates an existing virtual gateway in a specified service mesh.
#'
#' @usage
#' appmesh_update_virtual_gateway(clientToken, meshName, meshOwner, spec,
#'   virtualGatewayName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual gateway resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual gateway specification to apply. This overwrites the
#' existing data.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualGateway = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"http2"|"grpc"
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualGatewayName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_virtual_gateway(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     backendDefaults = list(
#'       clientPolicy = list(
#'         tls = list(
#'           enforce = TRUE|FALSE,
#'           ports = list(
#'             123
#'           ),
#'           validation = list(
#'             trust = list(
#'               acm = list(
#'                 certificateAuthorityArns = list(
#'                   "string"
#'                 )
#'               ),
#'               file = list(
#'                 certificateChain = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     listeners = list(
#'       list(
#'         connectionPool = list(
#'           grpc = list(
#'             maxRequests = 123
#'           ),
#'           http = list(
#'             maxConnections = 123,
#'             maxPendingRequests = 123
#'           ),
#'           http2 = list(
#'             maxRequests = 123
#'           )
#'         ),
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           intervalMillis = 123,
#'           path = "string",
#'           port = 123,
#'           protocol = "http"|"http2"|"grpc",
#'           timeoutMillis = 123,
#'           unhealthyThreshold = 123
#'         ),
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"http2"|"grpc"
#'         ),
#'         tls = list(
#'           certificate = list(
#'             acm = list(
#'               certificateArn = "string"
#'             ),
#'             file = list(
#'               certificateChain = "string",
#'               privateKey = "string"
#'             )
#'           ),
#'           mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'         )
#'       )
#'     ),
#'     logging = list(
#'       accessLog = list(
#'         file = list(
#'           path = "string"
#'         )
#'       )
#'     )
#'   ),
#'   virtualGatewayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_gateway
appmesh_update_virtual_gateway <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualGatewayName) {
  op <- new_operation(
    name = "UpdateVirtualGateway",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_gateway_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$update_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_gateway <- appmesh_update_virtual_gateway

#' Updates an existing virtual node in a specified service mesh
#'
#' @description
#' Updates an existing virtual node in a specified service mesh.
#'
#' @usage
#' appmesh_update_virtual_node(clientToken, meshName, meshOwner, spec,
#'   virtualNodeName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual node resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual node specification to apply. This overwrites the
#' existing data.
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualNode = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       backendDefaults = list(
#'         clientPolicy = list(
#'           tls = list(
#'             enforce = TRUE|FALSE,
#'             ports = list(
#'               123
#'             ),
#'             validation = list(
#'               trust = list(
#'                 acm = list(
#'                   certificateAuthorityArns = list(
#'                     "string"
#'                   )
#'                 ),
#'                 file = list(
#'                   certificateChain = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       backends = list(
#'         list(
#'           virtualService = list(
#'             clientPolicy = list(
#'               tls = list(
#'                 enforce = TRUE|FALSE,
#'                 ports = list(
#'                   123
#'                 ),
#'                 validation = list(
#'                   trust = list(
#'                     acm = list(
#'                       certificateAuthorityArns = list(
#'                         "string"
#'                       )
#'                     ),
#'                     file = list(
#'                       certificateChain = "string"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             virtualServiceName = "string"
#'           )
#'         )
#'       ),
#'       listeners = list(
#'         list(
#'           connectionPool = list(
#'             grpc = list(
#'               maxRequests = 123
#'             ),
#'             http = list(
#'               maxConnections = 123,
#'               maxPendingRequests = 123
#'             ),
#'             http2 = list(
#'               maxRequests = 123
#'             ),
#'             tcp = list(
#'               maxConnections = 123
#'             )
#'           ),
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             intervalMillis = 123,
#'             path = "string",
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc",
#'             timeoutMillis = 123,
#'             unhealthyThreshold = 123
#'           ),
#'           outlierDetection = list(
#'             baseEjectionDuration = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             interval = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             maxEjectionPercent = 123,
#'             maxServerErrors = 123
#'           ),
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           ),
#'           timeout = list(
#'             grpc = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             http2 = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               ),
#'               perRequest = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             ),
#'             tcp = list(
#'               idle = list(
#'                 unit = "s"|"ms",
#'                 value = 123
#'               )
#'             )
#'           ),
#'           tls = list(
#'             certificate = list(
#'               acm = list(
#'                 certificateArn = "string"
#'               ),
#'               file = list(
#'                 certificateChain = "string",
#'                 privateKey = "string"
#'               )
#'             ),
#'             mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'           )
#'         )
#'       ),
#'       logging = list(
#'         accessLog = list(
#'           file = list(
#'             path = "string"
#'           )
#'         )
#'       ),
#'       serviceDiscovery = list(
#'         awsCloudMap = list(
#'           attributes = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           namespaceName = "string",
#'           serviceName = "string"
#'         ),
#'         dns = list(
#'           hostname = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualNodeName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_virtual_node(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     backendDefaults = list(
#'       clientPolicy = list(
#'         tls = list(
#'           enforce = TRUE|FALSE,
#'           ports = list(
#'             123
#'           ),
#'           validation = list(
#'             trust = list(
#'               acm = list(
#'                 certificateAuthorityArns = list(
#'                   "string"
#'                 )
#'               ),
#'               file = list(
#'                 certificateChain = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     backends = list(
#'       list(
#'         virtualService = list(
#'           clientPolicy = list(
#'             tls = list(
#'               enforce = TRUE|FALSE,
#'               ports = list(
#'                 123
#'               ),
#'               validation = list(
#'                 trust = list(
#'                   acm = list(
#'                     certificateAuthorityArns = list(
#'                       "string"
#'                     )
#'                   ),
#'                   file = list(
#'                     certificateChain = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           virtualServiceName = "string"
#'         )
#'       )
#'     ),
#'     listeners = list(
#'       list(
#'         connectionPool = list(
#'           grpc = list(
#'             maxRequests = 123
#'           ),
#'           http = list(
#'             maxConnections = 123,
#'             maxPendingRequests = 123
#'           ),
#'           http2 = list(
#'             maxRequests = 123
#'           ),
#'           tcp = list(
#'             maxConnections = 123
#'           )
#'         ),
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           intervalMillis = 123,
#'           path = "string",
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc",
#'           timeoutMillis = 123,
#'           unhealthyThreshold = 123
#'         ),
#'         outlierDetection = list(
#'           baseEjectionDuration = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           interval = list(
#'             unit = "s"|"ms",
#'             value = 123
#'           ),
#'           maxEjectionPercent = 123,
#'           maxServerErrors = 123
#'         ),
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc"
#'         ),
#'         timeout = list(
#'           grpc = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           http = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           http2 = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             ),
#'             perRequest = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           ),
#'           tcp = list(
#'             idle = list(
#'               unit = "s"|"ms",
#'               value = 123
#'             )
#'           )
#'         ),
#'         tls = list(
#'           certificate = list(
#'             acm = list(
#'               certificateArn = "string"
#'             ),
#'             file = list(
#'               certificateChain = "string",
#'               privateKey = "string"
#'             )
#'           ),
#'           mode = "STRICT"|"PERMISSIVE"|"DISABLED"
#'         )
#'       )
#'     ),
#'     logging = list(
#'       accessLog = list(
#'         file = list(
#'           path = "string"
#'         )
#'       )
#'     ),
#'     serviceDiscovery = list(
#'       awsCloudMap = list(
#'         attributes = list(
#'           list(
#'             key = "string",
#'             value = "string"
#'           )
#'         ),
#'         namespaceName = "string",
#'         serviceName = "string"
#'       ),
#'       dns = list(
#'         hostname = "string"
#'       )
#'     )
#'   ),
#'   virtualNodeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_node
appmesh_update_virtual_node <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualNodeName) {
  op <- new_operation(
    name = "UpdateVirtualNode",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_node_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualNodeName = virtualNodeName)
  output <- .appmesh$update_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_node <- appmesh_update_virtual_node

#' Updates an existing virtual router in a specified service mesh
#'
#' @description
#' Updates an existing virtual router in a specified service mesh.
#'
#' @usage
#' appmesh_update_virtual_router(clientToken, meshName, meshOwner, spec,
#'   virtualRouterName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual router resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual router specification to apply. This overwrites the
#' existing data.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualRouter = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       listeners = list(
#'         list(
#'           portMapping = list(
#'             port = 123,
#'             protocol = "http"|"tcp"|"http2"|"grpc"
#'           )
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualRouterName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_virtual_router(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     listeners = list(
#'       list(
#'         portMapping = list(
#'           port = 123,
#'           protocol = "http"|"tcp"|"http2"|"grpc"
#'         )
#'       )
#'     )
#'   ),
#'   virtualRouterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_router
appmesh_update_virtual_router <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualRouterName) {
  op <- new_operation(
    name = "UpdateVirtualRouter",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_router_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualRouterName = virtualRouterName)
  output <- .appmesh$update_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_router <- appmesh_update_virtual_router

#' Updates an existing virtual service in a specified service mesh
#'
#' @description
#' Updates an existing virtual service in a specified service mesh.
#'
#' @usage
#' appmesh_update_virtual_service(clientToken, meshName, meshOwner, spec,
#'   virtualServiceName)
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual service resides in.
#' @param meshOwner The AWS IAM account ID of the service mesh owner. If the account ID is
#' not your own, then it's the ID of the account that shared the mesh with
#' your account. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual service specification to apply. This overwrites the
#' existing data.
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   virtualService = list(
#'     meshName = "string",
#'     metadata = list(
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       meshOwner = "string",
#'       resourceOwner = "string",
#'       uid = "string",
#'       version = 123
#'     ),
#'     spec = list(
#'       provider = list(
#'         virtualNode = list(
#'           virtualNodeName = "string"
#'         ),
#'         virtualRouter = list(
#'           virtualRouterName = "string"
#'         )
#'       )
#'     ),
#'     status = list(
#'       status = "ACTIVE"|"INACTIVE"|"DELETED"
#'     ),
#'     virtualServiceName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_virtual_service(
#'   clientToken = "string",
#'   meshName = "string",
#'   meshOwner = "string",
#'   spec = list(
#'     provider = list(
#'       virtualNode = list(
#'         virtualNodeName = "string"
#'       ),
#'       virtualRouter = list(
#'         virtualRouterName = "string"
#'       )
#'     )
#'   ),
#'   virtualServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_service
appmesh_update_virtual_service <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualServiceName) {
  op <- new_operation(
    name = "UpdateVirtualService",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_service_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualServiceName = virtualServiceName)
  output <- .appmesh$update_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_service <- appmesh_update_virtual_service
