% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_describe_load_balancer_attributes}
\alias{elb_describe_load_balancer_attributes}
\title{Describes the attributes for the specified load balancer}
\usage{
elb_describe_load_balancer_attributes(LoadBalancerName)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}
}
\value{
A list with the following syntax:\preformatted{list(
  LoadBalancerAttributes = list(
    CrossZoneLoadBalancing = list(
      Enabled = TRUE|FALSE
    ),
    AccessLog = list(
      Enabled = TRUE|FALSE,
      S3BucketName = "string",
      EmitInterval = 123,
      S3BucketPrefix = "string"
    ),
    ConnectionDraining = list(
      Enabled = TRUE|FALSE,
      Timeout = 123
    ),
    ConnectionSettings = list(
      IdleTimeout = 123
    ),
    AdditionalAttributes = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Describes the attributes for the specified load balancer.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancer_attributes(
  LoadBalancerName = "string"
)
}
}

\examples{
\dontrun{
# This example describes the attributes of the specified load balancer.
svc$describe_load_balancer_attributes(
  LoadBalancerName = "my-load-balancer"
)
}

}
\keyword{internal}
