% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_list_tags_for_resource}
\alias{servicediscovery_list_tags_for_resource}
\title{Lists tags for the specified resource}
\usage{
servicediscovery_list_tags_for_resource(ResourceARN)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the resource that you want to retrieve
tags for.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Lists tags for the specified resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string"
)
}
}

\examples{
\dontrun{
# This example lists the tags of a resource.
svc$list_tags_for_resource(
  ResourceARN = "arn:aws:servicediscovery:us-east-1:123456789012:namespace/ns-ylexjili4cdxy3xm"
)
}

}
\keyword{internal}
