% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_hosted_zone}
\alias{route53_create_hosted_zone}
\title{Creates a new public or private hosted zone}
\usage{
route53_create_hosted_zone(Name, VPC, CallerReference, HostedZoneConfig,
  DelegationSetId)
}
\arguments{
\item{Name}{[required] The name of the domain. Specify a fully qualified domain name, for
example, \emph{www.example.com}. The trailing dot is optional; Amazon Route
53 assumes that the domain name is fully qualified. This means that
Route 53 treats \emph{www.example.com} (without a trailing dot) and
\emph{www.example.com.} (with a trailing dot) as identical.

If you're creating a public hosted zone, this is the name you have
registered with your DNS registrar. If your domain name is registered
with a registrar other than Route 53, change the name servers for your
domain to the set of \code{NameServers} that \code{CreateHostedZone} returns in
\code{DelegationSet}.}

\item{VPC}{(Private hosted zones only) A complex type that contains information
about the Amazon VPC that you're associating with this hosted zone.

You can specify only one Amazon VPC when you create a private hosted
zone. To associate additional Amazon VPCs with the hosted zone, use
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html}{AssociateVPCWithHostedZone}
after you create a hosted zone.}

\item{CallerReference}{[required] A unique string that identifies the request and that allows failed
\code{CreateHostedZone} requests to be retried without the risk of executing
the operation twice. You must use a unique \code{CallerReference} string
every time you submit a \code{CreateHostedZone} request. \code{CallerReference}
can be any unique string, for example, a date/time stamp.}

\item{HostedZoneConfig}{(Optional) A complex type that contains the following optional values:
\itemize{
\item For public and private hosted zones, an optional comment
\item For private hosted zones, an optional \code{PrivateZone} element
}

If you don't specify a comment or the \code{PrivateZone} element, omit
\code{HostedZoneConfig} and the other elements.}

\item{DelegationSetId}{If you want to associate a reusable delegation set with this hosted
zone, the ID that Amazon Route 53 assigned to the reusable delegation
set when you created it. For more information about reusable delegation
sets, see
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html}{CreateReusableDelegationSet}.}
}
\description{
Creates a new public or private hosted zone. You create records in a
public hosted zone to define how you want to route traffic on the
internet for a domain, such as example.com, and its subdomains
(apex.example.com, acme.example.com). You create records in a private
hosted zone to define how you want to route traffic for a domain and its
subdomains within one or more Amazon Virtual Private Clouds (Amazon
VPCs).
}
\details{
You can't convert a public hosted zone to a private hosted zone or vice
versa. Instead, you must create a new hosted zone with the same name and
create new resource record sets.

For more information about charges for hosted zones, see \href{http://aws.amazon.com/route53/pricing/}{Amazon Route 53 Pricing}.

Note the following:
\itemize{
\item You can't create a hosted zone for a top-level domain (TLD) such as
.com.
\item For public hosted zones, Amazon Route 53 automatically creates a
default SOA record and four NS records for the zone. For more
information about SOA and NS records, see \href{http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html}{NS and SOA Records that Route 53 Creates for a Hosted Zone}
in the \emph{Amazon Route 53 Developer Guide}.
}

If you want to use the same name servers for multiple public hosted
zones, you can optionally associate a reusable delegation set with
the hosted zone. See the \code{DelegationSetId} element.
\itemize{
\item If your domain is registered with a registrar other than Route 53,
you must update the name servers with your registrar to make Route
53 the DNS service for the domain. For more information, see
\href{http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html}{Migrating DNS Service for an Existing Domain to Amazon Route 53}
in the \emph{Amazon Route 53 Developer Guide}.
}

When you submit a \code{CreateHostedZone} request, the initial status of the
hosted zone is \code{PENDING}. For public hosted zones, this means that the
NS and SOA records are not yet available on all Route 53 DNS servers.
When the NS and SOA records are available, the status of the zone
changes to \code{INSYNC}.
}
\section{Request syntax}{
\preformatted{svc$create_hosted_zone(
  Name = "string",
  VPC = list(
    VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1",
    VPCId = "string"
  ),
  CallerReference = "string",
  HostedZoneConfig = list(
    Comment = "string",
    PrivateZone = TRUE|FALSE
  ),
  DelegationSetId = "string"
)
}
}

\keyword{internal}
