% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_virtual_nodes}
\alias{appmesh_list_virtual_nodes}
\title{Returns a list of existing virtual nodes}
\usage{
appmesh_list_virtual_nodes(limit, meshName, nextToken)
}
\arguments{
\item{limit}{The maximum number of results returned by \code{ListVirtualNodes} in
paginated output. When you use this parameter, \code{ListVirtualNodes}
returns only \code{limit} results in a single page along with a \code{nextToken}
response element. You can see the remaining results of the initial
request by sending another \code{ListVirtualNodes} request with the returned
\code{nextToken} value. This value can be between 1 and 100. If you don\'t
use this parameter, \code{ListVirtualNodes} returns up to 100 results and a
\code{nextToken} value if applicable.}

\item{meshName}{[required] The name of the service mesh to list virtual nodes in.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListVirtualNodes} request where \code{limit} was used and the results
exceeded the value of that parameter. Pagination continues from the end
of the previous results that returned the \code{nextToken} value.}
}
\description{
Returns a list of existing virtual nodes.
}
\section{Request syntax}{
\preformatted{svc$list_virtual_nodes(
  limit = 123,
  meshName = "string",
  nextToken = "string"
)
}
}

\keyword{internal}
