% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_integration}
\alias{apigatewayv2_create_integration}
\title{Creates an Integration}
\usage{
apigatewayv2_create_integration(ApiId, ConnectionId, ConnectionType,
  ContentHandlingStrategy, CredentialsArn, Description, IntegrationMethod,
  IntegrationType, IntegrationUri, PassthroughBehavior,
  PayloadFormatVersion, RequestParameters, RequestTemplates,
  TemplateSelectionExpression, TimeoutInMillis, TlsConfig)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{ConnectionId}{The ID of the VPC link for a private integration. Supported only for
HTTP APIs.}

\item{ConnectionType}{The type of the network connection to the integration endpoint. Specify
INTERNET for connections through the public routable internet or
VPC\\_LINK for private connections between API Gateway and resources in a
VPC. The default value is INTERNET.}

\item{ContentHandlingStrategy}{Supported only for WebSocket APIs. Specifies how to handle response
payload content type conversions. Supported values are
CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the following behaviors:

CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
string to the corresponding binary blob.

CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
Base64-encoded string.

If this property is not defined, the response payload will be passed
through from the integration response to the route response or method
response without modification.}

\item{CredentialsArn}{Specifies the credentials required for the integration, if any. For AWS
integrations, three options are available. To specify an IAM Role for
API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To
require that the caller\'s identity be passed through from the request,
specify the string arn:aws:iam::\emph{:user/}. To use resource-based
permissions on supported AWS services, specify null.}

\item{Description}{The description of the integration.}

\item{IntegrationMethod}{Specifies the integration\'s HTTP method type.}

\item{IntegrationType}{[required] The integration type of an integration. One of the following:

AWS: for integrating the route or method request with an AWS service
action, including the Lambda function-invoking action. With the Lambda
function-invoking action, this is referred to as the Lambda custom
integration. With any other AWS service action, this is known as AWS
integration. Supported only for WebSocket APIs.

AWS\\_PROXY: for integrating the route or method request with the Lambda
function-invoking action with the client request passed through as-is.
This integration is also referred to as Lambda proxy integration.

HTTP: for integrating the route or method request with an HTTP endpoint.
This integration is also referred to as the HTTP custom integration.
Supported only for WebSocket APIs.

HTTP\\_PROXY: for integrating the route or method request with an HTTP
endpoint, with the client request passed through as-is. This is also
referred to as HTTP proxy integration. For HTTP API private
integrations, use an HTTP\\_PROXY integration.

MOCK: for integrating the route or method request with API Gateway as a
\"loopback\" endpoint without invoking any backend. Supported only for
WebSocket APIs.}

\item{IntegrationUri}{For a Lambda integration, specify the URI of a Lambda function.

For an HTTP integration, specify a fully-qualified URL.

For an HTTP API private integration, specify the ARN of an Application
Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map
service. If you specify the ARN of an AWS Cloud Map service, API Gateway
uses DiscoverInstances to identify resources. You can use query
parameters to target specific resources. To learn more, see
\href{https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html}{DiscoverInstances}.
For private integrations, all resources must be owned by the same AWS
account.}

\item{PassthroughBehavior}{Specifies the pass-through behavior for incoming requests based on the
Content-Type header in the request, and the available mapping templates
specified as the requestTemplates property on the Integration resource.
There are three valid values: WHEN\\_NO\\_MATCH, WHEN\\_NO\\_TEMPLATES, and
NEVER. Supported only for WebSocket APIs.

WHEN\\_NO\\_MATCH passes the request body for unmapped content types
through to the integration backend without transformation.

NEVER rejects unmapped content types with an HTTP 415 Unsupported Media
Type response.

WHEN\\_NO\\_TEMPLATES allows pass-through when the integration has no
content types mapped to templates. However, if there is at least one
content type defined, unmapped content types will be rejected with the
same HTTP 415 Unsupported Media Type response.}

\item{PayloadFormatVersion}{Specifies the format of the payload sent to an integration. Required for
HTTP APIs.}

\item{RequestParameters}{A key-value map specifying request parameters that are passed from the
method request to the backend. The key is an integration request
parameter name and the associated value is a method request parameter
value or static value that must be enclosed within single quotes and
pre-encoded as required by the backend. The method request parameter
value must match the pattern of method.request.\{location\}.\{name\} , where
\{location\} is querystring, path, or header; and \{name\} must be a valid
and unique method request parameter name. Supported only for WebSocket
APIs.}

\item{RequestTemplates}{Represents a map of Velocity templates that are applied on the request
payload based on the value of the Content-Type header sent by the
client. The content type value is the key in this map, and the template
(as a String) is the value. Supported only for WebSocket APIs.}

\item{TemplateSelectionExpression}{The template selection expression for the integration.}

\item{TimeoutInMillis}{Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and
between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is
29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.}

\item{TlsConfig}{The TLS configuration for a private integration. If you specify a TLS
configuration, private integration traffic uses the HTTPS protocol.
Supported only for HTTP APIs.}
}
\description{
Creates an Integration.
}
\section{Request syntax}{
\preformatted{svc$create_integration(
  ApiId = "string",
  ConnectionId = "string",
  ConnectionType = "INTERNET"|"VPC_LINK",
  ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
  CredentialsArn = "string",
  Description = "string",
  IntegrationMethod = "string",
  IntegrationType = "AWS"|"HTTP"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
  IntegrationUri = "string",
  PassthroughBehavior = "WHEN_NO_MATCH"|"NEVER"|"WHEN_NO_TEMPLATES",
  PayloadFormatVersion = "string",
  RequestParameters = list(
    "string"
  ),
  RequestTemplates = list(
    "string"
  ),
  TemplateSelectionExpression = "string",
  TimeoutInMillis = 123,
  TlsConfig = list(
    ServerNameToVerify = "string"
  )
)
}
}

\keyword{internal}
