% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_update_virtual_interface_attributes}
\alias{directconnect_update_virtual_interface_attributes}
\title{Updates the specified attributes of the specified virtual private
interface}
\usage{
directconnect_update_virtual_interface_attributes(virtualInterfaceId,
  mtu)
}
\arguments{
\item{virtualInterfaceId}{[required] The ID of the virtual private interface.}

\item{mtu}{The maximum transmission unit (MTU), in bytes. The supported values are
1500 and 9001. The default value is 1500.}
}
\description{
Updates the specified attributes of the specified virtual private
interface.
}
\details{
Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause
an update to the underlying physical connection if it wasn\'t updated to
support jumbo frames. Updating the connection disrupts network
connectivity for all virtual interfaces associated with the connection
for up to 30 seconds. To check whether your connection supports jumbo
frames, call DescribeConnections. To check whether your virtual q
interface supports jumbo frames, call DescribeVirtualInterfaces.
}
\section{Request syntax}{
\preformatted{svc$update_virtual_interface_attributes(
  virtualInterfaceId = "string",
  mtu = 123
)
}
}

\keyword{internal}
