% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_get_instances_health_status}
\alias{servicediscovery_get_instances_health_status}
\title{Gets the current health status (Healthy, Unhealthy, or Unknown) of one
or more instances that are associated with a specified service}
\usage{
servicediscovery_get_instances_health_status(ServiceId, Instances,
  MaxResults, NextToken)
}
\arguments{
\item{ServiceId}{[required] The ID of the service that the instance is associated with.}

\item{Instances}{An array that contains the IDs of all the instances that you want to get
the health status for.

If you omit \code{Instances}, AWS Cloud Map returns the health status for all
the instances that are associated with the specified service.

To get the IDs for the instances that you\'ve registered by using a
specified service, submit a
\href{https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html}{ListInstances}
request.}

\item{MaxResults}{The maximum number of instances that you want AWS Cloud Map to return in
the response to a \code{GetInstancesHealthStatus} request. If you don\'t
specify a value for \code{MaxResults}, AWS Cloud Map returns up to 100
instances.}

\item{NextToken}{For the first \code{GetInstancesHealthStatus} request, omit this value.

If more than \code{MaxResults} instances match the specified criteria, you
can submit another \code{GetInstancesHealthStatus} request to get the next
group of results. Specify the value of \code{NextToken} from the previous
response in the next request.}
}
\description{
Gets the current health status (\code{Healthy}, \code{Unhealthy}, or \code{Unknown}) of
one or more instances that are associated with a specified service.
}
\details{
There is a brief delay between when you register an instance and when
the health status for the instance is available.
}
\section{Request syntax}{
\preformatted{svc$get_instances_health_status(
  ServiceId = "string",
  Instances = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# This example gets the current health status of one or more instances
# that are associate with a specified service.
svc$get_instances_health_status(
  ServiceId = "srv-e4anhexample0004"
)
}

}
\keyword{internal}
