# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Route53 Recovery Cluster
#'
#' @description
#' Welcome to the Routing Control (Recovery Cluster) API Reference Guide
#' for Amazon Route 53 Application Recovery Controller.
#' 
#' With Route 53 ARC, you can use routing control with extreme reliability
#' to recover applications by rerouting traffic across Availability Zones
#' or Amazon Web Services Regions. Routing controls are simple on/off
#' switches hosted on a highly available cluster in Route 53 ARC. A cluster
#' provides a set of five redundant Regional endpoints against which you
#' can run API calls to get or update the state of routing controls. To
#' implement failover, you set one routing control to ON and another one to
#' OFF, to reroute traffic from one Availability Zone or Amazon Web
#' Services Region to another.
#' 
#' *Be aware that you must specify a Regional endpoint for a cluster when
#' you work with API cluster operations to get or update routing control
#' states in Route 53 ARC.* In addition, you must specify the US West
#' (Oregon) Region for Route 53 ARC API calls. For example, use the
#' parameter `--region us-west-2` with AWS CLI commands. For more
#' information, see [Get and update routing control states using the
#' API](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.api.html)
#' in the Amazon Route 53 Application Recovery Controller Developer Guide.
#' 
#' This API guide includes information about the API operations for how to
#' get and update routing control states in Route 53 ARC. To work with
#' routing control in Route 53 ARC, you must first create the required
#' components (clusters, control panels, and routing controls) using the
#' recovery cluster configuration API.
#' 
#' For more information about working with routing control in Route 53 ARC,
#' see the following:
#' 
#' -   Create clusters, control panels, and routing controls by using API
#'     operations. For more information, see the [Recovery Control
#'     Configuration API Reference Guide for Amazon Route 53 Application
#'     Recovery
#'     Controller](https://docs.aws.amazon.com/recovery-cluster/latest/api/).
#' 
#' -   Learn about the components in recovery control, including clusters,
#'     routing controls, and control panels, and how to work with Route 53
#'     ARC in the Amazon Web Services console. For more information, see
#'     [Recovery control
#'     components](https://docs.aws.amazon.com/r53recovery/latest/dg/introduction-components-zonal.html#introduction-components-routing)
#'     in the Amazon Route 53 Application Recovery Controller Developer
#'     Guide.
#' 
#' -   Route 53 ARC also provides readiness checks that continually audit
#'     resources to help make sure that your applications are scaled and
#'     ready to handle failover traffic. For more information about the
#'     related API operations, see the [Recovery Readiness API Reference
#'     Guide for Amazon Route 53 Application Recovery
#'     Controller](https://docs.aws.amazon.com/recovery-readiness/latest/api/).
#' 
#' -   For more information about creating resilient applications and
#'     preparing for recovery readiness with Route 53 ARC, see the [Amazon
#'     Route 53 Application Recovery Controller Developer
#'     Guide](https://docs.aws.amazon.com/r53recovery/latest/dg/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- route53recoverycluster(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- route53recoverycluster()
#' svc$get_routing_control_state(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=route53recoverycluster_get_routing_control_state]{get_routing_control_state} \tab Get the state for a routing control\cr
#'  \link[=route53recoverycluster_list_routing_controls]{list_routing_controls} \tab List routing control names and Amazon Resource Names (ARNs), as well as the routing control state for each routing control, along with the control panel name and control panel ARN for the routing controls\cr
#'  \link[=route53recoverycluster_update_routing_control_state]{update_routing_control_state} \tab Set the state of the routing control to reroute traffic\cr
#'  \link[=route53recoverycluster_update_routing_control_states]{update_routing_control_states} \tab Set multiple routing control states
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname route53recoverycluster
#' @export
route53recoverycluster <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .route53recoverycluster$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.route53recoverycluster <- list()

.route53recoverycluster$operations <- list()

.route53recoverycluster$metadata <- list(
  service_name = "route53recoverycluster",
  endpoints = list("*" = list(endpoint = "route53-recovery-cluster.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "route53-recovery-cluster.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "route53-recovery-cluster.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "route53-recovery-cluster.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "route53-recovery-cluster.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "route53-recovery-cluster.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Route53 Recovery Cluster",
  api_version = "2019-12-02",
  signing_name = "route53-recovery-cluster",
  json_version = "1.0",
  target_prefix = "ToggleCustomerAPI"
)

.route53recoverycluster$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.route53recoverycluster$metadata, handlers, config)
}
